/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.config;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.apache.distributedlog.common.config.ConcurrentConstConfiguration;
import org.apache.distributedlog.common.config.ConfigurationSubscription;
import org.apache.distributedlog.common.config.FileConfigurationBuilder;
import org.apache.distributedlog.common.config.PropertiesConfigurationBuilder;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.service.config.StreamConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamConfigProvider
implements StreamConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStreamConfigProvider.class);
    private final Optional<DynamicDistributedLogConfiguration> dynConf;
    private final ConfigurationSubscription confSub;

    public DefaultStreamConfigProvider(String configFilePath, ScheduledExecutorService executorService, int reloadPeriod, TimeUnit reloadUnit) throws ConfigurationException {
        try {
            File configFile = new File(configFilePath);
            PropertiesConfigurationBuilder properties = new PropertiesConfigurationBuilder(configFile.toURI().toURL());
            ConcurrentConstConfiguration defaultConf = new ConcurrentConstConfiguration((Configuration)new DistributedLogConfiguration());
            DynamicDistributedLogConfiguration conf = new DynamicDistributedLogConfiguration((ConcurrentBaseConfiguration)defaultConf);
            ArrayList fileConfigBuilders = Lists.newArrayList((Object[])new FileConfigurationBuilder[]{properties});
            this.confSub = new ConfigurationSubscription((ConcurrentBaseConfiguration)conf, (List)fileConfigBuilders, executorService, reloadPeriod, reloadUnit);
            this.dynConf = Optional.of((Object)conf);
        }
        catch (MalformedURLException ex) {
            throw new ConfigurationException((Throwable)ex);
        }
    }

    @Override
    public Optional<DynamicDistributedLogConfiguration> getDynamicStreamConfig(String streamName) {
        return this.dynConf;
    }
}

