/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream;

import com.google.common.base.Charsets;
import com.twitter.util.Future;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.acl.AccessControlManager;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.common.util.Sequencer;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.exceptions.RequestDeniedException;
import org.apache.distributedlog.protocol.util.TwitterFutureUtils;
import org.apache.distributedlog.service.ResponseUtils;
import org.apache.distributedlog.service.stream.AbstractWriteOp;
import org.apache.distributedlog.service.stream.StreamOpStats;
import org.apache.distributedlog.thrift.service.WriteResponse;
import scala.Function1;
import scala.runtime.AbstractFunction1;

public class HeartbeatOp
extends AbstractWriteOp {
    static final byte[] HEARTBEAT_DATA = "heartbeat".getBytes(Charsets.UTF_8);
    private final AccessControlManager accessControlManager;
    private final Counter deniedHeartbeatCounter;
    private final byte dlsnVersion;
    private boolean writeControlRecord = false;

    public HeartbeatOp(String stream, StatsLogger statsLogger, StatsLogger perStreamStatsLogger, byte dlsnVersion, Long checksum, Feature checksumDisabledFeature, AccessControlManager accessControlManager) {
        super(stream, HeartbeatOp.requestStat(statsLogger, "heartbeat"), checksum, checksumDisabledFeature);
        StreamOpStats streamOpStats = new StreamOpStats(statsLogger, perStreamStatsLogger);
        this.deniedHeartbeatCounter = streamOpStats.requestDeniedCounter("heartbeat");
        this.dlsnVersion = dlsnVersion;
        this.accessControlManager = accessControlManager;
    }

    public HeartbeatOp setWriteControlRecord(boolean writeControlRecord) {
        this.writeControlRecord = writeControlRecord;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Future<WriteResponse> executeOp(AsyncLogWriter writer, Sequencer sequencer, Object txnLock) {
        if (this.writeControlRecord) {
            Future writeResult;
            Object object = txnLock;
            synchronized (object) {
                long txnId = sequencer.nextId();
                LogRecord hbRecord = new LogRecord(txnId, HEARTBEAT_DATA);
                hbRecord.setControl();
                writeResult = TwitterFutureUtils.newTFuture((CompletableFuture)writer.write(hbRecord));
            }
            return writeResult.map((Function1)new AbstractFunction1<DLSN, WriteResponse>(){

                public WriteResponse apply(DLSN value) {
                    return ResponseUtils.writeSuccess().setDlsn(value.serialize(HeartbeatOp.this.dlsnVersion));
                }
            });
        }
        return Future.value((Object)ResponseUtils.writeSuccess());
    }

    @Override
    public void preExecute() throws DLException {
        if (!this.accessControlManager.allowAcquire(this.stream)) {
            this.deniedHeartbeatCounter.inc();
            throw new RequestDeniedException(this.stream, "heartbeat");
        }
        super.preExecute();
    }
}

