/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.twitter.common.stats.CounterMap;
import java.util.Map;

public class CounterMapWithTopKey<K>
extends CounterMap<K> {
    private K mostCommonKey = null;

    private int updateMostCommon(K k, int n) {
        if (n > this.get(this.mostCommonKey)) {
            this.mostCommonKey = k;
        }
        return n;
    }

    @Override
    public int incrementAndGet(K k) {
        return this.updateMostCommon(k, super.incrementAndGet(k));
    }

    @Override
    public void set(K k, int n) {
        super.set(k, this.updateMostCommon(k, n));
    }

    @Override
    public void reset(K k) {
        super.reset(k);
        for (Map.Entry entry : this) {
            this.updateMostCommon(entry.getKey(), entry.getValue());
        }
    }

    public K getMostCommonKey() {
        return this.mostCommonKey;
    }

    @Override
    public String toString() {
        return super.toString() + String.format("Most common key: %s\n", this.mostCommonKey.toString());
    }
}

