/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.net;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlHelper {
    private static final Logger LOG = Logger.getLogger(UrlHelper.class.getName());
    private static final Pattern URL_PROTOCOL_REGEX = Pattern.compile("^https?://", 2);

    public static String getDomain(String url) {
        try {
            return UrlHelper.getDomainChecked(url);
        }
        catch (URISyntaxException e) {
            LOG.finest("Malformed url: " + url);
            return null;
        }
    }

    public static String getDomainChecked(String url) throws URISyntaxException {
        Preconditions.checkNotNull((Object)url);
        url = UrlHelper.addProtocol(url);
        return new URI(url).getHost();
    }

    public static String getPath(String url) {
        Preconditions.checkNotNull((Object)url);
        url = UrlHelper.addProtocol(url);
        try {
            return new URI(url).getPath();
        }
        catch (URISyntaxException e) {
            LOG.info("Malformed url: " + url);
            return null;
        }
    }

    public static String stripUrlParameters(String url) {
        Preconditions.checkNotNull((Object)url);
        int paramStartIndex = url.indexOf("?");
        if (paramStartIndex == -1) {
            return url;
        }
        return url.substring(0, paramStartIndex);
    }

    public static String stripUrlParameters(URL url) {
        return UrlHelper.stripUrlParameters(url.toString());
    }

    public static String addProtocol(String url) {
        Preconditions.checkNotNull((Object)url);
        Matcher matcher = URL_PROTOCOL_REGEX.matcher(url);
        if (!matcher.find()) {
            url = "http://" + url;
        }
        return url;
    }

    public static List<String> getDomainLevels(String host) {
        Preconditions.checkNotNull((Object)host);
        if (!host.startsWith("www")) {
            host = "www." + host;
        }
        Joiner joiner = Joiner.on((String)".");
        LinkedList domainParts = Lists.newLinkedList(Arrays.asList(host.split("\\.")));
        LinkedList levels = Lists.newLinkedList();
        while (!domainParts.isEmpty()) {
            levels.add(joiner.join((Iterable)domainParts));
            domainParts.remove(0);
        }
        return levels;
    }
}

