/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.util;

import java.util.concurrent.atomic.AtomicLong;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u0017\t!2i\u001c8dkJ\u0014XM\u001c;SS:<')\u001e4gKJT!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b\u0019\tqAZ5oC\u001edWM\u0003\u0002\b\u0011\u00059Ao^5ui\u0016\u0014(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0016\u00051\u00113C\u0001\u0001\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\"AA\u0003\u0001B\u0001B\u0003%Q#\u0001\u0005dCB\f7-\u001b;z!\tqa#\u0003\u0002\u0018\u001f\t\u0019\u0011J\u001c;\t\u0011e\u0001!1!Q\u0001\fi\t!\"\u001a<jI\u0016t7-\u001a\u00132!\rYb\u0004I\u0007\u00029)\u0011QdD\u0001\be\u00164G.Z2u\u0013\tyBD\u0001\u0005DY\u0006\u001c8\u000fV1h!\t\t#\u0005\u0004\u0001\u0005\u000b\r\u0002!\u0019\u0001\u0013\u0003\u0003Q\u000b\"!\n\u0015\u0011\u000591\u0013BA\u0014\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AD\u0015\n\u0005)z!aA!os\")A\u0006\u0001C\u0001[\u00051A(\u001b8jiz\"\"A\f\u001a\u0015\u0005=\n\u0004c\u0001\u0019\u0001A5\t!\u0001C\u0003\u001aW\u0001\u000f!\u0004C\u0003\u0015W\u0001\u0007Q\u0003\u0003\u00045\u0001\u0001\u0006I!N\u0001\t]\u0016DHOU3bIB\u0011aGP\u0007\u0002o)\u0011\u0001(O\u0001\u0007CR|W.[2\u000b\u0005iZ\u0014AC2p]\u000e,(O]3oi*\u00111\u0001\u0010\u0006\u0002{\u0005!!.\u0019<b\u0013\tytG\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDa!\u0011\u0001!\u0002\u0013)\u0014!\u00038fqR<&/\u001b;f\u0011\u0019\u0019\u0005\u0001)A\u0005k\u0005q\u0001/\u001e2mSNDW\rZ,sSR,\u0007BB#\u0001A\u0003%a)\u0001\u0003sS:<\u0007c\u0001\bHA%\u0011\u0001j\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007\u0015\u0002\u0001K\u0011B&\u0002\u000fA,(\r\\5tQR\u0011Aj\u0014\t\u0003\u001d5K!AT\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006!&\u0003\r!U\u0001\u0006o\"L7\r\u001b\t\u0003\u001dIK!aU\b\u0003\t1{gn\u001a\u0005\u0006+\u0002!)AV\u0001\u0007iJLx)\u001a;\u0015\u0003]\u00032A\u0004-!\u0013\tIvB\u0001\u0004PaRLwN\u001c\u0015\u0003)n\u0003\"\u0001X0\u000e\u0003uS!AX\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002a;\n9A/Y5me\u0016\u001c\u0007\"\u00022\u0001\t\u000b\u0019\u0017a\u0002;ssB+Wm[\u000b\u0002/\")Q\r\u0001C\u0003M\u00061AO]=QkR$\"a\u001a6\u0011\u00059A\u0017BA5\u0010\u0005\u001d\u0011un\u001c7fC:DQa\u001b3A\u0002\u0001\n!!\u001a7)\u0005\u0011\\\u0006\"\u00028\u0001\t\u000by\u0017\u0001B:ju\u0016,\u0012!\u0006")
public class ConcurrentRingBuffer<T> {
    private final int capacity;
    private final AtomicLong nextRead;
    private final AtomicLong nextWrite;
    private final AtomicLong publishedWrite;
    private final Object ring;

    private void publish(long which) {
        while (this.publishedWrite.get() != which - 1L) {
        }
        boolean ok = this.publishedWrite.compareAndSet(which - 1L, which);
        Predef$.MODULE$.assert(ok);
    }

    public final Option<T> tryGet() {
        Object el;
        long r;
        do {
            long w;
            if ((w = this.publishedWrite.get()) < (r = this.nextRead.get())) {
                return None$.MODULE$;
            }
            el = ScalaRunTime$.MODULE$.array_apply(this.ring, (int)(r % (long)this.capacity));
        } while (!this.nextRead.compareAndSet(r, r + 1L));
        return new Some(el);
    }

    public final Option<T> tryPeek() {
        long r;
        long w = this.publishedWrite.get();
        return w < (r = this.nextRead.get()) ? None$.MODULE$ : new Some(ScalaRunTime$.MODULE$.array_apply(this.ring, (int)(r % (long)this.capacity)));
    }

    public final boolean tryPut(T el) {
        long r;
        long w;
        while ((w = this.nextWrite.get()) - (r = this.nextRead.get()) < (long)this.capacity) {
            if (!this.nextWrite.compareAndSet(w, w + 1L)) continue;
            ScalaRunTime$.MODULE$.array_update(this.ring, (int)(w % (long)this.capacity), el);
            this.publish(w);
            return true;
        }
        return false;
    }

    public final int size() {
        return (int)(this.nextWrite.get() - this.nextRead.get());
    }

    public ConcurrentRingBuffer(int capacity, ClassTag<T> evidence$1) {
        this.capacity = capacity;
        Predef$.MODULE$.assert(capacity > 0);
        this.nextRead = new AtomicLong(0L);
        this.nextWrite = new AtomicLong(0L);
        this.publishedWrite = new AtomicLong(-1L);
        this.ring = evidence$1.newArray(capacity);
    }
}

