/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.SafeRunnable;

public abstract class PacketProcessorBaseV3
extends SafeRunnable {
    final BookkeeperProtocol.Request request;
    final Channel channel;
    final BookieRequestProcessor requestProcessor;
    final long enqueueNanos;

    public PacketProcessorBaseV3(BookkeeperProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        this.request = request;
        this.channel = channel;
        this.requestProcessor = requestProcessor;
        this.enqueueNanos = MathUtils.nowInNano();
    }

    protected void sendResponse(final BookkeeperProtocol.StatusCode code, Object response, final OpStatsLogger statsLogger) {
        final long writeNanos = MathUtils.nowInNano();
        this.channel.writeAndFlush(response).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                long writeElapsedNanos = MathUtils.elapsedNanos(writeNanos);
                if (!future.isSuccess()) {
                    PacketProcessorBaseV3.this.requestProcessor.channelWriteStats.registerFailedEvent(writeElapsedNanos, TimeUnit.NANOSECONDS);
                } else {
                    PacketProcessorBaseV3.this.requestProcessor.channelWriteStats.registerSuccessfulEvent(writeElapsedNanos, TimeUnit.NANOSECONDS);
                }
                if (BookkeeperProtocol.StatusCode.EOK == code) {
                    statsLogger.registerSuccessfulEvent(MathUtils.elapsedNanos(PacketProcessorBaseV3.this.enqueueNanos), TimeUnit.NANOSECONDS);
                } else {
                    statsLogger.registerFailedEvent(MathUtils.elapsedNanos(PacketProcessorBaseV3.this.enqueueNanos), TimeUnit.NANOSECONDS);
                }
            }
        });
    }

    protected boolean isVersionCompatible() {
        return this.request.getHeader().getVersion().equals(BookkeeperProtocol.ProtocolVersion.VERSION_THREE);
    }

    protected BookkeeperProtocol.BKPacketHeader getHeader() {
        BookkeeperProtocol.BKPacketHeader.Builder header = BookkeeperProtocol.BKPacketHeader.newBuilder();
        header.setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE);
        header.setOperation(this.request.getHeader().getOperation());
        header.setTxnId(this.request.getHeader().getTxnId());
        return header.build();
    }

    public String toString() {
        return this.request.toString();
    }
}

