/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.distributedlog.EntryBuffer;
import org.apache.distributedlog.common.concurrent.FutureEventListener;
import org.apache.distributedlog.common.concurrent.FutureUtils;

class BKTransmitPacket {
    private final EntryBuffer recordSet;
    private final long transmitTime;
    private final CompletableFuture<Integer> transmitComplete;

    BKTransmitPacket(EntryBuffer recordSet) {
        this.recordSet = recordSet;
        this.transmitTime = System.nanoTime();
        this.transmitComplete = new CompletableFuture();
    }

    EntryBuffer getRecordSet() {
        return this.recordSet;
    }

    CompletableFuture<Integer> getTransmitFuture() {
        return this.transmitComplete;
    }

    public void notifyTransmitComplete(int transmitResult) {
        this.transmitComplete.complete(transmitResult);
    }

    void addTransmitCompleteListener(FutureEventListener<Integer> transmitCompleteListener) {
        this.transmitComplete.whenComplete((BiConsumer)transmitCompleteListener);
    }

    int awaitTransmitComplete(long timeout, TimeUnit unit) throws Exception {
        return (Integer)FutureUtils.result(this.transmitComplete, (long)timeout, (TimeUnit)unit);
    }

    public long getTransmitTime() {
        return this.transmitTime;
    }
}

