/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// EventTypeSpecApplyConfiguration represents an declarative configuration of the EventTypeSpec type for use
// with apply.
type EventTypeSpecApplyConfiguration struct {
	MediaType *string                            `json:"mediaType,omitempty"`
	Schema    *JSONSchemaPropsApplyConfiguration `json:"schema,omitempty"`
}

// EventTypeSpecApplyConfiguration constructs an declarative configuration of the EventTypeSpec type for use with
// apply.
func EventTypeSpec() *EventTypeSpecApplyConfiguration {
	return &EventTypeSpecApplyConfiguration{}
}

// WithMediaType sets the MediaType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MediaType field is set to the value of the last call.
func (b *EventTypeSpecApplyConfiguration) WithMediaType(value string) *EventTypeSpecApplyConfiguration {
	b.MediaType = &value
	return b
}

// WithSchema sets the Schema field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Schema field is set to the value of the last call.
func (b *EventTypeSpecApplyConfiguration) WithSchema(value *JSONSchemaPropsApplyConfiguration) *EventTypeSpecApplyConfiguration {
	b.Schema = value
	return b
}
