/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.integrationspec.template.spec.volumes.ConfigMapBuilder;
import org.apache.camel.v1.integrationspec.template.spec.volumes.configmap.Items;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"defaultMode", "items", "name", "optional"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class ConfigMap
implements Editable<ConfigMapBuilder>,
KubernetesResource {
    @JsonProperty(value="defaultMode")
    @JsonPropertyDescription(value="defaultMode is optional: mode bits used to set permissions on created files by default.\nMust be an octal value between 0000 and 0777 or a decimal value between 0 and 511.\nYAML accepts both octal and decimal values, JSON requires decimal values for mode bits.\nDefaults to 0644.\nDirectories within the path are not affected by this setting.\nThis might be in conflict with other options that affect the file\nmode, like fsGroup, and the result can be other mode bits set.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer defaultMode;
    @JsonProperty(value="items")
    @JsonPropertyDescription(value="items if unspecified, each key-value pair in the Data field of the referenced\nConfigMap will be projected into the volume as a file whose name is the\nkey and content is the value. If specified, the listed keys will be\nprojected into the specified paths, and unlisted keys will not be\npresent. If a key is specified which is not present in the ConfigMap,\nthe volume setup will error unless it is marked optional. Paths must be\nrelative and may not contain the '..' path or start with '..'.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Items> items;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the referent.\nMore info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names\nTODO: Add other useful fields. apiVersion, kind, uid?")
    @JsonSetter(nulls=Nulls.SKIP)
    private String name;
    @JsonProperty(value="optional")
    @JsonPropertyDescription(value="optional specify whether the ConfigMap or its keys must be defined")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean optional;

    public ConfigMapBuilder edit() {
        return new ConfigMapBuilder(this);
    }

    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
    }

    public List<Items> getItems() {
        return this.items;
    }

    public void setItems(List<Items> items) {
        this.items = items;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public String toString() {
        return "ConfigMap(defaultMode=" + this.getDefaultMode() + ", items=" + this.getItems() + ", name=" + this.getName() + ", optional=" + this.getOptional() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigMap)) {
            return false;
        }
        ConfigMap other = (ConfigMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$defaultMode = this.getDefaultMode();
        Integer other$defaultMode = other.getDefaultMode();
        if (this$defaultMode == null ? other$defaultMode != null : !((Object)this$defaultMode).equals(other$defaultMode)) {
            return false;
        }
        Boolean this$optional = this.getOptional();
        Boolean other$optional = other.getOptional();
        if (this$optional == null ? other$optional != null : !((Object)this$optional).equals(other$optional)) {
            return false;
        }
        List<Items> this$items = this.getItems();
        List<Items> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $defaultMode = this.getDefaultMode();
        result = result * 59 + ($defaultMode == null ? 43 : ((Object)$defaultMode).hashCode());
        Boolean $optional = this.getOptional();
        result = result * 59 + ($optional == null ? 43 : ((Object)$optional).hashCode());
        List<Items> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

