/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.BaseContext;
import org.apache.cayenne.CayenneContextChildDiffLoader;
import org.apache.cayenne.CayenneContextGraphManager;
import org.apache.cayenne.CayenneContextMergeHandler;
import org.apache.cayenne.CayenneContextQueryAction;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.Validating;
import org.apache.cayenne.cache.NestedQueryCache;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.EventUtil;
import org.apache.cayenne.validation.ValidationException;
import org.apache.cayenne.validation.ValidationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CayenneContext
extends BaseContext {
    CayenneContextGraphManager graphManager;
    CayenneContextMergeHandler mergeHandler;

    public CayenneContext() {
        this(null);
    }

    public CayenneContext(DataChannel channel) {
        this(channel, false, false);
    }

    public CayenneContext(DataChannel channel, boolean changeEventsEnabled, boolean lifecyleEventsEnabled) {
        this.graphManager = new CayenneContextGraphManager(this, changeEventsEnabled, lifecyleEventsEnabled);
        if (channel != null) {
            this.attachToChannel(channel);
        }
    }

    @Override
    protected void attachToChannel(DataChannel channel) {
        EventManager eventManager;
        super.attachToChannel(channel);
        if (this.mergeHandler != null) {
            this.mergeHandler.active = false;
            this.mergeHandler = null;
        }
        if ((eventManager = channel.getEventManager()) != null) {
            this.mergeHandler = new CayenneContextMergeHandler(this);
            EventUtil.listenForChannelEvents(channel, (DataChannelListener)this.mergeHandler);
        }
    }

    public boolean isChangeEventsEnabled() {
        return this.graphManager.changeEventsEnabled;
    }

    public boolean isLifecycleEventsEnabled() {
        return this.graphManager.lifecycleEventsEnabled;
    }

    @Override
    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    CayenneContextGraphManager internalGraphManager() {
        return this.graphManager;
    }

    @Override
    public void commitChanges() {
        this.doCommitChanges(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphDiff doCommitChanges(boolean cascade) {
        int syncType = cascade ? 2 : 1;
        GraphDiff commitDiff = null;
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                if (this.isValidatingObjectsOnCommit()) {
                    ValidationResult result = new ValidationResult();
                    for (Persistent persistent : this.graphManager.dirtyNodes()) {
                        if (!(persistent instanceof Validating)) continue;
                        switch (persistent.getPersistenceState()) {
                            case 2: {
                                ((Validating)((Object)persistent)).validateForInsert(result);
                                break;
                            }
                            case 4: {
                                ((Validating)((Object)persistent)).validateForUpdate(result);
                                break;
                            }
                            case 6: {
                                ((Validating)((Object)persistent)).validateForDelete(result);
                            }
                        }
                    }
                    if (result.hasFailures()) {
                        throw new ValidationException(result);
                    }
                }
                this.graphManager.graphCommitStarted();
                GraphDiff changes = this.graphManager.getDiffsSinceLastFlush();
                try {
                    commitDiff = this.channel.onSync(this, changes, syncType);
                }
                catch (Throwable th) {
                    this.graphManager.graphCommitAborted();
                    if (th instanceof CayenneRuntimeException) {
                        throw (CayenneRuntimeException)th;
                    }
                    throw new CayenneRuntimeException("Commit error", th, new Object[0]);
                }
                this.graphManager.graphCommitted(commitDiff);
                this.fireDataChannelCommitted(this, changes);
            }
        }
        return commitDiff;
    }

    @Override
    public void commitChangesToParent() {
        this.doCommitChanges(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackChanges() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                GraphDiff diff = this.graphManager.getDiffs();
                this.graphManager.graphReverted();
                this.channel.onSync(this, diff, 3);
                this.fireDataChannelRolledback(this, diff);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackChangesLocally() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                GraphDiff diff = this.graphManager.getDiffs();
                this.graphManager.graphReverted();
                this.fireDataChannelRolledback(this, diff);
            }
        }
    }

    @Override
    public <T> T newObject(Class<T> persistentClass) {
        if (persistentClass == null) {
            throw new NullPointerException("Persistent class can't be null.");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(persistentClass);
        if (entity == null) {
            throw new CayenneRuntimeException("No entity mapped for class: " + persistentClass, new Object[0]);
        }
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        Object object = descriptor.createObject();
        descriptor.injectValueHolders(object);
        this.registerNewObject((Persistent)object, entity.getName(), descriptor);
        return (T)object;
    }

    @Override
    public void registerNewObject(Object object) {
        if (object == null) {
            throw new NullPointerException("An attempt to register null object.");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(object.getClass());
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        this.registerNewObject((Persistent)object, entity.getName(), descriptor);
    }

    @Override
    public List performQuery(Query query) {
        List result = this.onQuery(this, query).firstList();
        return result != null ? result : new ArrayList(1);
    }

    @Override
    public QueryResponse performGenericQuery(Query query) {
        return this.onQuery(this, query);
    }

    @Override
    public QueryResponse onQuery(ObjectContext context, Query query) {
        return new CayenneContextQueryAction(this, context, query).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<?> uncommittedObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<?> deletedObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<?> modifiedObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<?> newObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes(2);
        }
    }

    void registerNewObject(Persistent object, String entityName, ClassDescriptor descriptor) {
        ObjectId id = object.getObjectId();
        if (id == null) {
            id = new ObjectId(entityName);
            object.setObjectId(id);
        }
        this.injectInitialValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Persistent createFault(ObjectId id) {
        Persistent object;
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            object = (Persistent)descriptor.createObject();
            object.setPersistenceState(5);
            object.setObjectContext(this);
            object.setObjectId(id);
            this.graphManager.registerNode(id, object);
        }
        return object;
    }

    @Override
    @Deprecated
    public ObjectContext createChildContext() {
        CayenneContext child = new CayenneContext(this, this.graphManager.changeEventsEnabled, this.graphManager.lifecycleEventsEnabled);
        if (this.queryCache != null) {
            child.setQueryCache(new NestedQueryCache(this.queryCache));
        }
        return child;
    }

    @Override
    protected GraphDiff onContextFlush(ObjectContext originatingContext, GraphDiff changes, boolean cascade) {
        boolean childContext;
        boolean bl = childContext = this != originatingContext && changes != null;
        if (childContext) {
            changes.apply(new CayenneContextChildDiffLoader(this));
            this.fireDataChannelChanged(originatingContext, changes);
        }
        return cascade ? this.doCommitChanges(true) : new CompoundDiff();
    }

    @Override
    public boolean hasChanges() {
        return this.graphManager.hasChanges();
    }
}

