/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.gen.Artifact;
import org.apache.cayenne.gen.ArtifactGenerationMode;
import org.apache.cayenne.gen.DataMapUtils;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.NameConverter;
import org.apache.velocity.VelocityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMapArtifact
implements Artifact {
    public static final String DATAMAP_UTILS_KEY = "dataMapUtils";
    protected DataMap dataMap;
    protected Collection<SelectQuery> selectQueries;
    protected Collection<SQLTemplate> sqlTemplateQueries;
    protected Collection<ProcedureQuery> procedureQueries;
    protected Collection<EJBQLQuery> ejbqlQueries;
    protected Collection<String> queryNames;

    public DataMapArtifact(DataMap dataMap, Collection<Query> queries) {
        this.dataMap = dataMap;
        this.selectQueries = new LinkedList<SelectQuery>();
        this.sqlTemplateQueries = new LinkedList<SQLTemplate>();
        this.procedureQueries = new LinkedList<ProcedureQuery>();
        this.ejbqlQueries = new LinkedList<EJBQLQuery>();
        this.queryNames = new LinkedList<String>();
        this.addQueries(queries);
    }

    @Override
    public String getQualifiedBaseClassName() {
        return Object.class.getName();
    }

    @Override
    public String getQualifiedClassName() {
        String pkg = this.dataMap.getDefaultPackage();
        pkg = pkg == null ? "" : pkg + '.';
        return pkg + NameConverter.underscoredToJava(NameConverter.specialCharsToJava(this.dataMap.getName()), true);
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public void postInitContext(VelocityContext context) {
        DataMapUtils dataMapUtils = new DataMapUtils();
        context.put(DATAMAP_UTILS_KEY, dataMapUtils);
    }

    @Override
    public TemplateType[] getTemplateTypes(ArtifactGenerationMode mode) {
        switch (mode) {
            case SINGLE_CLASS: {
                return new TemplateType[]{TemplateType.DATAMAP_SINGLE_CLASS};
            }
            case GENERATION_GAP: {
                return new TemplateType[]{TemplateType.DATAMAP_SUPERCLASS, TemplateType.DATAMAP_SUBCLASS};
            }
        }
        return new TemplateType[0];
    }

    private void addQueries(Collection<Query> queries) {
        if (queries != null) {
            for (Query query : queries) {
                this.addQuery(query);
            }
        }
    }

    private void addQuery(Query query) {
        if (query instanceof SelectQuery) {
            this.selectQueries.add((SelectQuery)query);
        } else if (query instanceof ProcedureQuery) {
            this.procedureQueries.add((ProcedureQuery)query);
        } else if (query instanceof SQLTemplate) {
            this.sqlTemplateQueries.add((SQLTemplate)query);
        } else if (query instanceof EJBQLQuery) {
            this.ejbqlQueries.add((EJBQLQuery)query);
        }
        if (query.getName() != null && !"".equals(query.getName())) {
            this.queryNames.add(query.getName());
        }
    }

    public Collection<SelectQuery> getSelectQueries() {
        return this.selectQueries;
    }

    public boolean hasSelectQueries() {
        return this.selectQueries.size() > 0;
    }

    public boolean hasQueryNames() {
        return !this.queryNames.isEmpty();
    }

    public Collection<String> getQueryNames() {
        return this.queryNames;
    }
}

