/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DeleteRule;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.util.Util;

public class ObjRelationshipTableModel
extends CayenneTableModel {
    static final int REL_NAME = 0;
    static final int REL_TARGET = 1;
    static final int REL_SEMANTICS = 2;
    static final int REL_DELETERULE = 3;
    static final int REL_LOCKING = 4;
    protected ObjEntity entity;

    public ObjRelationshipTableModel(ObjEntity entity, ProjectController mediator, Object eventSource) {
        super(mediator, eventSource, new ArrayList<ObjRelationship>(entity.getRelationships()));
        this.entity = entity;
        Collections.sort(this.objectList, new RelationshipComparator());
    }

    protected void orderList() {
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    public Class getElementsClass() {
        return ObjRelationship.class;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Target";
            }
            case 4: {
                return "Used for Locking";
            }
            case 2: {
                return "Semantics";
            }
            case 3: {
                return "Delete Rule";
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 1: {
                return ObjEntity.class;
            }
            case 4: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public ObjRelationship getRelationship(int row) {
        return row >= 0 && row < this.objectList.size() ? (ObjRelationship)this.objectList.get(row) : null;
    }

    public Object getValueAt(int row, int column) {
        ObjRelationship relationship = this.getRelationship(row);
        if (column == 0) {
            return relationship.getName();
        }
        if (column == 1) {
            return relationship.getTargetEntity();
        }
        if (column == 4) {
            return relationship.isUsedForLocking() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (column == 2) {
            return this.getSemantics(relationship);
        }
        if (column == 3) {
            return DeleteRule.deleteRuleName(relationship.getDeleteRule());
        }
        return null;
    }

    private String getSemantics(ObjRelationship relationship) {
        String semantics;
        String string = semantics = relationship.isToMany() ? "to many" : "to one";
        if (relationship.isReadOnly()) {
            semantics = semantics + ", read-only";
        }
        if (relationship.isToMany()) {
            String collection = "list";
            if (relationship.getCollectionType() != null) {
                int dot = relationship.getCollectionType().lastIndexOf(46);
                collection = relationship.getCollectionType().substring(dot + 1).toLowerCase();
            }
            semantics = semantics + ", " + collection;
        }
        return semantics;
    }

    public void setUpdatedValueAt(Object value, int row, int column) {
        ObjRelationship relationship = this.getRelationship(row);
        RelationshipEvent event = new RelationshipEvent(this.eventSource, relationship, this.entity);
        if (column == 0) {
            String text = (String)value;
            event.setOldName(relationship.getName());
            ProjectUtil.setRelationshipName(this.entity, relationship, text);
            this.fireTableCellUpdated(row, column);
        } else if (column == 1) {
            ObjEntity target = (ObjEntity)value;
            relationship.setTargetEntity(target);
            relationship.clearDbRelationships();
            if (target != null) {
                Relationship anyConnector;
                DbEntity srcDB = ((ObjEntity)relationship.getSourceEntity()).getDbEntity();
                DbEntity targetDB = target.getDbEntity();
                if (srcDB != null && targetDB != null && (anyConnector = srcDB.getAnyRelationship(targetDB)) != null) {
                    relationship.addDbRelationship((DbRelationship)anyConnector);
                }
            }
            this.fireTableRowsUpdated(row, row);
        } else if (column == 3) {
            relationship.setDeleteRule(DeleteRule.deleteRuleForName((String)value));
            this.fireTableCellUpdated(row, column);
        } else if (column == 4) {
            relationship.setUsedForLocking(value instanceof Boolean && (Boolean)value != false);
            this.fireTableCellUpdated(row, column);
        }
        this.mediator.fireObjRelationshipEvent(event);
    }

    public void removeRow(int row) {
        if (row < 0) {
            return;
        }
        ObjRelationship rel = this.getRelationship(row);
        RelationshipEvent e = new RelationshipEvent(this.eventSource, (Relationship)rel, (Entity)this.entity, 3);
        this.mediator.fireObjRelationshipEvent(e);
        this.objectList.remove(row);
        this.entity.removeRelationship(rel.getName());
        this.fireTableRowsDeleted(row, row);
    }

    private boolean isInherited(int row) {
        ObjRelationship relationship = this.getRelationship(row);
        return relationship != null ? relationship.getSourceEntity() != this.entity : false;
    }

    public boolean isCellEditable(int row, int col) {
        return !this.isInherited(row) && col != 2;
    }

    public boolean isColumnSortable(int sortCol) {
        return true;
    }

    public void sortByColumn(final int sortCol, boolean isAscent) {
        switch (sortCol) {
            case 0: {
                this.sortByElementProperty("name", isAscent);
                break;
            }
            case 1: {
                this.sortByElementProperty("targetEntityName", isAscent);
                break;
            }
            case 4: {
                this.sortByElementProperty("usedForLocking", isAscent);
                break;
            }
            case 2: 
            case 3: {
                Collections.sort(this.objectList, new Comparator<ObjRelationship>(){

                    @Override
                    public int compare(ObjRelationship o1, ObjRelationship o2) {
                        if (o1 == null && o2 == null || o1 == o2) {
                            return 0;
                        }
                        if (o1 == null && o2 != null) {
                            return -1;
                        }
                        if (o1 != null && o2 == null) {
                            return 1;
                        }
                        String valueToCompare1 = "";
                        String valueToCompare2 = "";
                        switch (sortCol) {
                            case 2: {
                                valueToCompare1 = ObjRelationshipTableModel.this.getSemantics(o1);
                                valueToCompare2 = ObjRelationshipTableModel.this.getSemantics(o2);
                                break;
                            }
                            case 3: {
                                valueToCompare1 = DeleteRule.deleteRuleName(o1.getDeleteRule());
                                valueToCompare2 = DeleteRule.deleteRuleName(o2.getDeleteRule());
                            }
                        }
                        return valueToCompare1 == null ? -1 : (valueToCompare2 == null ? 1 : valueToCompare1.compareTo(valueToCompare2));
                    }
                });
                if (isAscent) break;
                Collections.reverse(this.objectList);
            }
        }
    }

    final class RelationshipComparator
    implements Comparator {
        RelationshipComparator() {
        }

        public int compare(Object o1, Object o2) {
            ObjRelationship r1 = (ObjRelationship)o1;
            ObjRelationship r2 = (ObjRelationship)o2;
            int delta = this.getWeight(r1) - this.getWeight(r2);
            return delta != 0 ? delta : Util.nullSafeCompare(true, r1.getName(), r2.getName());
        }

        private int getWeight(ObjRelationship r) {
            return r.getSourceEntity() == ObjRelationshipTableModel.this.entity ? 1 : -1;
        }
    }
}

