/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.common.ExtBasicArrowButtonHandler;
import com.jgoodies.looks.common.ExtBasicSpinnerLayout;
import com.jgoodies.looks.plastic.PlasticArrowButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class PlasticSpinnerUI
extends BasicSpinnerUI {
    private static final Border MARGIN_BORDER = new BorderUIResource(new BasicBorders.MarginBorder());
    private static final ExtBasicArrowButtonHandler nextButtonHandler = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler previousButtonHandler = new ExtBasicArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent b) {
        return new PlasticSpinnerUI();
    }

    protected Component createPreviousButton() {
        return new SpinnerArrowButton(5, previousButtonHandler);
    }

    protected Component createNextButton() {
        return new SpinnerArrowButton(1, nextButtonHandler);
    }

    protected LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        this.configureEditor(editor);
        return editor;
    }

    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        this.configureEditor(newEditor);
        this.spinner.add((Component)newEditor, "Editor");
    }

    private void configureEditor(JComponent editor) {
        if (editor instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)editor;
            defaultEditor.getTextField().getUI();
            defaultEditor.getTextField().setBorder(MARGIN_BORDER);
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            defaultEditor.getTextField().setMargin(insets);
        }
    }

    private static class SpinnerArrowButton
    extends PlasticArrowButton {
        private SpinnerArrowButton(int direction, ExtBasicArrowButtonHandler handler) {
            super(direction, UIManager.getInt("ScrollBar.width"), true);
            this.addActionListener(handler);
            this.addMouseListener(handler);
        }

        protected int calculateArrowHeight(int height, int width) {
            int arrowHeight = Math.min((height - 4) / 3, (width - 4) / 3);
            return Math.max(arrowHeight, 3);
        }

        protected int calculateArrowOffset() {
            return 1;
        }

        protected boolean isPaintingNorthBottom() {
            return true;
        }
    }
}

