/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import java.util.Collection;
import javax.swing.undo.CompoundEdit;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.undo.CreateAttributeUndoableEdit;
import org.apache.cayenne.modeler.undo.CreateRelationshipUndoableEdit;
import org.apache.cayenne.modeler.undo.RemoveAttributeUndoableEdit;
import org.apache.cayenne.util.EntityMergeListener;

public class DbEntitySyncUndoableEdit
extends CompoundEdit {
    private DataChannelDescriptor domain;
    private DataMap map;

    public boolean isInProgress() {
        return false;
    }

    public boolean canUndo() {
        return !this.edits.isEmpty();
    }

    public DbEntitySyncUndoableEdit(DataChannelDescriptor domain, DataMap map) {
        this.domain = domain;
        this.map = map;
    }

    public String getRedoPresentationName() {
        return "Redo Db Entity Sync";
    }

    public String getUndoPresentationName() {
        return "Undo Db Entity Sync";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MeaningfulFKsUndoableEdit
    extends CompoundEdit {
        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public boolean canUndo() {
            return !this.edits.isEmpty();
        }

        public MeaningfulFKsUndoableEdit(ObjEntity entity, Collection<DbAttribute> dbAttrs) {
            for (DbAttribute da : dbAttrs) {
                ObjAttribute oa = entity.getAttributeForDbAttribute(da);
                if (oa == null) continue;
                this.addEdit(new RemoveAttributeUndoableEdit(DbEntitySyncUndoableEdit.this.domain, DbEntitySyncUndoableEdit.this.map, entity, new ObjAttribute[]{oa}));
            }
        }
    }

    public class EntitySyncUndoableListener
    implements EntityMergeListener {
        private ObjEntity entity;

        public EntitySyncUndoableListener(ObjEntity entity) {
            this.entity = entity;
        }

        public void objRelationshipAdded(ObjRelationship rel) {
            DbEntitySyncUndoableEdit.this.addEdit(new CreateRelationshipUndoableEdit(this.entity, new ObjRelationship[]{rel}));
        }

        public void objAttributeAdded(ObjAttribute attr) {
            DbEntitySyncUndoableEdit.this.addEdit(new CreateAttributeUndoableEdit(DbEntitySyncUndoableEdit.this.domain, DbEntitySyncUndoableEdit.this.map, this.entity, attr));
        }
    }
}

