/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.openbase;

import java.io.IOException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.PatternMatchNode;
import org.apache.cayenne.map.DbAttribute;

public class OpenBaseQualifierTranslator
extends QualifierTranslator {
    public OpenBaseQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startNode(Expression node, Expression parentNode) {
        if (node.getOperandCount() == 2) {
            this.detectObjectMatch(node);
            try {
                if (!this.parenthesisNeeded(node, parentNode)) return;
                this.out.append('(');
                return;
            }
            catch (IOException ioex) {
                throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
            }
        } else {
            super.startNode(node, parentNode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endNode(Expression node, Expression parentNode) {
        if (node.getOperandCount() == 2) {
            try {
                if (this.matchingObject) {
                    this.appendObjectMatch();
                }
                if (PatternMatchNode.class.isAssignableFrom(node.getClass())) {
                    this.appendLikeEscapeCharacter((PatternMatchNode)node);
                }
                if (!this.parenthesisNeeded(node, parentNode)) return;
                this.out.append(')');
                return;
            }
            catch (IOException ioex) {
                throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
            }
        } else {
            super.endNode(node, parentNode);
        }
    }

    protected void appendLiteralDirect(Object val, DbAttribute attr, Expression parentExpression) throws IOException {
        if (val instanceof String && (parentExpression.getType() == 11 || parentExpression.getType() == 37)) {
            val = this.caseSensitiveLikePattern((String)val);
        }
        super.appendLiteralDirect(val, attr, parentExpression);
    }

    private String caseSensitiveLikePattern(String pattern) {
        int len = pattern.length();
        StringBuilder buffer = new StringBuilder(len * 3);
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (c == '%' || c == '?') {
                buffer.append(c);
                continue;
            }
            buffer.append("[").append(c).append("]");
        }
        return buffer.toString();
    }

    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
        if (!hasMoreChildren) {
            return;
        }
        try {
            switch (node.getType()) {
                case 12: {
                    this.finishedChildNodeAppendExpression(node, " LIKE ");
                    break;
                }
                case 38: {
                    this.finishedChildNodeAppendExpression(node, " NOT LIKE ");
                    break;
                }
                default: {
                    super.finishedChild(node, childIndex, hasMoreChildren);
                    break;
                }
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
        }
    }

    private void finishedChildNodeAppendExpression(Expression node, String operation) throws IOException {
        Appendable out = this.matchingObject ? new StringBuilder() : this.out;
        out.append(operation);
        if (this.matchingObject) {
            this.objectMatchTranslator.setOperation(out.toString());
            this.objectMatchTranslator.setExpression(node);
        }
    }
}

