/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import org.apache.cayenne.CayenneRuntimeException;

public class ScopeEventBinding {
    private WeakReference<Object> objectReference;
    private Method eventHandlerMethod;
    private int argWidth;

    public ScopeEventBinding(Object object, Method eventHandlerMethod) {
        this.objectReference = new WeakReference<Object>(object);
        this.eventHandlerMethod = eventHandlerMethod;
        this.argWidth = eventHandlerMethod.getParameterTypes().length;
        eventHandlerMethod.setAccessible(true);
    }

    public Object getObject() {
        return this.objectReference.get();
    }

    public boolean onScopeEvent(Object ... eventArgs) {
        Object object = this.objectReference.get();
        if (object == null) {
            return false;
        }
        try {
            this.eventHandlerMethod.invoke(object, this.invocationArguments(eventArgs));
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error invoking event method %s", (Throwable)e, this.eventHandlerMethod.getName());
        }
        return true;
    }

    private Object[] invocationArguments(Object[] eventArgs) {
        int eventArgWidth;
        int n = eventArgWidth = eventArgs == null ? 0 : eventArgs.length;
        if (this.argWidth != eventArgWidth) {
            throw new CayenneRuntimeException("Event argument list size (%d) is different from the handler method argument list size (%d)", eventArgWidth, this.argWidth);
        }
        return eventArgs;
    }
}

