package org.apache.cayenne.testdo.deleterules.auto;

import java.util.List;

import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.testdo.deleterules.DeleteCascade;
import org.apache.cayenne.testdo.deleterules.DeleteDeny;
import org.apache.cayenne.testdo.deleterules.DeleteNullify;

/**
 * Class _DeleteRule was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _DeleteRule extends CayenneDataObject {

    private static final long serialVersionUID = 1L; 

    public static final String DELETE_RULE_ID_PK_COLUMN = "DELETE_RULE_ID";

    public static final Property<String> NAME = Property.create("name", String.class);
    public static final Property<List<DeleteCascade>> FROM_CASCADE = Property.create("fromCascade", List.class);
    public static final Property<List<DeleteDeny>> FROM_DENY = Property.create("fromDeny", List.class);
    public static final Property<List<DeleteNullify>> FROM_NULLIFY = Property.create("fromNullify", List.class);

    public void setName(String name) {
        writeProperty("name", name);
    }
    public String getName() {
        return (String)readProperty("name");
    }

    public void addToFromCascade(DeleteCascade obj) {
        addToManyTarget("fromCascade", obj, true);
    }
    public void removeFromFromCascade(DeleteCascade obj) {
        removeToManyTarget("fromCascade", obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<DeleteCascade> getFromCascade() {
        return (List<DeleteCascade>)readProperty("fromCascade");
    }


    public void addToFromDeny(DeleteDeny obj) {
        addToManyTarget("fromDeny", obj, true);
    }
    public void removeFromFromDeny(DeleteDeny obj) {
        removeToManyTarget("fromDeny", obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<DeleteDeny> getFromDeny() {
        return (List<DeleteDeny>)readProperty("fromDeny");
    }


    public void addToFromNullify(DeleteNullify obj) {
        addToManyTarget("fromNullify", obj, true);
    }
    public void removeFromFromNullify(DeleteNullify obj) {
        removeToManyTarget("fromNullify", obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<DeleteNullify> getFromNullify() {
        return (List<DeleteNullify>)readProperty("fromNullify");
    }


}
