/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jcache;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.processor.EntryProcessor;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.jcache.JCacheConfigurationFactory;
import org.apache.cayenne.jcache.JCacheEntryLoader;
import org.apache.cayenne.query.QueryMetadata;

public class JCacheQueryCache
implements QueryCache {
    @Inject
    protected CacheManager cacheManager;
    @Inject
    protected JCacheConfigurationFactory configurationFactory;
    private Set<String> seenCacheNames = Collections.newSetFromMap(new ConcurrentHashMap());

    public List get(QueryMetadata metadata) {
        String key = Objects.requireNonNull(metadata.getCacheKey());
        Cache<String, List> cache = this.createIfAbsent(metadata);
        return (List)cache.get((Object)key);
    }

    public List get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
        String key = Objects.requireNonNull(metadata.getCacheKey());
        Cache<String, List> cache = this.createIfAbsent(metadata);
        List result = (List)cache.get((Object)key);
        return result != null ? result : (List)cache.invoke((Object)key, (EntryProcessor)new JCacheEntryLoader(factory), new Object[0]);
    }

    public void put(QueryMetadata metadata, List results) {
        String key = Objects.requireNonNull(metadata.getCacheKey());
        Cache<String, List> cache = this.createIfAbsent(metadata);
        cache.put((Object)key, (Object)results);
    }

    public void remove(String key) {
        if (key != null) {
            for (String cache : this.cacheManager.getCacheNames()) {
                this.getCache(cache).remove((Object)key);
            }
        }
    }

    public void removeGroup(String groupKey) {
        Cache<String, List> cache = this.getCache(groupKey);
        if (cache != null) {
            cache.clear();
        }
    }

    public void removeGroup(String groupKey, Class<?> keyType, Class<?> valueType) {
        Cache cache = this.cacheManager.getCache(groupKey, keyType, valueType);
        if (cache != null) {
            cache.clear();
        }
    }

    public void clear() {
        for (String name : this.seenCacheNames) {
            this.getCache(name).clear();
        }
    }

    @Deprecated
    public int size() {
        return -1;
    }

    protected Cache<String, List> createIfAbsent(QueryMetadata metadata) {
        return this.createIfAbsent(this.cacheName(metadata));
    }

    protected Cache<String, List> createIfAbsent(String cacheName) {
        Cache<String, List> cache = this.getCache(cacheName);
        if (cache == null) {
            block3: {
                try {
                    cache = this.createCache(cacheName);
                }
                catch (CacheException e) {
                    cache = this.getCache(cacheName);
                    if (cache != null) break block3;
                    throw e;
                }
            }
            this.seenCacheNames.add(cacheName);
        }
        return cache;
    }

    protected Cache createCache(String cacheName) {
        return this.cacheManager.createCache(cacheName, this.configurationFactory.create(cacheName));
    }

    protected Cache<String, List> getCache(String name) {
        return this.cacheManager.getCache(name);
    }

    protected String cacheName(QueryMetadata metadata) {
        String cacheGroup = metadata.getCacheGroup();
        if (cacheGroup != null) {
            return cacheGroup;
        }
        return "cayenne.default.cache";
    }

    @BeforeScopeEnd
    public void shutdown() {
        this.cacheManager.close();
    }
}

