/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.db2;

import java.io.IOException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.TrimmingQualifierTranslator;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTExtract;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.ASTNotEqual;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.map.DbAttribute;

public class DB2QualifierTranslator
extends TrimmingQualifierTranslator {
    public DB2QualifierTranslator(QueryAssembler queryAssembler, String trimFunction) {
        super(queryAssembler, trimFunction);
    }

    @Override
    protected void appendLiteralDirect(Object val, DbAttribute attr, Expression parentExpression) throws IOException {
        boolean castNeeded = false;
        if (parentExpression != null) {
            int type = parentExpression.getType();
            boolean bl = castNeeded = attr != null && (type == 11 || type == 12 || type == 37 || type == 38);
        }
        if (castNeeded) {
            this.out.append("CAST (");
        }
        super.appendLiteralDirect(val, attr, parentExpression);
        if (castNeeded) {
            int jdbcType = attr.getType();
            int len = attr.getMaxLength();
            if (jdbcType == 1 || jdbcType == -1) {
                jdbcType = 12;
                if (len <= 0) {
                    len = 254;
                }
            }
            this.out.append(" AS ");
            String[] types = this.queryAssembler.getAdapter().externalTypesForJdbcType(jdbcType);
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Can't find database type for JDBC type '%s'", TypesMapping.getSqlNameByType(jdbcType));
            }
            this.out.append(types[0]);
            if (len > 0 && this.queryAssembler.getAdapter().typeSupportsLength(jdbcType)) {
                this.out.append("(");
                this.out.append(String.valueOf(len));
                this.out.append(")");
            }
            this.out.append(")");
        }
    }

    @Override
    protected void processColumnWithQuoteSqlIdentifiers(DbAttribute dbAttr, Expression pathExp) {
        SimpleNode parent = null;
        if (pathExp instanceof SimpleNode) {
            parent = (SimpleNode)((SimpleNode)pathExp).jjtGetParent();
        }
        if (parent != null && (parent instanceof ASTEqual || parent instanceof ASTNotEqual) && dbAttr.getType() == 2005 && parent.getOperandCount() == 2 && parent.getOperand(1) instanceof String) {
            Integer size = parent.getOperand(1).toString().length() + 1;
            this.out.append("CAST(");
            super.processColumnWithQuoteSqlIdentifiers(dbAttr, pathExp);
            this.out.append(" AS VARCHAR(" + size + "))");
        } else {
            super.processColumnWithQuoteSqlIdentifiers(dbAttr, pathExp);
        }
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        if ("SUBSTRING".equals(functionExpression.getFunctionName())) {
            this.out.append("SUBSTR");
        } else if (!"CONCAT".equals(functionExpression.getFunctionName())) {
            super.appendFunction(functionExpression);
        }
    }

    @Override
    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("CONCAT".equals(functionExpression.getFunctionName())) {
            this.out.append(" || ");
        } else {
            super.appendFunctionArgDivider(functionExpression);
        }
    }

    @Override
    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("CONCAT".equals(functionExpression.getFunctionName())) {
            this.out.delete(this.out.length() - " || ".length(), this.out.length());
        } else {
            super.clearLastFunctionArgDivider(functionExpression);
        }
    }

    @Override
    protected void appendExtractFunction(ASTExtract functionExpression) {
        switch (functionExpression.getPart()) {
            case DAY_OF_MONTH: {
                this.out.append("DAY");
                break;
            }
            case DAY_OF_WEEK: 
            case DAY_OF_YEAR: {
                this.out.append(functionExpression.getPart().name().replace("_", ""));
                break;
            }
            default: {
                this.appendFunction(functionExpression);
            }
        }
    }
}

