/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLExpressionVisitor;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.SQLTemplate;

public class EJBQLAction
extends BaseSQLAction {
    protected SQLActionVisitor actionFactory;
    protected EJBQLQuery query;

    public EJBQLAction(EJBQLQuery query, SQLActionVisitor actionFactory, DataNode dataNode) {
        super(dataNode);
        this.query = query;
        this.actionFactory = actionFactory;
    }

    @Override
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        EJBQLCompiledExpression compiledExpression = this.query.getExpression(this.dataNode.getEntityResolver());
        final EJBQLTranslatorFactory translatorFactory = this.dataNode.getAdapter().getEjbqlTranslatorFactory();
        final EJBQLTranslationContext context = new EJBQLTranslationContext(this.dataNode.getEntityResolver(), this.query, compiledExpression, translatorFactory, this.dataNode.getAdapter().getQuotingStrategy());
        compiledExpression.getExpression().visit(new EJBQLBaseVisitor(false){

            @Override
            public boolean visitSelect(EJBQLExpression expression) {
                EJBQLExpressionVisitor visitor = translatorFactory.getSelectTranslator(context);
                expression.visit(visitor);
                return false;
            }

            @Override
            public boolean visitDelete(EJBQLExpression expression) {
                EJBQLExpressionVisitor visitor = translatorFactory.getDeleteTranslator(context);
                expression.visit(visitor);
                return false;
            }

            @Override
            public boolean visitUpdate(EJBQLExpression expression) {
                EJBQLExpressionVisitor visitor = translatorFactory.getUpdateTranslator(context);
                expression.visit(visitor);
                return false;
            }
        });
        SQLTemplate sqlQuery = context.getQuery();
        QueryMetadata md = this.query.getMetaData(this.dataNode.getEntityResolver());
        sqlQuery.setFetchLimit(md.getFetchLimit());
        sqlQuery.setFetchOffset(md.getFetchOffset());
        sqlQuery.setResult(compiledExpression.getResult());
        sqlQuery.setPageSize(md.getPageSize());
        if (md.getStatementFetchSize() != 0) {
            sqlQuery.setStatementFetchSize(md.getStatementFetchSize());
        }
        this.actionFactory.sqlAction(sqlQuery).performAction(connection, observer);
    }
}

