/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.exp.parser.SimpleNode;

public abstract class EvaluatedNode
extends SimpleNode {
    protected EvaluatedNode(int i) {
        super(i);
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        int requiredLen;
        int len = this.jjtGetNumChildren();
        if (len < (requiredLen = this.getRequiredChildrenCount())) {
            return null;
        }
        if (requiredLen == 0) {
            return this.evaluateSubNode(null, null);
        }
        Object[] evaluatedChildren = new Object[len];
        for (int i = 0; i < len; ++i) {
            evaluatedChildren[i] = this.evaluateChild(i, o);
        }
        Object firstChild = evaluatedChildren[0];
        if (firstChild instanceof Map) {
            Map child = (Map)firstChild;
            HashMap result = new HashMap(child.size());
            for (Map.Entry entry : child.entrySet()) {
                result.put(entry.getKey(), this.evaluateSubNode(entry.getValue(), evaluatedChildren));
            }
            return result;
        }
        if (firstChild instanceof Collection) {
            Collection child = (Collection)firstChild;
            ArrayList<Object> result = new ArrayList<Object>(child.size());
            for (Object c : child) {
                result.add(this.evaluateSubNode(c, evaluatedChildren));
            }
            return result;
        }
        return this.evaluateSubNode(firstChild, evaluatedChildren);
    }

    protected abstract int getRequiredChildrenCount();

    protected abstract Object evaluateSubNode(Object var1, Object[] var2) throws Exception;
}

