/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.ProjectTraversalHandler;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTraversal {
    protected static final Comparator mapObjectComparator = new MapObjectComparator();
    protected static final Comparator dataMapComparator = new DataMapComparator();
    protected static final Comparator dataDomainComparator = new DataDomainComparator();
    protected static final Comparator dataNodeComparator = new DataNodeComparator();
    protected static final Comparator queryComparator = new QueryComparator();
    protected static final Comparator embaddableComparator = new EmbeddableComparator();
    protected ProjectTraversalHandler handler;
    protected boolean sort;

    public ProjectTraversal(ProjectTraversalHandler handler) {
        this(handler, false);
    }

    public ProjectTraversal(ProjectTraversalHandler handler, boolean sort) {
        this.handler = handler;
        this.sort = sort;
    }

    public void traverse(Object rootNode) {
        this.traverse(rootNode, new ProjectPath());
    }

    public void traverse(Object rootNode, ProjectPath path) {
        if (rootNode instanceof Project) {
            this.traverseProject((Project)rootNode, path);
        } else if (rootNode instanceof DataDomain) {
            this.traverseDomains(Collections.singletonList(rootNode).iterator(), path);
        } else if (rootNode instanceof DataMap) {
            this.traverseMaps(Collections.singletonList(rootNode).iterator(), path);
        } else if (rootNode instanceof Entity) {
            this.traverseEntities(Collections.singletonList(rootNode).iterator(), path);
        } else if (rootNode instanceof Embeddable) {
            this.traverseEmbeddable(Collections.singletonList(rootNode).iterator(), path);
        } else if (rootNode instanceof EmbeddableAttribute) {
            this.traverseEmbeddableAttributes(Collections.singletonList(rootNode).iterator(), path);
        } else if (rootNode instanceof Attribute) {
            this.traverseAttributes(Collections.singletonList(rootNode).iterator(), path);
        } else if (rootNode instanceof Relationship) {
            this.traverseRelationships(Collections.singletonList(rootNode).iterator(), path);
        } else if (rootNode instanceof DataNode) {
            this.traverseNodes(Collections.singletonList(rootNode).iterator(), path);
        } else {
            String nodeClass = rootNode != null ? rootNode.getClass().getName() : "(null)";
            throw new IllegalArgumentException("Unsupported root node: " + nodeClass);
        }
    }

    public void traverseProject(Project project, ProjectPath path) {
        ProjectPath projectPath = path.appendToPath(project);
        this.handler.projectNode(projectPath);
        if (this.handler.shouldReadChildren(project, path)) {
            Iterator it = project.getChildren().iterator();
            while (it.hasNext()) {
                this.traverse(it.next(), projectPath);
            }
        }
    }

    public void traverseDomains(Iterator domains, ProjectPath path) {
        if (this.sort) {
            domains = Util.sortedIterator(domains, dataDomainComparator);
        }
        while (domains.hasNext()) {
            DataDomain domain = (DataDomain)domains.next();
            ProjectPath domainPath = path.appendToPath(domain);
            this.handler.projectNode(domainPath);
            if (!this.handler.shouldReadChildren(domain, path)) continue;
            this.traverseMaps(domain.getDataMaps().iterator(), domainPath);
            this.traverseNodes(domain.getDataNodes().iterator(), domainPath);
        }
    }

    public void traverseNodes(Iterator nodes, ProjectPath path) {
        if (this.sort) {
            nodes = Util.sortedIterator(nodes, dataNodeComparator);
        }
        while (nodes.hasNext()) {
            DataNode node = (DataNode)nodes.next();
            ProjectPath nodePath = path.appendToPath(node);
            this.handler.projectNode(nodePath);
            if (!this.handler.shouldReadChildren(node, path)) continue;
            this.traverseMaps(node.getDataMaps().iterator(), nodePath);
        }
    }

    public void traverseMaps(Iterator maps, ProjectPath path) {
        if (this.sort) {
            maps = Util.sortedIterator(maps, dataMapComparator);
        }
        while (maps.hasNext()) {
            DataMap map = (DataMap)maps.next();
            ProjectPath mapPath = path.appendToPath(map);
            this.handler.projectNode(mapPath);
            if (!this.handler.shouldReadChildren(map, path)) continue;
            this.traverseEntities(map.getObjEntities().iterator(), mapPath);
            this.traverseEmbeddable(map.getEmbeddables().iterator(), mapPath);
            this.traverseEntities(map.getDbEntities().iterator(), mapPath);
            this.traverseProcedures(map.getProcedures().iterator(), mapPath);
            this.traverseQueries(map.getQueries().iterator(), mapPath);
        }
    }

    public void traverseEmbeddable(Iterator embeddadles, ProjectPath path) {
        if (this.sort) {
            embeddadles = Util.sortedIterator(embeddadles, embaddableComparator);
        }
        while (embeddadles.hasNext()) {
            Embeddable emd = (Embeddable)embeddadles.next();
            ProjectPath entPath = path.appendToPath(emd);
            this.handler.projectNode(entPath);
            if (!this.handler.shouldReadChildren(emd, path)) continue;
            this.traverseEmbeddableAttributes(emd.getAttributes().iterator(), entPath);
        }
    }

    public void traverseQueries(Iterator queries, ProjectPath path) {
        if (this.sort) {
            queries = Util.sortedIterator(queries, queryComparator);
        }
        while (queries.hasNext()) {
            Query query = (Query)queries.next();
            ProjectPath queryPath = path.appendToPath(query);
            this.handler.projectNode(queryPath);
        }
    }

    public void traverseProcedures(Iterator procedures, ProjectPath path) {
        if (this.sort) {
            procedures = Util.sortedIterator(procedures, mapObjectComparator);
        }
        while (procedures.hasNext()) {
            Procedure procedure = (Procedure)procedures.next();
            ProjectPath procedurePath = path.appendToPath(procedure);
            this.handler.projectNode(procedurePath);
            if (!this.handler.shouldReadChildren(procedure, path)) continue;
            this.traverseProcedureParameters(procedure.getCallParameters().iterator(), procedurePath);
        }
    }

    public void traverseEntities(Iterator entities, ProjectPath path) {
        if (this.sort) {
            entities = Util.sortedIterator(entities, mapObjectComparator);
        }
        while (entities.hasNext()) {
            Entity ent = (Entity)entities.next();
            ProjectPath entPath = path.appendToPath(ent);
            this.handler.projectNode(entPath);
            if (!this.handler.shouldReadChildren(ent, path)) continue;
            this.traverseAttributes(ent.getAttributes().iterator(), entPath);
            this.traverseRelationships(ent.getRelationships().iterator(), entPath);
        }
    }

    public void traverseAttributes(Iterator attributes, ProjectPath path) {
        if (this.sort) {
            attributes = Util.sortedIterator(attributes, mapObjectComparator);
        }
        while (attributes.hasNext()) {
            this.handler.projectNode(path.appendToPath(attributes.next()));
        }
    }

    public void traverseEmbeddableAttributes(Iterator emAttributes, ProjectPath path) {
        if (this.sort) {
            emAttributes = Util.sortedIterator(emAttributes, mapObjectComparator);
        }
        while (emAttributes.hasNext()) {
            this.handler.projectNode(path.appendToPath(emAttributes.next()));
        }
    }

    public void traverseRelationships(Iterator relationships, ProjectPath path) {
        if (this.sort) {
            relationships = Util.sortedIterator(relationships, mapObjectComparator);
        }
        while (relationships.hasNext()) {
            this.handler.projectNode(path.appendToPath(relationships.next()));
        }
    }

    public void traverseProcedureParameters(Iterator<? extends ProcedureParameter> parameters, ProjectPath path) {
        while (parameters.hasNext()) {
            this.handler.projectNode(path.appendToPath(parameters.next()));
        }
    }

    static class DataNodeComparator
    implements Comparator {
        DataNodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((DataNode)o1).getName();
            String name2 = ((DataNode)o2).getName();
            if (name1 == null) {
                return name2 != null ? -1 : 0;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }

    static class DataDomainComparator
    implements Comparator {
        DataDomainComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((DataDomain)o1).getName();
            String name2 = ((DataDomain)o2).getName();
            if (name1 == null) {
                return name2 != null ? -1 : 0;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }

    static class DataMapComparator
    implements Comparator {
        DataMapComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((DataMap)o1).getName();
            String name2 = ((DataMap)o2).getName();
            if (name1 == null) {
                return name2 != null ? -1 : 0;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }

    static class EmbeddableComparator
    implements Comparator {
        EmbeddableComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((Embeddable)o1).getClassName();
            String name2 = ((Embeddable)o2).getClassName();
            if (name1 == null) {
                return name2 != null ? -1 : 0;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }

    static class MapObjectComparator
    implements Comparator {
        MapObjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((CayenneMapEntry)o1).getName();
            String name2 = ((CayenneMapEntry)o2).getName();
            if (name1 == null) {
                return name2 != null ? -1 : 0;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }

    static class QueryComparator
    implements Comparator {
        QueryComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((Query)o1).getName();
            String name2 = ((Query)o2).getName();
            if (name1 == null) {
                return name2 != null ? -1 : 0;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

