/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.random;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;

public class Roulette
implements Iterator {
    private Random random;
    private int[] sectors;

    public Roulette(int sectorCount) {
        this(sectorCount, 1, new Random());
    }

    public Roulette(int sectorCount, int sectorSelectionCount, Random randomizer) {
        this.random = randomizer;
        this.sectors = new int[sectorCount];
        Arrays.fill(this.sectors, sectorSelectionCount);
    }

    public Roulette(int[] sectors, Random randomizer) {
        this.random = randomizer;
        this.sectors = new int[sectors.length];
        System.arraycopy(sectors, 0, this.sectors, 0, sectors.length);
    }

    public boolean hasNext() {
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] <= 0) continue;
            return true;
        }
        return false;
    }

    public Object next() {
        int pointedSector;
        int i = pointedSector = this.random.nextInt(this.sectors.length);
        while (i < this.sectors.length) {
            int n = i++;
            int n2 = this.sectors[n];
            this.sectors[n] = n2 - 1;
            if (n2 <= 0) continue;
            return new Integer(i);
        }
        i = 0;
        while (i < pointedSector) {
            int n = i++;
            int n3 = this.sectors[n];
            this.sectors[n] = n3 - 1;
            if (n3 <= 0) continue;
            return new Integer(i);
        }
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException("Method remove() not supported.");
    }
}

