/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.query;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.scopemvc.core.Selector;

public class QueryTypeModel {
    public static final Selector OBJECT_SELECT_QUERY_SELECTOR = Selector.fromString((String)"objectSelectQuery");
    public static final Selector RAW_SQL_QUERY_SELECTOR = Selector.fromString((String)"rawSQLQuery");
    public static final Selector PROCEDURE_QUERY_SELECTOR = Selector.fromString((String)"procedureQuery");
    public static final Selector EJBQL_QUERY_SELECTOR = Selector.fromString((String)"ejbqlQuery");
    protected AbstractQuery objectSelectQuery = new SelectQuery();
    protected AbstractQuery rawSQLQuery;
    protected AbstractQuery procedureQuery = new ProcedureQuery();
    protected EJBQLQuery ejbqlQuery;
    protected Query selectedQuery;

    public QueryTypeModel(DataMap root) {
        SQLTemplate rawSQLQuery = new SQLTemplate();
        rawSQLQuery.setRoot((Object)root);
        rawSQLQuery.setFetchingDataRows(true);
        this.rawSQLQuery = rawSQLQuery;
        this.ejbqlQuery = new EJBQLQuery();
        this.selectedQuery = this.objectSelectQuery;
    }

    public Query getSelectedQuery() {
        return this.selectedQuery;
    }

    public void setSelectedQuery(AbstractQuery selectedQuery) {
        this.selectedQuery = selectedQuery;
    }

    public boolean isObjectSelectQuery() {
        return this.selectedQuery == this.objectSelectQuery;
    }

    public void setObjectSelectQuery(boolean flag) {
        if (!flag && this.isObjectSelectQuery()) {
            this.selectedQuery = null;
        } else if (flag && !this.isObjectSelectQuery()) {
            this.selectedQuery = this.objectSelectQuery;
        }
    }

    public boolean isRawSQLQuery() {
        return this.selectedQuery == this.rawSQLQuery;
    }

    public void setRawSQLQuery(boolean flag) {
        if (!flag && this.isRawSQLQuery()) {
            this.selectedQuery = null;
        } else if (flag && !this.isRawSQLQuery()) {
            this.selectedQuery = this.rawSQLQuery;
        }
    }

    public boolean isProcedureQuery() {
        return this.selectedQuery == this.procedureQuery;
    }

    public void setProcedureQuery(boolean flag) {
        if (!flag && this.isProcedureQuery()) {
            this.selectedQuery = null;
        } else if (flag && !this.isProcedureQuery()) {
            this.selectedQuery = this.procedureQuery;
        }
    }

    public boolean isEjbqlQuery() {
        return this.selectedQuery == this.ejbqlQuery;
    }

    public void setEjbqlQuery(boolean flag) {
        if (!flag && this.isEjbqlQuery()) {
            this.selectedQuery = null;
        } else if (flag && !this.isEjbqlQuery()) {
            this.selectedQuery = this.ejbqlQuery;
        }
    }
}

