/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.event.EntityListenerEvent;

public class RemoveEntityListenerForDataMapAction
extends RemoveAction {
    private static final String ACTION_NAME = "Remove entity listener for data map";

    public RemoveEntityListenerForDataMapAction(Application application) {
        super(RemoveEntityListenerForDataMapAction.getActionName(), application);
    }

    public static String getActionName() {
        return ACTION_NAME;
    }

    public String getIconName() {
        return "icon-remove-listener.gif";
    }

    public void performAction(ActionEvent e, boolean allowAsking) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        if (this.getProjectController().getCurrentListenerClass() != null && dialog.shouldDelete("entity listener", this.getProjectController().getCurrentListenerClass())) {
            String listenerClass = this.getProjectController().getCurrentListenerClass();
            this.removeEntityListener(this.getProjectController().getCurrentDataMap(), listenerClass);
        }
    }

    public void removeEntityListener(DataMap map, String listenerClass) {
        if (listenerClass != null) {
            map.removeDefaultEntityListener(listenerClass);
            this.getProjectController().fireEntityListenerEvent(new EntityListenerEvent(this, listenerClass, listenerClass, 3));
        }
    }
}

