/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public class LongType
implements ExtendedType {
    public String getClassName() {
        return Long.class.getName();
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        long value = rs.getLong(index);
        return rs.wasNull() ? null : Long.valueOf(value);
    }

    public Object materializeObject(CallableStatement rs, int index, int type) throws Exception {
        long value = rs.getLong(index);
        return rs.wasNull() ? null : Long.valueOf(value);
    }

    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            statement.setLong(pos, ((Number)value).longValue());
        }
    }

    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        if (dbAttribute.isMandatory() && value == null) {
            validationResult.addFailure(new BeanValidationFailure(source, property, "'" + property + "' must be not null"));
            return false;
        }
        return true;
    }
}

