/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.AsyncStatement;
import org.apache.derby.impl.tools.ij.CharStream;
import org.apache.derby.impl.tools.ij.ConnectionEnv;
import org.apache.derby.impl.tools.ij.ParseException;
import org.apache.derby.impl.tools.ij.QualifiedIdentifier;
import org.apache.derby.impl.tools.ij.Session;
import org.apache.derby.impl.tools.ij.Token;
import org.apache.derby.impl.tools.ij.URLCheck;
import org.apache.derby.impl.tools.ij.ijConnectionResult;
import org.apache.derby.impl.tools.ij.ijConstants;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.ijMultiResult;
import org.apache.derby.impl.tools.ij.ijMultipleResultSetResult;
import org.apache.derby.impl.tools.ij.ijResult;
import org.apache.derby.impl.tools.ij.ijResultSetResult;
import org.apache.derby.impl.tools.ij.ijRowResult;
import org.apache.derby.impl.tools.ij.ijStatementResult;
import org.apache.derby.impl.tools.ij.ijTokenManager;
import org.apache.derby.impl.tools.ij.ijVectorResult;
import org.apache.derby.impl.tools.ij.ijWarningResult;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derby.impl.tools.ij.utilMain;
import org.apache.derby.impl.tools.ij.xaAbstractHelper;
import org.apache.derby.tools.JDBCDisplayUtil;

class ij
implements ijConstants {
    static final String PROTOCOL_PROPERTY = "ij.protocol";
    static final String URLCHECK_PROPERTY = "ij.URLCheck";
    static final String USER_PROPERTY = "ij.user";
    static final String PASSWORD_PROPERTY = "ij.password";
    static final String FRAMEWORK_PROPERTY = "framework";
    boolean elapsedTime = false;
    Connection theConnection = null;
    ConnectionEnv currentConnEnv = null;
    String urlCheck = null;
    xaAbstractHelper xahelper = null;
    boolean exit = false;
    utilMain utilInstance = null;
    Hashtable ignoreErrors = null;
    String protocol = null;
    Hashtable<String, String> namedProtocols;
    public ijTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[69];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector<int[]> jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    ij(ijTokenManager tm, utilMain utilInstance) {
        this(tm);
        this.utilInstance = utilInstance;
    }

    void initFromEnvironment() {
        Properties p = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
        this.urlCheck = p.getProperty(URLCHECK_PROPERTY);
        this.protocol = p.getProperty(PROTOCOL_PROPERTY);
        String framework_property = p.getProperty(FRAMEWORK_PROPERTY);
        if (ij.JDBC20X() && ij.JTA()) {
            try {
                Class<?> clazz = Class.forName("org.apache.derby.impl.tools.ij.xaHelper");
                this.xahelper = (xaAbstractHelper)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.xahelper.setFramework(framework_property);
            }
            catch (Exception clazz) {
                // empty catch block
            }
        }
        this.namedProtocols = new Hashtable();
        String prefix = "ij.protocol.";
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix)) continue;
            String name = key.substring(prefix.length());
            this.installProtocol(name.toUpperCase(Locale.ENGLISH), p.getProperty(key));
        }
    }

    private static boolean JDBC20X() {
        try {
            Class.forName("javax.sql.DataSource");
            Class.forName("javax.sql.ConnectionPoolDataSource");
            Class.forName("javax.sql.PooledConnection");
            Class.forName("javax.sql.XAConnection");
            Class.forName("javax.sql.XADataSource");
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    private static boolean JTA() {
        try {
            Class.forName("javax.transaction.xa.Xid");
            Class.forName("javax.transaction.xa.XAResource");
            Class.forName("javax.transaction.xa.XAException");
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public static boolean JNDI() {
        try {
            Class.forName("javax.naming.spi.Resolver");
            Class.forName("javax.naming.Referenceable");
            Class.forName("javax.naming.directory.Attribute");
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    SQLWarning appendWarnings(SQLWarning wHead, SQLWarning wTail) {
        if (wHead == null) {
            return wTail;
        }
        if (wHead.getNextException() == null) {
            wHead.setNextException(wTail);
        } else {
            this.appendWarnings(wHead.getNextWarning(), wTail);
        }
        return wHead;
    }

    boolean getElapsedTimeState() {
        return this.elapsedTime;
    }

    String stringValue(String s) {
        String result = s.substring(1, s.length() - 1);
        int quotes = 39;
        int index = result.indexOf(quotes);
        while (index != -1) {
            result = result.substring(0, index + 1) + result.substring(index + 2);
            index = result.indexOf(quotes, index + 1);
        }
        return result;
    }

    void installProtocol(String name, String value) {
        try {
            util.loadDriverIfKnown(value);
        }
        catch (ClassNotFoundException e) {
            throw ijException.classNotFoundForProtocol(value);
        }
        catch (IllegalArgumentException e) {
            throw ijException.classNotFoundForProtocol(value);
        }
        catch (IllegalAccessException e) {
            throw ijException.classNotFoundForProtocol(value);
        }
        catch (InstantiationException e) {
            throw ijException.classNotFoundForProtocol(value);
        }
        catch (NoSuchMethodException e) {
            throw ijException.classNotFoundForProtocol(value);
        }
        catch (InvocationTargetException e) {
            throw ijException.classNotFoundForProtocol(value);
        }
        if (name == null) {
            this.protocol = value;
        } else {
            this.namedProtocols.put(name, value);
        }
    }

    void haveConnection() {
        JDBCDisplayUtil.checkNotNull(this.theConnection, "connection");
    }

    Session findSession(String name) {
        Session session = this.currentConnEnv.getSession(name);
        if (session == null) {
            throw ijException.noSuchConnection(name);
        }
        return session;
    }

    PreparedStatement findPreparedStatement(QualifiedIdentifier qi) {
        Session session = this.findSession(qi.getSessionName());
        PreparedStatement ps = session.getPreparedStatement(qi.getLocalName());
        JDBCDisplayUtil.checkNotNull(ps, "prepared statement " + qi);
        return ps;
    }

    ResultSet findCursor(QualifiedIdentifier qi) {
        Session session = this.findSession(qi.getSessionName());
        ResultSet c = session.getCursor(qi.getLocalName());
        JDBCDisplayUtil.checkNotNull(c, "cursor " + qi);
        return c;
    }

    ijResult executeImmediate(String stmt) throws SQLException {
        Statement aStatement = null;
        try {
            long beginTime = 0L;
            long endTime = 0L;
            boolean cleanUpStmt = false;
            this.haveConnection();
            aStatement = this.theConnection.createStatement();
            if (this.currentConnEnv != null) {
                DatabaseMetaData dbmd;
                int majorVersion;
                boolean trimForDNC = this.currentConnEnv.getSession().getIsDNC();
                if (trimForDNC && ((majorVersion = (dbmd = this.theConnection.getMetaData()).getDriverMajorVersion()) > 10 || majorVersion == 10 && dbmd.getDriverMinorVersion() > 1)) {
                    trimForDNC = false;
                }
                if (this.currentConnEnv.getSession().getIsJCC() || trimForDNC) {
                    while (stmt.startsWith("--")) {
                        int nextline = stmt.indexOf(10) + 1;
                        stmt = stmt.substring(nextline);
                    }
                    stmt = stmt.trim();
                }
            }
            aStatement.execute(stmt);
            return new ijStatementResult(aStatement, true);
        }
        catch (SQLException e) {
            try {
                if (aStatement != null) {
                    aStatement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    ijResult quit() throws SQLException {
        this.exit = true;
        this.currentConnEnv.removeAllSessions();
        this.theConnection = null;
        return null;
    }

    ijResult executeAsync(String stmt, QualifiedIdentifier qi) {
        Session sn = this.findSession(qi.getSessionName());
        AsyncStatement as = new AsyncStatement(sn.getConnection(), stmt);
        sn.addAsyncStatement(qi.getLocalName(), as);
        as.start();
        return null;
    }

    void setConnection(ConnectionEnv connEnv, boolean multipleEnvironments) {
        Connection conn = connEnv.getConnection();
        if (connEnv != this.currentConnEnv) {
            this.currentConnEnv = connEnv;
        }
        if (this.theConnection == conn) {
            return;
        }
        if (this.theConnection != null && !multipleEnvironments) {
            throw ijException.needToDisconnect();
        }
        this.theConnection = conn;
    }

    private ijResult addSession(Connection newConnection, String name) throws SQLException {
        if (this.currentConnEnv.haveSession(name)) {
            throw ijException.alreadyHaveConnectionNamed(name);
        }
        this.currentConnEnv.addSession(newConnection, name);
        return new ijConnectionResult(newConnection);
    }

    private String[] sortConnectionNames() {
        int size = 100;
        int count = 0;
        Object[] array = new String[size];
        Hashtable<String, Session> ss = this.currentConnEnv.getSessions();
        Enumeration<String> connectionNames = ss.keys();
        while (connectionNames.hasMoreElements()) {
            if (count == size) {
                String[] expandedArray = new String[size *= 2];
                System.arraycopy(array, 0, expandedArray, 0, count);
                array = expandedArray;
            }
            String key = connectionNames.nextElement();
            array[count++] = key;
        }
        Arrays.sort(array, 0, count);
        return array;
    }

    public ijResult showConnectionsMethod(boolean ignore0Rows) throws SQLException {
        Hashtable<String, Session> ss = this.currentConnEnv.getSessions();
        Vector<Object> v = new Vector<Object>();
        SQLWarning w = null;
        if (ss == null || ss.size() == 0) {
            if (!ignore0Rows) {
                v.addElement(LocalizedResource.getMessage("IJ_NoConneAvail", new Object[0]));
            }
        } else {
            boolean haveCurrent = false;
            int count = 0;
            Enumeration<String> connectionNames = ss.keys();
            while (connectionNames.hasMoreElements()) {
                ++count;
                connectionNames.nextElement();
            }
            String[] array = this.sortConnectionNames();
            for (int ictr = 0; ictr < count; ++ictr) {
                String dsName;
                String connectionName = array[ictr];
                Session s = ss.get(connectionName);
                if (s.getConnection().isClosed()) {
                    if (this.currentConnEnv.getSession() != null && connectionName.equals(this.currentConnEnv.getSession().getName())) {
                        this.currentConnEnv.removeCurrentSession();
                        this.theConnection = null;
                        continue;
                    }
                    this.currentConnEnv.removeSession(connectionName);
                    continue;
                }
                StringBuffer row = new StringBuffer();
                row.append(connectionName);
                if (this.currentConnEnv.getSession() != null && connectionName.equals(this.currentConnEnv.getSession().getName())) {
                    row.append('*');
                    haveCurrent = true;
                }
                if ((dsName = util.getSystemProperty("ij.dataSource")) == null) {
                    row.append(" - \t");
                    row.append(s.getConnection().getMetaData().getURL());
                }
                w = this.appendWarnings(w, s.getConnection().getWarnings());
                s.getConnection().clearWarnings();
                v.addElement(row.toString());
            }
            if (haveCurrent) {
                v.addElement(LocalizedResource.getMessage("IJ_CurreConne", new Object[0]));
            } else {
                v.addElement(LocalizedResource.getMessage("IJ_NoCurreConne", new Object[0]));
            }
        }
        return new ijVectorResult(v, w);
    }

    public static int[] intArraySubset(int[] input, int start, int end) {
        int[] res = new int[end - start];
        System.arraycopy(input, start, res, 0, end - start);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyTableExists(String schema, String table) throws SQLException {
        if (schema == null) {
            return;
        }
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = this.theConnection.getMetaData();
            rs = dbmd.getTables(null, schema, table, null);
            if (!rs.next()) {
                throw ijException.noSuchTable(table);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public ijResult showTables(String schema, String[] tableType) throws SQLException {
        ResultSet rs = null;
        try {
            this.haveConnection();
            DatabaseMetaData dbmd = this.theConnection.getMetaData();
            rs = dbmd.getTables(null, schema, null, tableType);
            int[] displayColumns = new int[]{rs.findColumn("TABLE_SCHEM"), rs.findColumn("TABLE_NAME"), rs.findColumn("REMARKS")};
            int[] columnWidths = new int[]{20, 30, 20};
            return new ijResultSetResult(rs, displayColumns, columnWidths);
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    private ResultSet getIndexInfoForTable(String schema, String table) throws SQLException {
        this.haveConnection();
        this.verifyTableExists(schema, table);
        DatabaseMetaData dbmd = this.theConnection.getMetaData();
        return dbmd.getIndexInfo(null, schema, table, false, true);
    }

    private int[] getDisplayColumnsForIndex(String schema, ResultSet rs) throws SQLException {
        int[] displayColumns = new int[]{rs.findColumn("TABLE_SCHEM"), rs.findColumn("TABLE_NAME"), rs.findColumn("COLUMN_NAME"), rs.findColumn("NON_UNIQUE"), rs.findColumn("TYPE"), rs.findColumn("ASC_OR_DESC"), rs.findColumn("CARDINALITY"), rs.findColumn("PAGES")};
        if (schema != null) {
            displayColumns = ij.intArraySubset(displayColumns, 1, displayColumns.length);
        }
        return displayColumns;
    }

    private int[] getColumnWidthsForIndex(String schema) {
        int[] columnWidths = new int[]{20, 20, 20, 6, 4, 4, 8, 8};
        if (schema != null) {
            columnWidths = ij.intArraySubset(columnWidths, 1, columnWidths.length);
        }
        return columnWidths;
    }

    public ijResult showIndexes(String schema, String table) throws SQLException {
        ijResult result = null;
        int[] displayColumns = null;
        int[] columnWidths = null;
        try {
            if (table != null) {
                ResultSet rs = this.getIndexInfoForTable(schema, table);
                displayColumns = this.getDisplayColumnsForIndex(schema, rs);
                columnWidths = this.getColumnWidthsForIndex(schema);
                result = new ijResultSetResult(rs, displayColumns, columnWidths);
            } else {
                this.haveConnection();
                this.verifyTableExists(schema, table);
                DatabaseMetaData dbmd = this.theConnection.getMetaData();
                ResultSet tablers = dbmd.getTables(null, schema, null, null);
                ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
                boolean firstIteration = true;
                ResultSet current_rs = null;
                while (tablers.next()) {
                    String tableName = tablers.getString("TABLE_NAME");
                    current_rs = this.getIndexInfoForTable(schema, tableName);
                    resultSets.add(current_rs);
                    if (!firstIteration) continue;
                    displayColumns = this.getDisplayColumnsForIndex(schema, current_rs);
                    columnWidths = this.getColumnWidthsForIndex(schema);
                    firstIteration = false;
                }
                result = new ijMultipleResultSetResult(resultSets, displayColumns, columnWidths);
            }
            return result;
        }
        catch (SQLException e) {
            try {
                if (result != null) {
                    result.closeStatement();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    public ijResult showProcedures(String schema) throws SQLException {
        ResultSet rs = null;
        try {
            this.haveConnection();
            DatabaseMetaData dbmd = this.theConnection.getMetaData();
            rs = dbmd.getProcedures(null, schema, null);
            int[] displayColumns = new int[]{rs.findColumn("PROCEDURE_SCHEM"), rs.findColumn("PROCEDURE_NAME"), rs.findColumn("REMARKS")};
            int[] columnWidths = new int[]{20, 30, 20};
            return new ijResultSetResult(rs, displayColumns, columnWidths);
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    public ijResult showFunctions(String schema) throws SQLException {
        ResultSet rs = null;
        try {
            this.haveConnection();
            DatabaseMetaData dbmd = this.theConnection.getMetaData();
            try {
                Method getFunctions = dbmd.getClass().getMethod("getFunctions", String.class, String.class, String.class);
                rs = (ResultSet)getFunctions.invoke((Object)dbmd, null, schema, null);
            }
            catch (NoSuchMethodException nsme) {
                throw ijException.notAvailableForDriver(dbmd.getDriverName());
            }
            catch (IllegalAccessException iae) {
                throw ijException.notAvailableForDriver(dbmd.getDriverName());
            }
            catch (AbstractMethodError ame) {
                throw ijException.notAvailableForDriver(dbmd.getDriverName());
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw ijException.notAvailableForDriver(dbmd.getDriverName());
            }
            int[] displayColumns = new int[]{rs.findColumn("FUNCTION_SCHEM"), rs.findColumn("FUNCTION_NAME"), rs.findColumn("REMARKS")};
            int[] columnWidths = new int[]{14, 28, 35};
            return new ijResultSetResult(rs, displayColumns, columnWidths);
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    public ijResult showSchemas() throws SQLException {
        ResultSet rs = null;
        try {
            this.haveConnection();
            DatabaseMetaData dbmd = this.theConnection.getMetaData();
            rs = dbmd.getSchemas();
            int[] displayColumns = new int[]{rs.findColumn("TABLE_SCHEM")};
            int[] columnWidths = new int[]{30};
            return new ijResultSetResult(rs, displayColumns, columnWidths);
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    public ijResult showRoles() throws SQLException {
        ResultSet rs = null;
        try {
            this.haveConnection();
            if (this.currentConnEnv.getSession().getIsDNC() || this.currentConnEnv.getSession().getIsEmbeddedDerby()) {
                rs = this.theConnection.createStatement().executeQuery("SELECT ROLEID FROM SYS.SYSROLES WHERE ISDEF='Y' ORDER BY ROLEID ASC");
                int[] displayColumns = new int[]{rs.findColumn("ROLEID")};
                int[] columnWidths = new int[]{30};
                return new ijResultSetResult(rs, displayColumns, columnWidths);
            }
            throw ijException.notAvailableForDriver(this.theConnection.getMetaData().getDriverName());
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    public ijResult showEnabledRoles() throws SQLException {
        ResultSet rs = null;
        try {
            this.haveConnection();
            if (this.currentConnEnv.getSession().getIsDNC() || this.currentConnEnv.getSession().getIsEmbeddedDerby()) {
                rs = this.theConnection.createStatement().executeQuery("SELECT * FROM\t TABLE(\t   SYSCS_DIAG.CONTAINED_ROLES(CURRENT_ROLE)) T ORDER BY ROLEID");
                int[] displayColumns = new int[]{rs.findColumn("ROLEID")};
                int[] columnWidths = new int[]{30};
                return new ijResultSetResult(rs, displayColumns, columnWidths);
            }
            throw ijException.notAvailableForDriver(this.theConnection.getMetaData().getDriverName());
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    public ijResult showSettableRoles() throws SQLException {
        ResultSet rs = null;
        String query = "select distinct * from (  select roleid from sys.sysroles s    where s.grantee = current_user or s.grantee = 'PUBLIC'  union  select roleid from sys.sysroles s    where s.isdef='Y' and current_user in        (select authorizationid from sys.sysschemas             where schemaname = 'SYS')) t order by roleid";
        try {
            this.haveConnection();
            if (this.currentConnEnv.getSession().getIsDNC() || this.currentConnEnv.getSession().getIsEmbeddedDerby()) {
                rs = this.theConnection.createStatement().executeQuery("select distinct * from (  select roleid from sys.sysroles s    where s.grantee = current_user or s.grantee = 'PUBLIC'  union  select roleid from sys.sysroles s    where s.isdef='Y' and current_user in        (select authorizationid from sys.sysschemas             where schemaname = 'SYS')) t order by roleid");
                int[] displayColumns = new int[]{rs.findColumn("ROLEID")};
                int[] columnWidths = new int[]{30};
                return new ijResultSetResult(rs, displayColumns, columnWidths);
            }
            throw ijException.notAvailableForDriver(this.theConnection.getMetaData().getDriverName());
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    public ijResult describeTable(String schema, String table) throws SQLException {
        ResultSet rs = null;
        try {
            this.haveConnection();
            this.verifyTableExists(schema, table);
            DatabaseMetaData dbmd = this.theConnection.getMetaData();
            rs = dbmd.getColumns(null, schema, table, null);
            int[] displayColumns = new int[]{rs.findColumn("TABLE_SCHEM"), rs.findColumn("TABLE_NAME"), rs.findColumn("COLUMN_NAME"), rs.findColumn("TYPE_NAME"), rs.findColumn("DECIMAL_DIGITS"), rs.findColumn("NUM_PREC_RADIX"), rs.findColumn("COLUMN_SIZE"), rs.findColumn("COLUMN_DEF"), rs.findColumn("CHAR_OCTET_LENGTH"), rs.findColumn("IS_NULLABLE")};
            int[] columnWidths = new int[]{20, 20, 20, 9, 4, 4, 6, 10, 10, 8};
            if (schema != null && table != null) {
                displayColumns = ij.intArraySubset(displayColumns, 2, displayColumns.length);
                columnWidths = ij.intArraySubset(columnWidths, 2, columnWidths.length);
            }
            return new ijResultSetResult(rs, displayColumns, columnWidths);
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    private Object makeXid(int xid) {
        return null;
    }

    public final ijResult ijStatement() throws ParseException, SQLException {
        ijResult r = null;
        if (this.jj_2_1(1)) {
            if (this.getToken((int)1).kind == 77 && this.getToken((int)3).kind != 79 && this.getToken((int)3).kind != 80) {
                r = this.RollbackStatement();
            } else {
                switch (this.jj_nt.kind) {
                    case 14: {
                        r = this.AbsoluteStatement();
                        break;
                    }
                    case 15: {
                        r = this.AfterLastStatement();
                        break;
                    }
                    case 21: {
                        r = this.AutocommitStatement();
                        break;
                    }
                    case 19: {
                        r = this.AsyncStatement();
                        break;
                    }
                    case 22: {
                        r = this.Bang();
                        break;
                    }
                    case 23: {
                        r = this.BeforeFirstStatement();
                        break;
                    }
                    case 24: {
                        r = this.CloseStatement();
                        break;
                    }
                    case 25: {
                        r = this.CommitStatement();
                        break;
                    }
                    case 26: {
                        r = this.ConnectStatement();
                        break;
                    }
                    case 31: {
                        r = this.DescTableStatement();
                        break;
                    }
                    case 32: {
                        r = this.DisconnectStatement();
                        break;
                    }
                    case 33: {
                        r = this.DriverStatement();
                        break;
                    }
                    case 34: {
                        r = this.ElapsedTimeStatement();
                        break;
                    }
                    case 38: {
                        r = this.ExecuteStatement();
                        break;
                    }
                    case 41: {
                        r = this.FirstStatement();
                        break;
                    }
                    case 39: 
                    case 71: {
                        r = this.ExitStatement();
                        break;
                    }
                    case 45: {
                        r = this.GetCursorStatement();
                        break;
                    }
                    case 46: {
                        r = this.GetCurrentRowNumber();
                        break;
                    }
                    case 49: {
                        r = this.HelpStatement();
                        break;
                    }
                    case 48: {
                        r = this.HoldForConnectionStatement();
                        break;
                    }
                    case 54: {
                        r = this.LastStatement();
                        break;
                    }
                    case 55: {
                        r = this.LocalizedDisplay();
                        break;
                    }
                    case 56: {
                        r = this.MaximumDisplayWidthStatement();
                        break;
                    }
                    case 58: {
                        r = this.NextStatement();
                        break;
                    }
                    case 60: {
                        r = this.NoHoldForConnectionStatement();
                        break;
                    }
                    case 65: {
                        r = this.PrepareStatement();
                        break;
                    }
                    case 66: {
                        r = this.PreviousStatement();
                        break;
                    }
                    case 70: {
                        r = this.ProtocolStatement();
                        break;
                    }
                    case 72: {
                        r = this.ReadOnlyStatement();
                        break;
                    }
                    case 73: {
                        r = this.RelativeStatement();
                        break;
                    }
                    case 74: {
                        r = this.RemoveStatement();
                        break;
                    }
                    case 78: {
                        r = this.RunStatement();
                        break;
                    }
                    case 84: {
                        r = this.SetConnectionStatement();
                        break;
                    }
                    case 86: {
                        r = this.ShowStatement();
                        break;
                    }
                    case 94: {
                        r = this.WaitForStatement();
                        break;
                    }
                    case 98: {
                        r = this.XA_DataSourceStatement();
                        break;
                    }
                    case 99: {
                        r = this.XA_ConnectStatement();
                        break;
                    }
                    case 100: {
                        r = this.XA_CommitStatement();
                        break;
                    }
                    case 101: {
                        r = this.XA_DisconnectStatement();
                        break;
                    }
                    case 106: {
                        r = this.XA_GetConnectionStatement();
                        break;
                    }
                    case 102: {
                        r = this.XA_EndStatement();
                        break;
                    }
                    case 105: {
                        r = this.XA_ForgetStatement();
                        break;
                    }
                    case 109: {
                        r = this.XA_PrepareStatement();
                        break;
                    }
                    case 110: {
                        r = this.XA_RecoverStatement();
                        break;
                    }
                    case 112: {
                        r = this.XA_RollbackStatement();
                        break;
                    }
                    case 113: {
                        r = this.XA_StartStatement();
                        break;
                    }
                    case 117: {
                        r = this.DataSourceStatement();
                        break;
                    }
                    case 118: {
                        r = this.CP_DataSourceStatement();
                        break;
                    }
                    case 119: {
                        r = this.CP_ConnectStatement();
                        break;
                    }
                    case 120: {
                        r = this.CP_GetConnectionStatement();
                        break;
                    }
                    case 121: {
                        r = this.CP_DisconnectStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        this.jj_consume_token(0);
        return r;
    }

    public final ijResult ProtocolStatement() throws ParseException, SQLException {
        String n = null;
        this.jj_consume_token(70);
        Token t = this.jj_consume_token(135);
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                n = this.identifier();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.installProtocol(n, this.stringValue(t.image));
        return null;
    }

    public final ijResult DriverStatement() throws ParseException, SQLException {
        String sVal = null;
        this.jj_consume_token(33);
        Token t = this.jj_consume_token(135);
        try {
            sVal = this.stringValue(t.image);
            util.loadDriver(sVal);
        }
        catch (ClassNotFoundException e) {
            throw ijException.classNotFound(sVal);
        }
        catch (IllegalArgumentException e) {
            throw ijException.driverNotClassName(sVal);
        }
        catch (IllegalAccessException e) {
            throw ijException.classNotFound(sVal);
        }
        catch (InstantiationException e) {
            throw ijException.classNotFound(sVal);
        }
        catch (NoSuchMethodException e) {
            throw ijException.classNotFound(sVal);
        }
        catch (InvocationTargetException e) {
            throw ijException.classNotFound(sVal);
        }
        return null;
    }

    public final ijResult ConnectStatement() throws ParseException, SQLException {
        ijResult result;
        this.jj_consume_token(26);
        block0 : switch (this.jj_nt.kind) {
            case 79: {
                this.jj_consume_token(79);
                result = this.dynamicConnection(true);
                break;
            }
            case 131: 
            case 135: {
                switch (this.jj_nt.kind) {
                    case 135: {
                        result = this.dynamicConnection(false);
                        break block0;
                    }
                    case 131: {
                        result = this.staticConnection();
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final ijResult dynamicConnection(boolean simplifiedPath) throws ParseException, SQLException {
        String sVal;
        String dsName;
        Token userT = null;
        Token passwordT = null;
        String n = null;
        String p = null;
        String userS = util.getSystemProperty(USER_PROPERTY);
        String passwordS = util.getSystemProperty(PASSWORD_PROPERTY);
        Properties connInfo = new Properties();
        Token t = this.jj_consume_token(135);
        switch (this.jj_nt.kind) {
            case 70: {
                this.jj_consume_token(70);
                p = this.identifier();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 91: {
                this.jj_consume_token(91);
                userT = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 63: {
                this.jj_consume_token(63);
                passwordT = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 20: {
                this.jj_consume_token(20);
                if (!this.jj_2_2(1)) break;
                this.attributeList(connInfo);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                n = this.identifier();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        if (userT != null) {
            userS = this.stringValue(userT.image);
        }
        if (passwordT != null) {
            passwordS = this.stringValue(passwordT.image);
        }
        if ((dsName = util.getSystemProperty("ij.dataSource")) != null && !(sVal = this.stringValue(t.image)).startsWith("jdbc:")) {
            this.theConnection = util.getDataSourceConnection(dsName, userS, passwordS, sVal, false);
            return this.addSession(this.theConnection, n);
        }
        sVal = simplifiedPath ? "jdbc:derby:" + this.stringValue(t.image) : this.stringValue(t.image);
        if (p != null) {
            String protocol = this.namedProtocols.get(p);
            if (protocol == null) {
                throw ijException.noSuchProtocol(p);
            }
            sVal = protocol + sVal;
        }
        boolean noDriver = false;
        try {
            if (sVal.startsWith("jdbc:")) {
                util.loadDriverIfKnown(sVal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.urlCheck == null || Boolean.valueOf(this.urlCheck).booleanValue()) {
            URLCheck uRLCheck = new URLCheck(sVal);
        }
        if (!sVal.startsWith("jdbc:") && p == null && this.protocol != null) {
            sVal = this.protocol + sVal;
        }
        connInfo = util.updateConnInfo(userS, passwordS, connInfo);
        this.theConnection = DriverManager.getConnection(sVal, connInfo);
        return this.addSession(this.theConnection, n);
    }

    public final ijResult DescTableStatement() throws ParseException, SQLException {
        String table;
        String schema;
        String i = null;
        String i2 = null;
        Token s = null;
        this.jj_consume_token(31);
        switch (this.jj_nt.kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 131: {
                i = this.caIdentifier();
                switch (this.jj_nt.kind) {
                    case 64: {
                        this.jj_consume_token(64);
                        i2 = this.caIdentifier();
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                if (i2 == null) {
                    schema = null;
                    table = i;
                    break;
                }
                schema = i;
                table = i2;
                break;
            }
            case 135: {
                s = this.jj_consume_token(135);
                i2 = this.stringValue(s.image);
                if (i2.length() == 0) {
                    throw ijException.noSuchTable("(missing)");
                }
                int dotPosition = i2.indexOf(46);
                if (dotPosition != -1) {
                    i = i2.substring(0, dotPosition);
                    i2 = i2.substring(dotPosition + 1);
                }
                if ("*".equals(i2)) {
                    i2 = null;
                }
                schema = i;
                table = i2;
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (schema == null) {
            schema = util.getSelectedSchema(this.theConnection);
        }
        return this.describeTable(schema, table);
    }

    public final ijResult staticConnection() throws ParseException, SQLException {
        String name = null;
        int idx = 0;
        int lastID = 0;
        ijResult result = null;
        Vector<String> idList = this.staticMethodName();
        Object[] args = this.staticMethodArgs();
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        lastID = idList.size() - 1;
        StringBuffer buffer = new StringBuffer();
        while (idx < lastID) {
            if (idx > 0) {
                buffer.append(".");
            }
            buffer.append(idList.elementAt(idx));
            ++idx;
        }
        String methodName = idList.elementAt(idx);
        String className = buffer.toString();
        try {
            int argCount = args.length;
            Class[] argTypes = new Class[argCount];
            Class<?> stringClass = Class.forName("java.lang.String");
            for (idx = 0; idx < argCount; ++idx) {
                argTypes[idx] = stringClass;
            }
            Class<?> classC = Class.forName(className);
            Method method = classC.getMethod(methodName, argTypes);
            this.theConnection = (Connection)method.invoke(null, args);
            result = this.addSession(this.theConnection, name);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new SQLException(t.toString());
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        return result;
    }

    public final ijResult SetConnectionStatement() throws ParseException, SQLException {
        this.jj_consume_token(84);
        this.jj_consume_token(27);
        String t = this.identifier();
        if (!this.currentConnEnv.haveSession(t)) {
            throw ijException.noSuchConnection(t);
        }
        this.currentConnEnv.setCurrentSession(t);
        this.theConnection = this.currentConnEnv.getConnection();
        return new ijConnectionResult(this.theConnection);
    }

    public final ijResult ShowStatement() throws ParseException, SQLException {
        String schema = null;
        String tblname = null;
        String str = null;
        String[] types = null;
        Token t = null;
        Token v = null;
        this.jj_consume_token(86);
        switch (this.jj_nt.kind) {
            case 28: {
                this.jj_consume_token(28);
                return this.showConnectionsMethod(false);
            }
            case 16: 
            case 89: 
            case 90: 
            case 93: {
                switch (this.jj_nt.kind) {
                    case 90: {
                        t = this.jj_consume_token(90);
                        break;
                    }
                    case 93: {
                        v = this.jj_consume_token(93);
                        break;
                    }
                    case 89: {
                        this.jj_consume_token(89);
                        break;
                    }
                    case 16: {
                        this.jj_consume_token(16);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_nt.kind) {
                    case 50: {
                        this.jj_consume_token(50);
                        schema = this.caIdentifier();
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                types = t != null ? new String[]{"TABLE", "SYSTEM TABLE"} : (v != null ? new String[]{"VIEW"} : new String[]{"SYNONYM"});
                return this.showTables(schema, types);
            }
            case 51: {
                this.jj_consume_token(51);
                block20 : switch (this.jj_nt.kind) {
                    case 43: 
                    case 50: {
                        switch (this.jj_nt.kind) {
                            case 50: {
                                this.jj_consume_token(50);
                                schema = this.caIdentifier();
                                break block20;
                            }
                            case 43: {
                                this.jj_consume_token(43);
                                tblname = this.caIdentifier();
                                switch (this.jj_nt.kind) {
                                    case 64: {
                                        this.jj_consume_token(64);
                                        str = this.caIdentifier();
                                        break block20;
                                    }
                                }
                                this.jj_la1[14] = this.jj_gen;
                                break block20;
                            }
                        }
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                if (str != null) {
                    schema = tblname;
                    tblname = str;
                }
                if (schema == null && tblname != null) {
                    schema = util.getSelectedSchema(this.theConnection);
                }
                return this.showIndexes(schema, tblname);
            }
            case 68: {
                this.jj_consume_token(68);
                switch (this.jj_nt.kind) {
                    case 50: {
                        this.jj_consume_token(50);
                        schema = this.caIdentifier();
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                    }
                }
                return this.showProcedures(schema);
            }
            case 44: {
                this.jj_consume_token(44);
                switch (this.jj_nt.kind) {
                    case 50: {
                        this.jj_consume_token(50);
                        schema = this.caIdentifier();
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                    }
                }
                return this.showFunctions(schema);
            }
            case 81: {
                this.jj_consume_token(81);
                return this.showSchemas();
            }
            case 76: {
                this.jj_consume_token(76);
                return this.showRoles();
            }
            case 35: {
                this.jj_consume_token(35);
                return this.showEnabledRoles();
            }
            case 85: {
                this.jj_consume_token(85);
                return this.showSettableRoles();
            }
        }
        this.jj_la1[19] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult CommitStatement() throws ParseException, SQLException {
        this.jj_consume_token(25);
        switch (this.jj_nt.kind) {
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.haveConnection();
        this.theConnection.commit();
        return null;
    }

    public final ijResult RollbackStatement() throws ParseException, SQLException {
        this.jj_consume_token(77);
        switch (this.jj_nt.kind) {
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        this.haveConnection();
        this.theConnection.rollback();
        return null;
    }

    public final ijResult DisconnectStatement() throws ParseException, SQLException {
        Token a = null;
        String n = null;
        this.jj_consume_token(32);
        block0 : switch (this.jj_nt.kind) {
            case 17: 
            case 29: 
            case 131: {
                switch (this.jj_nt.kind) {
                    case 29: {
                        this.jj_consume_token(29);
                        break block0;
                    }
                    case 17: {
                        a = this.jj_consume_token(17);
                        break block0;
                    }
                    case 131: {
                        n = this.identifier();
                        break block0;
                    }
                }
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        if (a == null) {
            if (n == null) {
                this.haveConnection();
                this.currentConnEnv.removeCurrentSession();
                this.theConnection = null;
            } else {
                if (!this.currentConnEnv.haveSession(n)) {
                    throw ijException.noSuchConnection(n);
                }
                this.currentConnEnv.removeSession(n);
                if (this.currentConnEnv.getSession() == null) {
                    this.theConnection = null;
                }
            }
        } else {
            this.currentConnEnv.removeAllSessions();
            this.theConnection = null;
        }
        return null;
    }

    public final ijResult ExitStatement() throws ParseException, SQLException {
        switch (this.jj_nt.kind) {
            case 39: {
                this.jj_consume_token(39);
                return this.quit();
            }
            case 71: {
                this.jj_consume_token(71);
                return this.quit();
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult PrepareStatement() throws ParseException, SQLException {
        this.jj_consume_token(65);
        switch (this.jj_nt.kind) {
            case 67: {
                this.jj_consume_token(67);
                this.jj_consume_token(18);
                Token t = this.jj_consume_token(135);
                throw ijException.illegalStatementName("procedure");
            }
            case 131: {
                QualifiedIdentifier qi = this.qualifiedIdentifier();
                this.jj_consume_token(18);
                Token t = this.jj_consume_token(135);
                Session session = this.findSession(qi.getSessionName());
                String sVal = this.stringValue(t.image);
                PreparedStatement ps = session.getConnection().prepareStatement(sVal);
                JDBCDisplayUtil.checkNotNull(ps, "prepared statement");
                session.addPreparedStatement(qi.getLocalName(), ps);
                SQLWarning w = ps.getWarnings();
                ps.clearWarnings();
                return new ijWarningResult(w);
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult GetCursorStatement() throws ParseException, SQLException {
        this.haveConnection();
        int scrollType = 1003;
        Token scrolling = null;
        Token withtoken = null;
        int holdType = this.theConnection.getHoldability();
        Statement st = null;
        ResultSet rs = null;
        this.jj_consume_token(45);
        switch (this.jj_nt.kind) {
            case 82: {
                scrolling = this.jj_consume_token(82);
                scrollType = this.scrollType();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 95: {
                withtoken = this.jj_consume_token(95);
                holdType = this.holdType();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        this.jj_consume_token(30);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        this.jj_consume_token(18);
        Token s = this.jj_consume_token(135);
        String sVal = this.stringValue(s.image);
        try {
            Session sn = this.findSession(qi.getSessionName());
            st = sn.getConnection().createStatement(scrollType, 1007, holdType);
            JDBCDisplayUtil.checkNotNull(st, "cursor");
            st.setCursorName(qi.getLocalName());
            rs = st.executeQuery(sVal);
            JDBCDisplayUtil.checkNotNull(rs, "cursor");
            sn.addCursorStatement(qi.getLocalName(), st);
            sn.addCursor(qi.getLocalName(), rs);
        }
        catch (SQLException e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
        SQLWarning w1 = this.theConnection.getWarnings();
        SQLWarning w2 = st.getWarnings();
        SQLWarning w3 = rs.getWarnings();
        this.theConnection.clearWarnings();
        st.clearWarnings();
        rs.clearWarnings();
        SQLWarning warns = this.appendWarnings(w1, w2);
        return new ijWarningResult(this.appendWarnings(warns, w3));
    }

    public final int scrollType() throws ParseException, SQLException {
        switch (this.jj_nt.kind) {
            case 52: {
                this.jj_consume_token(52);
                return 1004;
            }
            case 83: {
                this.jj_consume_token(83);
                return 1005;
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int holdType() throws ParseException, SQLException {
        switch (this.jj_nt.kind) {
            case 47: {
                this.jj_consume_token(47);
                return 1;
            }
            case 59: {
                this.jj_consume_token(59);
                return 2;
            }
        }
        this.jj_la1[29] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult AbsoluteStatement() throws ParseException, SQLException {
        this.jj_consume_token(14);
        int row = this.intLiteral();
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        ResultSet rs = this.findCursor(qi);
        return this.utilInstance.absolute(rs, row);
    }

    public final ijResult RelativeStatement() throws ParseException, SQLException {
        this.jj_consume_token(73);
        int row = this.intLiteral();
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        ResultSet rs = this.findCursor(qi);
        return this.utilInstance.relative(rs, row);
    }

    public final ijResult BeforeFirstStatement() throws ParseException, SQLException {
        this.jj_consume_token(23);
        this.jj_consume_token(41);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        ResultSet rs = this.findCursor(qi);
        return this.utilInstance.beforeFirst(rs);
    }

    public final ijResult FirstStatement() throws ParseException, SQLException {
        this.jj_consume_token(41);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        ResultSet rs = this.findCursor(qi);
        return this.utilInstance.first(rs);
    }

    public final ijResult NextStatement() throws ParseException, SQLException {
        this.jj_consume_token(58);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        ResultSet rs = this.findCursor(qi);
        return new ijRowResult(rs, rs.next());
    }

    public final ijResult AfterLastStatement() throws ParseException, SQLException {
        this.jj_consume_token(15);
        this.jj_consume_token(54);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        ResultSet rs = this.findCursor(qi);
        return this.utilInstance.afterLast(rs);
    }

    public final ijResult LastStatement() throws ParseException, SQLException {
        this.jj_consume_token(54);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        ResultSet rs = this.findCursor(qi);
        return this.utilInstance.last(rs);
    }

    public final ijResult PreviousStatement() throws ParseException, SQLException {
        this.jj_consume_token(66);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        ResultSet rs = this.findCursor(qi);
        return this.utilInstance.previous(rs);
    }

    public final ijResult GetCurrentRowNumber() throws ParseException, SQLException {
        this.jj_consume_token(46);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        ResultSet rs = this.findCursor(qi);
        return new ijVectorResult(this.utilInstance.getCurrentRowNumber(rs), null);
    }

    public final ijResult CloseStatement() throws ParseException, SQLException {
        this.jj_consume_token(24);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        Session sn = this.findSession(qi.getSessionName());
        ResultSet rs = sn.getCursor(qi.getLocalName());
        JDBCDisplayUtil.checkNotNull(rs, "cursor " + qi);
        Statement s = sn.getCursorStatement(qi.getLocalName());
        JDBCDisplayUtil.checkNotNull(s, "cursor" + qi);
        rs.close();
        s.close();
        sn.removeCursor(qi.getLocalName());
        sn.removeCursorStatement(qi.getLocalName());
        return null;
    }

    public final ijResult ExecuteStatement() throws ParseException, SQLException {
        QualifiedIdentifier qi = null;
        Token s = null;
        String sVal = null;
        QualifiedIdentifier qiUsing = null;
        Token sUsing = null;
        Object usingObject = null;
        this.jj_consume_token(38);
        switch (this.jj_nt.kind) {
            case 88: {
                this.jj_consume_token(88);
                s = this.jj_consume_token(135);
                return this.executeImmediate(this.stringValue(s.image));
            }
            case 67: {
                this.jj_consume_token(67);
                s = this.jj_consume_token(135);
                this.haveConnection();
                Statement aStatement = this.theConnection.createStatement();
                String text = "execute procedure " + s;
                aStatement.execute(text);
                return new ijStatementResult(aStatement, true);
            }
            case 131: 
            case 135: {
                switch (this.jj_nt.kind) {
                    case 131: {
                        qi = this.qualifiedIdentifier();
                        break;
                    }
                    case 135: {
                        s = this.jj_consume_token(135);
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block9 : switch (this.jj_nt.kind) {
                    case 92: {
                        this.jj_consume_token(92);
                        switch (this.jj_nt.kind) {
                            case 131: {
                                qiUsing = this.qualifiedIdentifier();
                                break block9;
                            }
                            case 135: {
                                sUsing = this.jj_consume_token(135);
                                break block9;
                            }
                        }
                        this.jj_la1[31] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                    }
                }
                if (qiUsing != null || sUsing != null) {
                    PreparedStatement psUsing;
                    PreparedStatement ps;
                    String sUsingVal = null;
                    SQLWarning warns = null;
                    boolean closeWhenDone = false;
                    if (qi != null) {
                        ps = this.findPreparedStatement(qi);
                    } else {
                        sVal = this.stringValue(s.image);
                        ps = this.theConnection.prepareStatement(sVal);
                        closeWhenDone = true;
                        JDBCDisplayUtil.checkNotNull(ps, "prepared statement");
                        warns = this.appendWarnings(warns, ps.getWarnings());
                        ps.clearWarnings();
                    }
                    if (qiUsing != null) {
                        psUsing = this.findPreparedStatement(qiUsing);
                    } else {
                        sUsingVal = this.stringValue(sUsing.image);
                        psUsing = this.theConnection.prepareStatement(sUsingVal);
                        JDBCDisplayUtil.checkNotNull(psUsing, "prepared statement");
                        warns = this.appendWarnings(warns, psUsing.getWarnings());
                        psUsing.clearWarnings();
                    }
                    if (psUsing.execute()) {
                        ResultSet rsUsing = psUsing.getResultSet();
                        ResultSetMetaData rsmdUsing = rsUsing.getMetaData();
                        int numCols = rsmdUsing.getColumnCount();
                        boolean exec = false;
                        boolean autoCommited = false;
                        ijMultiResult result = new ijMultiResult(ps, rsUsing, closeWhenDone);
                        return result;
                    }
                    throw ijException.noUsingResults();
                }
                if (qi != null) {
                    this.haveConnection();
                    PreparedStatement ps = this.findPreparedStatement(qi);
                    ps.execute();
                    return new ijStatementResult(ps, false);
                }
                return this.executeImmediate(this.stringValue(s.image));
            }
        }
        this.jj_la1[33] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult AsyncStatement() throws ParseException, SQLException {
        Token s = null;
        this.jj_consume_token(19);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        s = this.jj_consume_token(135);
        return this.executeAsync(this.stringValue(s.image), qi);
    }

    public final ijResult WaitForStatement() throws ParseException, SQLException {
        Object s = null;
        this.jj_consume_token(94);
        this.jj_consume_token(42);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        Session sn = this.findSession(qi.getSessionName());
        AsyncStatement as = sn.getAsyncStatement(qi.getLocalName());
        if (as == null) {
            throw ijException.noSuchAsyncStatement(qi.toString());
        }
        try {
            as.join();
        }
        catch (InterruptedException ie) {
            throw ijException.waitInterrupted(ie);
        }
        return as.getResult();
    }

    public final ijResult RemoveStatement() throws ParseException, SQLException {
        this.jj_consume_token(74);
        QualifiedIdentifier qi = this.qualifiedIdentifier();
        Session s = this.findSession(qi.getSessionName());
        PreparedStatement ps = s.getPreparedStatement(qi.getLocalName());
        JDBCDisplayUtil.checkNotNull(ps, "prepared statement " + qi);
        ps.close();
        s.removePreparedStatement(qi.getLocalName());
        return null;
    }

    public final ijResult RunStatement() throws ParseException, SQLException {
        Token r = null;
        this.jj_consume_token(78);
        switch (this.jj_nt.kind) {
            case 75: {
                r = this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        Token i = this.jj_consume_token(135);
        if (this.utilInstance == null) {
            return null;
        }
        if (r == null) {
            this.utilInstance.newInput(this.stringValue(i.image));
        } else {
            this.utilInstance.newResourceInput(this.stringValue(i.image));
        }
        return null;
    }

    public final ijResult AutocommitStatement() throws ParseException, SQLException {
        Token on = null;
        this.jj_consume_token(21);
        switch (this.jj_nt.kind) {
            case 62: {
                on = this.jj_consume_token(62);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.haveConnection();
        this.theConnection.setAutoCommit(on != null);
        return null;
    }

    public final ijResult NoHoldForConnectionStatement() throws ParseException, SQLException {
        Object on = null;
        this.jj_consume_token(60);
        this.haveConnection();
        this.theConnection.setHoldability(2);
        return null;
    }

    public final ijResult HoldForConnectionStatement() throws ParseException, SQLException {
        Object on = null;
        this.jj_consume_token(48);
        this.haveConnection();
        this.theConnection.setHoldability(1);
        return null;
    }

    public final ijResult LocalizedDisplay() throws ParseException {
        Token on = null;
        this.jj_consume_token(55);
        switch (this.jj_nt.kind) {
            case 62: {
                on = this.jj_consume_token(62);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        LocalizedResource.enableLocalization(on != null);
        return null;
    }

    public final ijResult ReadOnlyStatement() throws ParseException, SQLException {
        Token on = null;
        this.jj_consume_token(72);
        switch (this.jj_nt.kind) {
            case 62: {
                on = this.jj_consume_token(62);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.haveConnection();
        this.theConnection.setReadOnly(on != null);
        return null;
    }

    public final ijResult ElapsedTimeStatement() throws ParseException {
        Token on = null;
        this.jj_consume_token(34);
        switch (this.jj_nt.kind) {
            case 62: {
                on = this.jj_consume_token(62);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.elapsedTime = on != null;
        return null;
    }

    public final ijResult MaximumDisplayWidthStatement() throws ParseException {
        this.jj_consume_token(56);
        int maxWidth = this.intValue();
        JDBCDisplayUtil.setMaxDisplayWidth(maxWidth);
        return null;
    }

    public final int intValue() throws ParseException {
        Token t = this.jj_consume_token(134);
        return Integer.parseInt(t.image);
    }

    public final ijResult Bang() throws ParseException {
        Token cmd = null;
        this.jj_consume_token(22);
        cmd = this.jj_consume_token(135);
        ijVectorResult result = null;
        try {
            int c;
            Process p = Runtime.getRuntime().exec(this.stringValue(cmd.image));
            LocalizedInput in = new LocalizedInput(p.getInputStream());
            Vector<Object> v = new Vector<Object>();
            StringBuffer output = new StringBuffer();
            while ((c = in.read()) != -1) {
                output.append((char)c);
            }
            in.close();
            in = new LocalizedInput(p.getErrorStream());
            while ((c = in.read()) != -1) {
                output.append((char)c);
            }
            in.close();
            v.addElement(output);
            result = new ijVectorResult(v, null);
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                throw ijException.bangException(e);
            }
        }
        catch (IOException ioe) {
            throw ijException.bangException(ioe);
        }
        return result;
    }

    public final void StringList(Vector<Token> v) throws ParseException {
        this.StringItem(v);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 135: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block3;
                }
            }
            this.StringItem(v);
        }
    }

    public final void StringItem(Vector<Token> v) throws ParseException {
        Token s = this.jj_consume_token(135);
        v.addElement(s);
    }

    public final ijResult HelpStatement() throws ParseException {
        this.jj_consume_token(49);
        Vector<Object> v = new Vector<Object>();
        StringTokenizer st = new StringTokenizer(LocalizedResource.getMessage("IJ_HelpText", new Object[0]), "\n");
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        return new ijVectorResult(v, null);
    }

    public final String identifier() throws ParseException {
        Token t = this.jj_consume_token(131);
        return t.image.toUpperCase(Locale.ENGLISH);
    }

    public final QualifiedIdentifier qualifiedIdentifier() throws ParseException {
        String sn = null;
        String ln = null;
        ln = this.identifier();
        switch (this.jj_nt.kind) {
            case 123: {
                this.jj_consume_token(123);
                sn = this.identifier();
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        if (sn == null) {
            this.haveConnection();
            sn = this.currentConnEnv.getSession().getName();
        }
        return new QualifiedIdentifier(sn, ln);
    }

    public final String caIdentifier() throws ParseException, SQLException {
        Token t = null;
        String i = null;
        switch (this.jj_nt.kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                i = this.keyword();
                break;
            }
            case 131: {
                t = this.jj_consume_token(131);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.haveConnection();
        DatabaseMetaData dbmd = this.theConnection.getMetaData();
        String identifier = i;
        if (t != null) {
            identifier = t.image;
        }
        if (dbmd.storesLowerCaseIdentifiers()) {
            identifier = identifier.toLowerCase(Locale.ENGLISH);
        } else if (dbmd.storesUpperCaseIdentifiers()) {
            identifier = identifier.toUpperCase(Locale.ENGLISH);
        }
        return identifier;
    }

    public final int intLiteral() throws ParseException, SQLException {
        String sign = "";
        switch (this.jj_nt.kind) {
            case 129: 
            case 130: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        Token tok = this.jj_consume_token(134);
        String num = tok.image;
        if (sign.equals("-")) {
            num = sign.concat(num);
        }
        return Integer.parseInt(num);
    }

    public final Vector<String> staticMethodName() throws ParseException, SQLException {
        Vector<String> list = new Vector<String>();
        this.methodLeg(list);
        block3: while (true) {
            this.jj_consume_token(64);
            this.methodLeg(list);
            switch (this.jj_nt.kind) {
                case 64: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[43] = this.jj_gen;
        return list;
    }

    public final void methodLeg(Vector<String> list) throws ParseException, SQLException {
        Token id = this.jj_consume_token(131);
        list.addElement(id.image);
    }

    public final String[] staticMethodArgs() throws ParseException, SQLException {
        Vector<String> list = new Vector<String>();
        this.jj_consume_token(125);
        block0 : switch (this.jj_nt.kind) {
            case 135: {
                this.oneStaticArg(list);
                while (true) {
                    switch (this.jj_nt.kind) {
                        case 124: {
                            break;
                        }
                        default: {
                            this.jj_la1[44] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(124);
                    this.oneStaticArg(list);
                }
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        this.jj_consume_token(126);
        Object[] args = new String[list.size()];
        list.copyInto(args);
        return args;
    }

    public final void oneStaticArg(Vector<String> list) throws ParseException, SQLException {
        Token tok = this.jj_consume_token(135);
        list.addElement(this.stringValue(tok.image));
    }

    public final String sign() throws ParseException, SQLException {
        switch (this.jj_nt.kind) {
            case 130: {
                Token s = this.jj_consume_token(130);
                return s.image;
            }
            case 129: {
                Token s = this.jj_consume_token(129);
                return s.image;
            }
        }
        this.jj_la1[46] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult XA_DataSourceStatement() throws ParseException, SQLException {
        Token dbname = null;
        Token shut = null;
        String create = null;
        this.jj_consume_token(98);
        dbname = this.jj_consume_token(135);
        block0 : switch (this.jj_nt.kind) {
            case 87: 
            case 131: {
                switch (this.jj_nt.kind) {
                    case 87: {
                        shut = this.jj_consume_token(87);
                        break block0;
                    }
                    case 131: {
                        create = this.identifier();
                        break block0;
                    }
                }
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        this.xahelper.XADataSourceStatement(this, dbname, shut, create);
        return null;
    }

    public final ijResult XA_ConnectStatement() throws ParseException, SQLException {
        Token userT = null;
        Token passwordT = null;
        String n = null;
        this.jj_consume_token(99);
        switch (this.jj_nt.kind) {
            case 91: {
                this.jj_consume_token(91);
                userT = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 63: {
                this.jj_consume_token(63);
                passwordT = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                n = this.identifier();
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        this.xahelper.XAConnectStatement(this, userT, passwordT, n);
        return null;
    }

    public final ijResult XA_DisconnectStatement() throws ParseException, SQLException {
        String n = null;
        this.jj_consume_token(101);
        switch (this.jj_nt.kind) {
            case 131: {
                n = this.identifier();
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
            }
        }
        this.xahelper.XADisconnectStatement(this, n);
        return null;
    }

    public final ijResult XA_CommitStatement() throws ParseException, SQLException {
        Token onePhase = null;
        Token twoPhase = null;
        int xid = 0;
        this.jj_consume_token(100);
        switch (this.jj_nt.kind) {
            case 96: {
                onePhase = this.jj_consume_token(96);
                break;
            }
            case 97: {
                twoPhase = this.jj_consume_token(97);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        xid = this.intValue();
        this.xahelper.CommitStatement(this, onePhase, twoPhase, xid);
        return null;
    }

    public final ijResult XA_EndStatement() throws ParseException, SQLException {
        int flag = 0;
        int xid = 0;
        this.jj_consume_token(102);
        flag = this.xatmflag();
        xid = this.intValue();
        this.xahelper.EndStatement(this, flag, xid);
        return null;
    }

    public final ijResult XA_ForgetStatement() throws ParseException, SQLException {
        int xid = 0;
        this.jj_consume_token(105);
        xid = this.intValue();
        this.xahelper.ForgetStatement(this, xid);
        return null;
    }

    public final ijResult XA_GetConnectionStatement() throws ParseException, SQLException {
        String n = "XA";
        this.jj_consume_token(106);
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                n = this.identifier();
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        this.theConnection = this.xahelper.XAGetConnectionStatement(this, n);
        this.currentConnEnv.addSession(this.theConnection, n);
        return new ijConnectionResult(this.theConnection);
    }

    public final ijResult XA_PrepareStatement() throws ParseException, SQLException {
        int xid = 0;
        this.jj_consume_token(109);
        xid = this.intValue();
        this.xahelper.PrepareStatement(this, xid);
        return null;
    }

    public final ijResult XA_RecoverStatement() throws ParseException, SQLException {
        int flag = 0;
        this.jj_consume_token(110);
        flag = this.xatmflag();
        return this.xahelper.RecoverStatement(this, flag);
    }

    public final ijResult XA_RollbackStatement() throws ParseException, SQLException {
        int xid = 0;
        this.jj_consume_token(112);
        xid = this.intValue();
        this.xahelper.RollbackStatement(this, xid);
        return null;
    }

    public final ijResult XA_StartStatement() throws ParseException, SQLException {
        int flag = 0;
        int xid = 0;
        this.jj_consume_token(113);
        flag = this.xatmflag();
        xid = this.intValue();
        this.xahelper.StartStatement(this, flag, xid);
        return null;
    }

    public final int xatmflag() throws ParseException, SQLException {
        switch (this.jj_nt.kind) {
            case 103: {
                this.jj_consume_token(103);
                return 0x800000;
            }
            case 104: {
                this.jj_consume_token(104);
                return 0x20000000;
            }
            case 107: {
                this.jj_consume_token(107);
                return 0x200000;
            }
            case 108: {
                this.jj_consume_token(108);
                return 0;
            }
            case 111: {
                this.jj_consume_token(111);
                return 0x8000000;
            }
            case 114: {
                this.jj_consume_token(114);
                return 0x1000000;
            }
            case 115: {
                this.jj_consume_token(115);
                return 0x4000000;
            }
            case 116: {
                this.jj_consume_token(116);
                return 0x2000000;
            }
        }
        this.jj_la1[55] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult DataSourceStatement() throws ParseException, SQLException {
        Token dbname = null;
        Token protocol = null;
        Token userT = null;
        Token passwordT = null;
        String n = null;
        this.jj_consume_token(117);
        dbname = this.jj_consume_token(135);
        switch (this.jj_nt.kind) {
            case 70: {
                this.jj_consume_token(70);
                protocol = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 91: {
                this.jj_consume_token(91);
                userT = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 63: {
                this.jj_consume_token(63);
                passwordT = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                n = this.identifier();
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        this.theConnection = this.xahelper.DataSourceStatement(this, dbname, protocol, userT, passwordT, n);
        return this.addSession(this.theConnection, n);
    }

    public final ijResult CP_DataSourceStatement() throws ParseException, SQLException {
        Token dbname = null;
        Token protocol = null;
        this.jj_consume_token(118);
        dbname = this.jj_consume_token(135);
        switch (this.jj_nt.kind) {
            case 70: {
                this.jj_consume_token(70);
                protocol = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        this.xahelper.CPDataSourceStatement(this, dbname, protocol);
        return null;
    }

    public final ijResult CP_ConnectStatement() throws ParseException, SQLException {
        Token userT = null;
        Token passwordT = null;
        String n = null;
        this.jj_consume_token(119);
        switch (this.jj_nt.kind) {
            case 91: {
                this.jj_consume_token(91);
                userT = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 63: {
                this.jj_consume_token(63);
                passwordT = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                n = this.identifier();
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
        this.xahelper.CPConnectStatement(this, userT, passwordT, n);
        return null;
    }

    public final ijResult CP_GetConnectionStatement() throws ParseException, SQLException {
        String n = "Pooled";
        this.jj_consume_token(120);
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                n = this.identifier();
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
            }
        }
        this.theConnection = this.xahelper.CPGetConnectionStatement(this, n);
        this.currentConnEnv.addSession(this.theConnection, n);
        return new ijConnectionResult(this.theConnection);
    }

    public final ijResult CP_DisconnectStatement() throws ParseException, SQLException {
        String n = null;
        this.jj_consume_token(121);
        switch (this.jj_nt.kind) {
            case 131: {
                n = this.identifier();
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        this.xahelper.CPDisconnectStatement(this, n);
        return null;
    }

    public final void attributeList(Properties properties) throws ParseException {
        if (this.getToken((int)2).kind != 37) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.property(properties);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 124: {
                    break;
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(124);
            this.property(properties);
        }
    }

    public final void property(Properties properties) throws ParseException {
        String key = this.caseSensitiveIdentifierOrKeyword();
        this.jj_consume_token(37);
        String value = this.caseSensitiveIdentifierOrKeyword();
        properties.put(key, value);
    }

    public final String caseSensitiveIdentifierOrKeyword() throws ParseException {
        String value = null;
        switch (this.jj_nt.kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                value = this.keyword();
                return value;
            }
            case 131: {
                Token tok = this.jj_consume_token(131);
                return tok.image;
            }
        }
        this.jj_la1[67] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseSensitiveIdentifier() throws ParseException {
        Token tok = this.jj_consume_token(131);
        return tok.image;
    }

    public final String keyword() throws ParseException {
        Token tok;
        Object value = null;
        switch (this.jj_nt.kind) {
            case 14: {
                tok = this.jj_consume_token(14);
                break;
            }
            case 15: {
                tok = this.jj_consume_token(15);
                break;
            }
            case 16: {
                tok = this.jj_consume_token(16);
                break;
            }
            case 17: {
                tok = this.jj_consume_token(17);
                break;
            }
            case 18: {
                tok = this.jj_consume_token(18);
                break;
            }
            case 19: {
                tok = this.jj_consume_token(19);
                break;
            }
            case 20: {
                tok = this.jj_consume_token(20);
                break;
            }
            case 21: {
                tok = this.jj_consume_token(21);
                break;
            }
            case 22: {
                tok = this.jj_consume_token(22);
                break;
            }
            case 23: {
                tok = this.jj_consume_token(23);
                break;
            }
            case 24: {
                tok = this.jj_consume_token(24);
                break;
            }
            case 25: {
                tok = this.jj_consume_token(25);
                break;
            }
            case 26: {
                tok = this.jj_consume_token(26);
                break;
            }
            case 27: {
                tok = this.jj_consume_token(27);
                break;
            }
            case 28: {
                tok = this.jj_consume_token(28);
                break;
            }
            case 29: {
                tok = this.jj_consume_token(29);
                break;
            }
            case 30: {
                tok = this.jj_consume_token(30);
                break;
            }
            case 31: {
                tok = this.jj_consume_token(31);
                break;
            }
            case 32: {
                tok = this.jj_consume_token(32);
                break;
            }
            case 33: {
                tok = this.jj_consume_token(33);
                break;
            }
            case 34: {
                tok = this.jj_consume_token(34);
                break;
            }
            case 36: {
                tok = this.jj_consume_token(36);
                break;
            }
            case 38: {
                tok = this.jj_consume_token(38);
                break;
            }
            case 39: {
                tok = this.jj_consume_token(39);
                break;
            }
            case 40: {
                tok = this.jj_consume_token(40);
                break;
            }
            case 41: {
                tok = this.jj_consume_token(41);
                break;
            }
            case 42: {
                tok = this.jj_consume_token(42);
                break;
            }
            case 43: {
                tok = this.jj_consume_token(43);
                break;
            }
            case 45: {
                tok = this.jj_consume_token(45);
                break;
            }
            case 46: {
                tok = this.jj_consume_token(46);
                break;
            }
            case 47: {
                tok = this.jj_consume_token(47);
                break;
            }
            case 49: {
                tok = this.jj_consume_token(49);
                break;
            }
            case 50: {
                tok = this.jj_consume_token(50);
                break;
            }
            case 51: {
                tok = this.jj_consume_token(51);
                break;
            }
            case 52: {
                tok = this.jj_consume_token(52);
                break;
            }
            case 53: {
                tok = this.jj_consume_token(53);
                break;
            }
            case 54: {
                tok = this.jj_consume_token(54);
                break;
            }
            case 55: {
                tok = this.jj_consume_token(55);
                break;
            }
            case 56: {
                tok = this.jj_consume_token(56);
                break;
            }
            case 57: {
                tok = this.jj_consume_token(57);
                break;
            }
            case 58: {
                tok = this.jj_consume_token(58);
                break;
            }
            case 59: {
                tok = this.jj_consume_token(59);
                break;
            }
            case 60: {
                tok = this.jj_consume_token(60);
                break;
            }
            case 61: {
                tok = this.jj_consume_token(61);
                break;
            }
            case 62: {
                tok = this.jj_consume_token(62);
                break;
            }
            case 63: {
                tok = this.jj_consume_token(63);
                break;
            }
            case 64: {
                tok = this.jj_consume_token(64);
                break;
            }
            case 65: {
                tok = this.jj_consume_token(65);
                break;
            }
            case 66: {
                tok = this.jj_consume_token(66);
                break;
            }
            case 67: {
                tok = this.jj_consume_token(67);
                break;
            }
            case 68: {
                tok = this.jj_consume_token(68);
                break;
            }
            case 69: {
                tok = this.jj_consume_token(69);
                break;
            }
            case 70: {
                tok = this.jj_consume_token(70);
                break;
            }
            case 71: {
                tok = this.jj_consume_token(71);
                break;
            }
            case 72: {
                tok = this.jj_consume_token(72);
                break;
            }
            case 73: {
                tok = this.jj_consume_token(73);
                break;
            }
            case 74: {
                tok = this.jj_consume_token(74);
                break;
            }
            case 75: {
                tok = this.jj_consume_token(75);
                break;
            }
            case 77: {
                tok = this.jj_consume_token(77);
                break;
            }
            case 78: {
                tok = this.jj_consume_token(78);
                break;
            }
            case 79: {
                tok = this.jj_consume_token(79);
                break;
            }
            case 81: {
                tok = this.jj_consume_token(81);
                break;
            }
            case 82: {
                tok = this.jj_consume_token(82);
                break;
            }
            case 83: {
                tok = this.jj_consume_token(83);
                break;
            }
            case 84: {
                tok = this.jj_consume_token(84);
                break;
            }
            case 86: {
                tok = this.jj_consume_token(86);
                break;
            }
            case 87: {
                tok = this.jj_consume_token(87);
                break;
            }
            case 88: {
                tok = this.jj_consume_token(88);
                break;
            }
            case 89: {
                tok = this.jj_consume_token(89);
                break;
            }
            case 90: {
                tok = this.jj_consume_token(90);
                break;
            }
            case 91: {
                tok = this.jj_consume_token(91);
                break;
            }
            case 92: {
                tok = this.jj_consume_token(92);
                break;
            }
            case 93: {
                tok = this.jj_consume_token(93);
                break;
            }
            case 94: {
                tok = this.jj_consume_token(94);
                break;
            }
            case 95: {
                tok = this.jj_consume_token(95);
                break;
            }
            case 96: {
                tok = this.jj_consume_token(96);
                break;
            }
            case 97: {
                tok = this.jj_consume_token(97);
                break;
            }
            case 98: {
                tok = this.jj_consume_token(98);
                break;
            }
            case 99: {
                tok = this.jj_consume_token(99);
                break;
            }
            case 100: {
                tok = this.jj_consume_token(100);
                break;
            }
            case 101: {
                tok = this.jj_consume_token(101);
                break;
            }
            case 102: {
                tok = this.jj_consume_token(102);
                break;
            }
            case 103: {
                tok = this.jj_consume_token(103);
                break;
            }
            case 104: {
                tok = this.jj_consume_token(104);
                break;
            }
            case 105: {
                tok = this.jj_consume_token(105);
                break;
            }
            case 106: {
                tok = this.jj_consume_token(106);
                break;
            }
            case 107: {
                tok = this.jj_consume_token(107);
                break;
            }
            case 108: {
                tok = this.jj_consume_token(108);
                break;
            }
            case 109: {
                tok = this.jj_consume_token(109);
                break;
            }
            case 110: {
                tok = this.jj_consume_token(110);
                break;
            }
            case 111: {
                tok = this.jj_consume_token(111);
                break;
            }
            case 112: {
                tok = this.jj_consume_token(112);
                break;
            }
            case 113: {
                tok = this.jj_consume_token(113);
                break;
            }
            case 114: {
                tok = this.jj_consume_token(114);
                break;
            }
            case 115: {
                tok = this.jj_consume_token(115);
                break;
            }
            case 116: {
                tok = this.jj_consume_token(116);
                break;
            }
            case 117: {
                tok = this.jj_consume_token(117);
                break;
            }
            case 118: {
                tok = this.jj_consume_token(118);
                break;
            }
            case 119: {
                tok = this.jj_consume_token(119);
                break;
            }
            case 120: {
                tok = this.jj_consume_token(120);
                break;
            }
            case 121: {
                tok = this.jj_consume_token(121);
                break;
            }
            case 122: {
                tok = this.jj_consume_token(122);
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return tok.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private final boolean jj_3R_100() {
        return this.jj_scan_token(105);
    }

    private final boolean jj_3R_67() {
        return this.jj_scan_token(26);
    }

    private final boolean jj_3R_77() {
        return this.jj_scan_token(49);
    }

    private final boolean jj_3R_105() {
        return this.jj_scan_token(117);
    }

    private final boolean jj_3R_66() {
        return this.jj_scan_token(25);
    }

    private final boolean jj_3R_78() {
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_99() {
        return this.jj_scan_token(102);
    }

    private final boolean jj_3R_65() {
        return this.jj_scan_token(24);
    }

    private final boolean jj_3R_117() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(14)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(15)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(16)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(17)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(18)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(19)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(20)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(21)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(22)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(23)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(24)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(25)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(26)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(27)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(28)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(29)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(30)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(31)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(32)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(33)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(34)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(36)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(38)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(39)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(40)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(41)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(42)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(43)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(45)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(46)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(47)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(49)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(50)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(51)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(52)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(53)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(54)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(55)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(56)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(57)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(58)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(59)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(60)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(61)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(62)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(63)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(64)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(65)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(66)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(67)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(68)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(69)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(70)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(71)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(72)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(73)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(74)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(75)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(77)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(78)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(79)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(81)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(82)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(83)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(84)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(86)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(87)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(88)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(89)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(90)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(91)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(92)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(93)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(94)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(95)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(96)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(97)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(98)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(99)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(100)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(101)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(102)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(103)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(104)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(105)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(106)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(107)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(108)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(109)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(110)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(111)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(112)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(113)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(114)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(115)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(116)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(117)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(118)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(119)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(120)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(121)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(122)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_83() {
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_70() {
        return this.jj_scan_token(33);
    }

    private final boolean jj_3R_96() {
        return this.jj_scan_token(100);
    }

    private final boolean jj_3R_76() {
        return this.jj_scan_token(46);
    }

    private final boolean jj_3R_68() {
        return this.jj_scan_token(31);
    }

    private final boolean jj_3R_85() {
        return this.jj_scan_token(66);
    }

    private final boolean jj_3R_116() {
        return this.jj_scan_token(131);
    }

    private final boolean jj_3R_61() {
        return this.jj_scan_token(21);
    }

    private final boolean jj_3R_97() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_86() {
        return this.jj_scan_token(70);
    }

    private final boolean jj_3R_115() {
        return this.jj_3R_117();
    }

    private final boolean jj_3R_114() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_115()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_116()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_75() {
        return this.jj_scan_token(45);
    }

    private final boolean jj_3R_79() {
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_111() {
        return this.jj_3R_114();
    }

    private final boolean jj_3R_63() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_110() {
        return false;
    }

    private final boolean jj_3R_56() {
        return this.jj_3R_109();
    }

    private final boolean jj_3R_95() {
        return this.jj_scan_token(99);
    }

    private final boolean jj_3R_55() {
        return this.jj_3R_108();
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_107();
    }

    private final boolean jj_3R_90() {
        return this.jj_scan_token(78);
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_106();
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_105();
    }

    private final boolean jj_3R_60() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_104();
    }

    private final boolean jj_3R_50() {
        return this.jj_3R_103();
    }

    private final boolean jj_3R_92() {
        return this.jj_scan_token(86);
    }

    private final boolean jj_3R_49() {
        return this.jj_3R_102();
    }

    private final boolean jj_3R_48() {
        return this.jj_3R_101();
    }

    private final boolean jj_3R_57() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 37;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_110()) {
            return true;
        }
        return this.jj_3R_111();
    }

    private final boolean jj_3R_104() {
        return this.jj_scan_token(113);
    }

    private final boolean jj_3R_47() {
        return this.jj_3R_100();
    }

    private final boolean jj_3R_46() {
        return this.jj_3R_99();
    }

    private final boolean jj_3R_45() {
        return this.jj_3R_98();
    }

    private final boolean jj_3R_44() {
        return this.jj_3R_97();
    }

    private final boolean jj_3R_43() {
        return this.jj_3R_96();
    }

    private final boolean jj_3R_42() {
        return this.jj_3R_95();
    }

    private final boolean jj_3R_41() {
        return this.jj_3R_94();
    }

    private final boolean jj_3R_40() {
        return this.jj_3R_93();
    }

    private final boolean jj_3R_39() {
        return this.jj_3R_92();
    }

    private final boolean jj_3R_38() {
        return this.jj_3R_91();
    }

    private final boolean jj_3R_37() {
        return this.jj_3R_90();
    }

    private final boolean jj_3R_82() {
        return this.jj_scan_token(58);
    }

    private final boolean jj_3R_36() {
        return this.jj_3R_89();
    }

    private final boolean jj_3R_35() {
        return this.jj_3R_88();
    }

    private final boolean jj_3_2() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_34() {
        return this.jj_3R_87();
    }

    private final boolean jj_3R_33() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_32() {
        return this.jj_3R_85();
    }

    private final boolean jj_3R_109() {
        return this.jj_scan_token(121);
    }

    private final boolean jj_3R_89() {
        return this.jj_scan_token(74);
    }

    private final boolean jj_3R_84() {
        return this.jj_scan_token(65);
    }

    private final boolean jj_3R_31() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_81() {
        return this.jj_scan_token(56);
    }

    private final boolean jj_3R_30() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_94() {
        return this.jj_scan_token(98);
    }

    private final boolean jj_3R_29() {
        return this.jj_3R_82();
    }

    private final boolean jj_3R_103() {
        return this.jj_scan_token(112);
    }

    private final boolean jj_3R_28() {
        return this.jj_3R_81();
    }

    private final boolean jj_3R_27() {
        return this.jj_3R_80();
    }

    private final boolean jj_3R_26() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_24() {
        return this.jj_3R_77();
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_76();
    }

    private final boolean jj_3R_22() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_91() {
        return this.jj_scan_token(84);
    }

    private final boolean jj_3R_25() {
        return this.jj_3R_78();
    }

    private final boolean jj_3R_21() {
        return this.jj_3R_74();
    }

    private final boolean jj_3R_20() {
        return this.jj_3R_73();
    }

    private final boolean jj_3R_73() {
        return this.jj_scan_token(41);
    }

    private final boolean jj_3R_19() {
        return this.jj_3R_72();
    }

    private final boolean jj_3R_18() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_17() {
        return this.jj_3R_70();
    }

    private final boolean jj_3R_16() {
        return this.jj_3R_69();
    }

    private final boolean jj_3R_15() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_113() {
        return this.jj_scan_token(71);
    }

    private final boolean jj_3R_14() {
        return this.jj_3R_67();
    }

    private final boolean jj_3R_13() {
        return this.jj_3R_66();
    }

    private final boolean jj_3R_12() {
        return this.jj_3R_65();
    }

    private final boolean jj_3R_11() {
        return this.jj_3R_64();
    }

    private final boolean jj_3R_112() {
        return this.jj_scan_token(39);
    }

    private final boolean jj_3R_108() {
        return this.jj_scan_token(120);
    }

    private final boolean jj_3R_102() {
        return this.jj_scan_token(110);
    }

    private final boolean jj_3R_74() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_112()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_113()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_10() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_9() {
        return this.jj_3R_62();
    }

    private final boolean jj_3R_8() {
        return this.jj_3R_61();
    }

    private final boolean jj_3R_7() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_6() {
        return this.jj_3R_59();
    }

    private final boolean jj_3R_71() {
        return this.jj_scan_token(34);
    }

    private final boolean jj_3R_64() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_93() {
        return this.jj_scan_token(94);
    }

    private final boolean jj_3R_5() {
        return this.jj_3R_58();
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 77 && this.getToken((int)3).kind != 79 && this.getToken((int)3).kind != 80;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_7()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_8()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_9()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_10()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_11()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_12()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_13()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_14()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_15()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_16()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_17()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_18()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_19()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_20()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_21()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_22()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_23()) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_3R_24()) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_25()) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_3R_26()) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_3R_27()) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_3R_28()) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_3R_29()) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_3R_30()) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_3R_31()) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_3R_32()) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_3R_33()) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_3R_34()) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_3R_35()) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_3R_36()) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_3R_37()) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_3R_38()) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_3R_39()) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_3R_40()) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_3R_41()) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_3R_42()) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_3R_43()) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_3R_44()) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_3R_45()) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_3R_46()) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_3R_47()) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_3R_48()) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_3R_49()) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_3R_50()) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_3R_51()) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_3R_52()) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_3R_53()) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_3R_54()) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_3R_55()) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_3R_56()) {
                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_101() {
        return this.jj_scan_token(109);
    }

    private final boolean jj_3R_107() {
        return this.jj_scan_token(119);
    }

    private final boolean jj_3R_88() {
        return this.jj_scan_token(73);
    }

    private final boolean jj_3R_87() {
        return this.jj_scan_token(72);
    }

    private final boolean jj_3R_69() {
        return this.jj_scan_token(32);
    }

    private final boolean jj_3R_62() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_72() {
        return this.jj_scan_token(38);
    }

    private final boolean jj_3R_59() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_98() {
        return this.jj_scan_token(106);
    }

    private final boolean jj_3R_106() {
        return this.jj_scan_token(118);
    }

    private final boolean jj_3R_80() {
        return this.jj_scan_token(55);
    }

    private final boolean jj_3R_58() {
        return this.jj_scan_token(77);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{-2014789632, 262144, 0, 0, 0, 0, 0, 0x100000, 262144, 0, -16384, 262144, 65536, 0, 0, 0, 0, 0, 0, 0x10010000, 0, 0, 0x20020000, 0x20020000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262144, 0, 0, 262144, 0, 0, 0, 0, 262144, 0, 0, 0, 262144, 262144, 0, 0, -16384, -16384};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{365126343, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, -69673, 0, 0, 262144, 0, 264192, 264192, 262144, 262144, 528392, 0, 0, 0, 0, 128, 0, 0, 0, 0x100000, 0x8008000, 0, 0, 0, 0, 0, 0x60000000, 0x60000000, 0x60000000, 0x60000000, 0, 0, -69673, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, -69673, -69673};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{1079003078, 0, 0, 32768, 64, 0x8000000, 0, 0, 0, 1, -2166785, 0, 0x26000000, 0, 1, 0, 0, 0, 0, 639766544, 0, 0, 0, 0, 128, 8, 262144, Integer.MIN_VALUE, 524288, 0, 0, 0, 0x10000000, 0x1000008, 2048, 0, 0, 0, 0, 0, 0, -2166785, 0, 1, 0, 0, 0, 0x800000, 0x800000, 0x8000000, 0, 0, 0, 0, 0, 0, 64, 0x8000000, 0, 0, 64, 0x8000000, 0, 0, 0, 0, 0, -2166785, -2166785};
    }

    private static void jj_la1_3() {
        jj_la1_3 = new int[]{65234556, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x7FFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0x7FFFFFF, 0, 0, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 1874304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0x7FFFFFF, 0x7FFFFFF};
    }

    private static void jj_la1_4() {
        jj_la1_4 = new int[]{0, 0, 136, 136, 0, 0, 0, 0, 0, 0, 136, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 8, 0, 0, 0, 0, 136, 136, 0, 136, 0, 0, 0, 0, 0, 128, 0, 8, 6, 0, 0, 128, 6, 8, 8, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0};
    }

    public ij(CharStream stream) {
        int i;
        this.token_source = new ijTokenManager(stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 69; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 69; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ij(ijTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 69; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ijTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 69; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration<int[]> e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[136];
        for (i = 0; i < 136; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 69; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 136; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, ijConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ij.jj_la1_0();
        ij.jj_la1_1();
        ij.jj_la1_2();
        ij.jj_la1_3();
        ij.jj_la1_4();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

