/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.DerbyDistribution;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;

public class VersionedNetworkServerTestSetup
extends BaseTestSetup {
    private static final DerbyVersion SUPPORTS_NO_SECMAN_ARG = new DerbyVersion(10, 3, 1, 4);
    private static final DerbyVersion NO_BROKEN_SHUTDOWN = new DerbyVersion(10, 4, 0, 0);
    private final DerbyDistribution dist;
    private final String appendToClasspath;
    private SpawnedProcess spawned;
    private NetworkServerControl networkServerControl;

    public VersionedNetworkServerTestSetup(Test test, DerbyDistribution dist, String appendToClasspath) {
        super(test);
        this.dist = dist;
        this.appendToClasspath = appendToClasspath;
    }

    public void setUp() {
        int port = TestConfiguration.getCurrent().getPort();
        try {
            this.networkServerControl = NetworkServerTestSetup.getNetworkServerControl(port);
        }
        catch (Exception e) {
            VersionedNetworkServerTestSetup.fail((String)e.getMessage());
        }
        VersionedNetworkServerTestSetup.println("checking for running server on port " + port);
        if (this.ping(false, null)) {
            VersionedNetworkServerTestSetup.fail((String)("a server is already running at port " + port));
        }
        String classpath = this.dist.getProductionClasspath() + (this.appendToClasspath == null ? "" : File.pathSeparator + this.appendToClasspath);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("org.apache.derby.drda.NetworkServerControl");
        cmd.add("start");
        cmd.add("-p");
        cmd.add(Integer.toString(port));
        if (this.dist.getVersion().compareTo(SUPPORTS_NO_SECMAN_ARG) >= 0) {
            cmd.add("-noSecurityManager");
        }
        Process proc = null;
        try {
            proc = BaseTestCase.execJavaCmd(null, classpath, cmd.toArray(new String[cmd.size()]), null);
        }
        catch (IOException ioe) {
            VersionedNetworkServerTestSetup.fail((String)("failed to start server: " + ioe.getMessage()));
        }
        this.spawned = new SpawnedProcess(proc, "NetworkServerControl");
        boolean pingOk = this.ping(true, proc);
        VersionedNetworkServerTestSetup.assertTrue((String)this.spawned.getFailMessage("server failed to come up"), (boolean)pingOk);
        VersionedNetworkServerTestSetup.println("--- Server " + this.dist.getVersion() + " up");
    }

    public void tearDown() {
        String errorMsg = null;
        boolean sawError = false;
        if (this.dist.getVersion().compareTo(NO_BROKEN_SHUTDOWN) < 0) {
            errorMsg = this.shutDownInSeparateProcess();
            sawError = errorMsg != null;
        } else {
            boolean pingOk = this.ping(true, this.spawned.getProcess());
            if (pingOk) {
                try {
                    this.networkServerControl.shutdown();
                }
                catch (Exception e) {
                    String msg = this.spawned.getFailMessage("shutdown failed");
                    errorMsg = " (failed to shut down server (" + this.dist.getVersion().toString() + "): " + e.getMessage() + " :: " + msg + ")";
                    sawError = true;
                }
            }
        }
        try {
            this.spawned.complete(5000L);
        }
        catch (Exception e) {
            errorMsg = "process didn't die: " + e.getMessage() + (sawError ? errorMsg : "");
            sawError = true;
        }
        this.networkServerControl = null;
        this.spawned = null;
        try {
            BaseTestCase.assertDirectoryDeleted(new File("wombat"));
        }
        catch (AssertionError ae) {
            if (sawError) {
                errorMsg = errorMsg + " :: " + ((Throwable)((Object)ae)).getMessage();
            }
            throw ae;
        }
        if (sawError) {
            VersionedNetworkServerTestSetup.fail((String)errorMsg);
        }
    }

    private String shutDownInSeparateProcess() {
        Process proc;
        int port = TestConfiguration.getCurrent().getPort();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("org.apache.derby.drda.NetworkServerControl");
        cmd.add("shutdown");
        cmd.add("-p");
        cmd.add(Integer.toString(port));
        if (this.dist.getVersion().compareTo(SUPPORTS_NO_SECMAN_ARG) >= 0) {
            cmd.add("-noSecurityManager");
        }
        try {
            proc = BaseTestCase.execJavaCmd(null, this.dist.getProductionClasspath(), cmd.toArray(new String[cmd.size()]), null);
        }
        catch (IOException ioe) {
            return "shutdown process failed to start: " + ioe.getMessage();
        }
        SpawnedProcess spawnedShutdown = new SpawnedProcess(proc, "shutdown process");
        int exitCode = -1;
        try {
            exitCode = spawnedShutdown.complete(10000L);
        }
        catch (IOException ioe) {
            VersionedNetworkServerTestSetup.fail((String)spawnedShutdown.getFailMessage("shutdown process failed"));
        }
        if (exitCode == 0) {
            return null;
        }
        return spawnedShutdown.getFailMessage("abnormal process exit");
    }

    private boolean ping(boolean exepectServerUp, Process proc) {
        boolean pingOk = false;
        try {
            pingOk = NetworkServerTestSetup.pingForServerUp(this.networkServerControl, proc, exepectServerUp);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return pingOk;
    }

    private static void println(String msg) {
        BaseTestCase.println(msg);
    }
}

