/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.transaction;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.transaction.TransactionListener;

public final class TransactionControl {
    public static final int UNSPECIFIED_ISOLATION_LEVEL = 0;
    public static final int READ_UNCOMMITTED_ISOLATION_LEVEL = 1;
    public static final int READ_COMMITTED_ISOLATION_LEVEL = 2;
    public static final int REPEATABLE_READ_ISOLATION_LEVEL = 3;
    public static final int SERIALIZABLE_ISOLATION_LEVEL = 4;
    private static final int[] CS_TO_JDBC_ISOLATION_LEVEL_MAP = new int[]{0, 1, 2, 4, 8};
    private static final String[][] CS_TO_SQL_ISOLATION_MAP = new String[][]{{"  "}, {"UR", "DIRTY READ", "READ UNCOMMITTED"}, {"CS", "CURSOR STABILITY", "READ COMMITTED"}, {"RS"}, {"RR", "REPEATABLE READ", "SERIALIZABLE"}};
    private final ArrayList<TransactionListener> listeners = new ArrayList();

    public static int jdbcIsolationLevel(int derbyIsolationLevel) {
        return CS_TO_JDBC_ISOLATION_LEVEL_MAP[derbyIsolationLevel];
    }

    public static String[] isolationTextNames(int derbyIsolationLevel) {
        return ArrayUtil.copy(CS_TO_SQL_ISOLATION_MAP[derbyIsolationLevel]);
    }

    public static int isolationMapCount() {
        return CS_TO_SQL_ISOLATION_MAP.length;
    }

    public void addListener(TransactionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TransactionListener listener) {
        this.listeners.remove(listener);
    }

    public void preCommitNotify() throws StandardException {
        if (this.listeners.isEmpty()) {
            return;
        }
        Iterator<TransactionListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            TransactionListener listener = i.next();
            try {
                if (!listener.preCommit()) continue;
                i.remove();
            }
            catch (StandardException se) {
                if (se.getSeverity() < 30000) {
                    throw StandardException.newException("40XT1", se, new Object[0]);
                }
                throw se;
            }
        }
    }

    public void preRollbackNotify() throws StandardException {
        if (this.listeners.isEmpty()) {
            return;
        }
        Iterator<TransactionListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            TransactionListener listener = i.next();
            try {
                listener.preRollback();
                i.remove();
            }
            catch (StandardException se) {
                if (se.getSeverity() < 30000) {
                    // empty if block
                }
                throw se;
            }
        }
    }
}

