/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.sanity.SanityManager;

class WindowResultSet
extends NoPutResultSetImpl {
    private GeneratedMethod restriction = null;
    public NoPutResultSet source = null;
    public long restrictionTime;
    private FormatableBitSet referencedColumns;
    private ExecRow allocatedRow;
    private long rownumber;

    WindowResultSet(Activation activation, NoPutResultSet source, int rowAllocator, int resultSetNumber, int erdNumber, GeneratedMethod restriction, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        SanityManager.ASSERT(activation != null, "activation expected to be non-null");
        SanityManager.ASSERT(resultSetNumber >= 0, "resultSetNumber expected to be >= 0");
        this.restriction = restriction;
        this.source = source;
        this.rownumber = 0L;
        ExecPreparedStatement ps = activation.getPreparedStatement();
        this.allocatedRow = ((ExecRowBuilder)ps.getSavedObject(rowAllocator)).build(activation.getExecutionFactory());
        if (erdNumber != -1) {
            this.referencedColumns = (FormatableBitSet)ps.getSavedObject(erdNumber);
        }
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        SanityManager.ASSERT(!this.isOpen, "WindowResultSet already open");
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        this.rownumber = 0L;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        SanityManager.ASSERT(this.isOpen, "WindowResultSet already open");
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        this.rownumber = 0L;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow sourceRow = null;
        ExecRow retval = null;
        boolean restrict = false;
        long beginRT = 0L;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        ExecRow tmpRow = null;
        do {
            if ((sourceRow = this.source.getNextRowCore()) != null) {
                ++this.rownumber;
                tmpRow = this.getAllocatedRow();
                this.populateFromSourceRow(sourceRow, tmpRow);
                this.setCurrentRow(tmpRow);
                DataValueDescriptor restrictBoolean = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
                this.restrictionTime += this.getElapsedMillis(beginRT);
                boolean bl = restrict = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
                if (!restrict) {
                    ++this.rowsFiltered;
                    this.clearCurrentRow();
                }
                ++this.rowsSeen;
                retval = this.currentRow;
                continue;
            }
            this.clearCurrentRow();
            retval = null;
        } while (sourceRow != null && !restrict);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return retval;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of WindowResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void populateFromSourceRow(ExecRow srcrow, ExecRow destrow) throws StandardException {
        int srcindex = 1;
        try {
            DataValueDescriptor[] columns = destrow.getRowArray();
            for (int index = 0; index < columns.length; ++index) {
                if (this.referencedColumns != null && !this.referencedColumns.get(index)) {
                    columns[index].setValue(this.rownumber);
                    continue;
                }
                destrow.setColumn(index + 1, srcrow.getColumn(srcindex));
                ++srcindex;
            }
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }

    private ExecRow getAllocatedRow() throws StandardException {
        return this.allocatedRow;
    }
}

