// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
suite("test_index_rqg_bug2", "test_index_rqg_bug2"){
    def table1 = "test_index_rqg_bug2"

    sql "drop table if exists ${table1}"

    sql """
    CREATE TABLE ${table1} (
        col_date_undef_signed_not_null_index_inverted DATE NOT NULL,
        col_bigint_undef_signed_not_null_index_inverted BIGINT NOT NULL,
        col_bigint_undef_signed_not_null BIGINT NOT NULL,
        col_int_undef_signed INT NULL,
        col_int_undef_signed_index_inverted INT NULL,
        col_int_undef_signed_not_null INT NOT NULL,
        col_int_undef_signed_not_null_index_inverted INT NOT NULL,
        col_bigint_undef_signed BIGINT NULL,
        col_bigint_undef_signed_index_inverted BIGINT NULL,
        col_date_undef_signed DATE NULL,
        col_date_undef_signed_index_inverted DATE NULL,
        col_date_undef_signed_not_null DATE NOT NULL,
        col_varchar_10__undef_signed VARCHAR(10) NULL,
        col_varchar_10__undef_signed_index_inverted VARCHAR(10) NULL,
        col_varchar_10__undef_signed_not_null VARCHAR(10) NOT NULL,
        col_varchar_10__undef_signed_not_null_index_inverted VARCHAR(10) NOT NULL,
        col_varchar_1024__undef_signed VARCHAR(1024) NULL,
        col_varchar_1024__undef_signed_index_inverted VARCHAR(1024) NULL,
        col_varchar_1024__undef_signed_not_null VARCHAR(1024) NOT NULL,
        col_varchar_1024__undef_signed_not_null_index_inverted VARCHAR(1024) NOT NULL,
        col_array_bigint__undef_signed ARRAY<BIGINT> NULL,
        col_array_bigint__undef_signed_index_inverted ARRAY<BIGINT> NULL,
        col_array_bigint__undef_signed_not_null ARRAY<BIGINT> NOT NULL,
        col_array_bigint__undef_signed_not_null_index_inverted ARRAY<BIGINT> NOT NULL,
        col_array_varchar_64___undef_signed ARRAY<VARCHAR(64)> NULL,
        col_array_varchar_64___undef_signed_index_inverted ARRAY<VARCHAR(64)> NULL,
        col_array_varchar_64___undef_signed_not_null ARRAY<VARCHAR(64)> NOT NULL,
        col_array_varchar_64___undef_signed_not_null_index_inverted ARRAY<VARCHAR(64)> NOT NULL,
        col_array_date__undef_signed ARRAY<DATE> NULL,
        col_array_date__undef_signed_index_inverted ARRAY<DATE> NULL,
        col_array_date__undef_signed_not_null ARRAY<DATE> NOT NULL,
        col_array_date__undef_signed_not_null_index_inverted ARRAY<DATE> NOT NULL,
        pk INT,
        INDEX col_int_undef_signed_index_inverted_idx (`col_int_undef_signed_index_inverted`) USING INVERTED,
        INDEX col_int_undef_signed_not_null_index_inverted_idx (`col_int_undef_signed_not_null_index_inverted`) USING INVERTED,
        INDEX col_bigint_undef_signed_index_inverted_idx (`col_bigint_undef_signed_index_inverted`) USING INVERTED,
        INDEX col_bigint_undef_signed_not_null_index_inverted_idx (`col_bigint_undef_signed_not_null_index_inverted`) USING INVERTED,
        INDEX col_date_undef_signed_index_inverted_idx (`col_date_undef_signed_index_inverted`) USING INVERTED,
        INDEX col_date_undef_signed_not_null_index_inverted_idx (`col_date_undef_signed_not_null_index_inverted`) USING INVERTED,
        INDEX col_varchar_10__undef_signed_index_inverted_idx (`col_varchar_10__undef_signed_index_inverted`) USING INVERTED,
        INDEX col_varchar_10__undef_signed_not_null_index_inverted_idx (`col_varchar_10__undef_signed_not_null_index_inverted`) USING INVERTED,
        INDEX col_varchar_1024__undef_signed_index_inverted_idx (`col_varchar_1024__undef_signed_index_inverted`) USING INVERTED,
        INDEX col_varchar_1024__undef_signed_not_null_index_inverted_idx (`col_varchar_1024__undef_signed_not_null_index_inverted`) USING INVERTED
    ) ENGINE=olap
    UNIQUE KEY(col_date_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null)
    PARTITION BY RANGE(col_date_undef_signed_not_null_index_inverted) (
        FROM ('2023-01-01') TO ('2035-01-01') INTERVAL 1 YEAR
    )
    DISTRIBUTED BY HASH(col_bigint_undef_signed_not_null)
    PROPERTIES("enable_unique_key_merge_on_write" = "true", "replication_num" = "1");
    """

    sql """
    INSERT INTO ${table1}(pk,col_int_undef_signed,col_int_undef_signed_index_inverted,col_int_undef_signed_not_null,col_int_undef_signed_not_null_index_inverted,col_bigint_undef_signed,col_bigint_undef_signed_index_inverted,col_bigint_undef_signed_not_null,col_bigint_undef_signed_not_null_index_inverted,col_date_undef_signed,col_date_undef_signed_index_inverted,col_date_undef_signed_not_null,col_date_undef_signed_not_null_index_inverted,col_varchar_10__undef_signed,col_varchar_10__undef_signed_index_inverted,col_varchar_10__undef_signed_not_null,col_varchar_10__undef_signed_not_null_index_inverted,col_varchar_1024__undef_signed,col_varchar_1024__undef_signed_index_inverted,col_varchar_1024__undef_signed_not_null,col_varchar_1024__undef_signed_not_null_index_inverted,col_array_bigint__undef_signed,col_array_bigint__undef_signed_index_inverted,col_array_bigint__undef_signed_not_null,col_array_bigint__undef_signed_not_null_index_inverted,col_array_varchar_64___undef_signed,col_array_varchar_64___undef_signed_index_inverted,col_array_varchar_64___undef_signed_not_null,col_array_varchar_64___undef_signed_not_null_index_inverted,col_array_date__undef_signed,col_array_date__undef_signed_index_inverted,col_array_date__undef_signed_not_null,col_array_date__undef_signed_not_null_index_inverted) values (0,0,3,9,0,4421173,-8231206,-7461,2743,'2023-12-19','2023-12-15','2024-01-08','2025-06-18','e','h','x','p',null,null,'s','g',[1005281, 5740, 15054, null],[-5954, -19854, null, null, 3273993, -743, 337700, null, -1752691, 23217, 3506706],[null, null, -5265, null, 860851, -29957, null, -9710, 10115, -3146277, 11735, null, null, 18080, 7566486, null, -6484648, null, -4857664, 15816, 9875, -2686449, -941314, 8627, null, -7359, -4659, 28539, -16240, null, 17323, -2496932, 2292142, null, 11991, -8504, -9360, -8096795, 14727, null, null, 3306678, 14025, null, -6519359, 5625825, 6130567, null, null, null, null, null, 17792, null, -7991400, null, null, 22846, -28743],[-12355, -4008, 7917948, -2452821, null, 16207, 28195],['i', 'x', 'd', 't', 'e'],['l', null, 'l'],['m', 'w', null, 'd', 'y', 'f', 'c', 'q', 't', 'q'],[null, 'v', null, 'b', 'a', 'c', 'v', 'o', 'w', 'r', 'k'],["2025-02-18"],["2024-02-18", null, "2023-12-11", "2025-06-18", "2023-12-15", null, "2026-02-18", "2026-02-18", "2023-12-17"],["2024-01-17", "2023-12-10", "2023-12-09", "2024-01-09", "2026-02-18"],["2023-12-13", null, "2023-12-13"]),(1,2,2,3,3,-8059,null,5394,-1559484,'2023-12-15','2024-01-08','2025-06-18','2023-12-10','p','i','n','a','c','j','n','r',[null, 3283380, 3627449, -30527, -2736105, -10860, null],[null, 2459969, null, null, -3092713, 4381894, null, 1817602, null, 1706544, 16985],[null, 3991, -3206489],[-3022450, 1639, -5855269, null, null, -3561, -2618, 21678, 22004, 6803800, -357540, -2566523, -19982, 7530447, -1828804, 14471, null, null, -613238, 8073, -27918, null, null, 6211343, 18433, null, 30493, null, 8284, 1765944, 2897396, 15644, -3006094, null, 19552, null, 4895858, 15398, null, null, -8101195, 5945, null, -2924303],['z', null, 'q', 'd', null, null],['m', 'w', 'i', 'p', null, 'y', 'h', null, 'e', 'l', 'c', 'y', null, null, null, 's', 'i', 'g', 'l', 'b', 'v', 'c', null, 'd', 'a', 'j', 'f', 'h', 't', 'f', 'l'],['m', 'm', 'c', null, 's', 'z', null],['o', 'g', 'v', 'o', null, 'p', 'a', null, 's', null, 'k', null, 'i', 'b', 't', null, 's', 'm', 't', 'k', null, 'v', 'v', 'l', 'p', 'w', 'h', 'z'],["2024-01-17", "2025-06-18", "2024-01-19", "2024-01-09", "2023-12-18", "2024-01-08", "2023-12-18", "2025-02-18", "2025-06-18", "2025-06-18", "2026-01-18", "2024-01-31", "2024-01-08", "2024-02-18", "2024-02-18", "2023-12-09", "2023-12-16", null, null, "2024-02-18", "2024-01-17", "2027-01-16", "2024-01-09", null, null, "2025-06-18", "2024-02-18", "2023-12-20", "2025-06-18", "2026-02-18", "2024-01-19", "2027-01-16", "2024-01-17", "2024-02-18", "2025-06-18", null, "2027-01-09", "2024-02-18", "2023-12-13", "2025-02-17", "2024-01-09", "2023-12-18"],["2023-12-10", "2027-01-16", "2023-12-18", "2025-06-18", "2023-12-15", "2024-02-18", null, "2023-12-17", "2023-12-12", "2024-02-18", "2023-12-12", "2026-02-18", "2025-06-18", "2027-01-16"],["2023-12-19", null, "2023-12-14", "2023-12-10", "2023-12-11", "2024-01-17", "2024-01-17", "2023-12-12"],["2026-02-18", "2023-12-20", "2025-02-18", "2023-12-09", "2023-12-11", "2024-01-31", "2024-01-31", "2023-12-13", "2027-01-09", "2025-06-18", "2023-12-12", "2024-01-08", "2027-01-16", "2024-01-19", "2024-02-18", "2024-02-18", "2023-12-16", "2023-12-13", "2023-12-15", "2027-01-16", "2024-02-18", "2024-02-18", "2023-12-10", null, "2023-12-12", "2023-12-16", null, "2023-12-18", "2025-06-18", null, "2023-12-20", "2023-12-17", "2025-02-18"]),(2,-4,4,-4,-4,null,-8299718,-7790681,19649,'2023-12-20','2023-12-13','2023-12-09','2024-02-18','z','q','n','i','p','h','k','n',[29956, null, 2708152, 4180766, null, -16646, null, -960, -26572, null, 4418, null, null, null, null, -27193, -29347, -8615, -7836, -16066, -3784267, 2303156, 963691, 32368, null, -22973, -5475540, null, -8794, 5610750, 17826, null, null, null, 2642936, -29332, 21828, -24485, 23310, -21928],[null, null, null, null, null, 1690605, null, -4551, -24909, null, -8141713, 1664203, -6145254],[5432838, -28532, 9084],[6438479, null, 3698119, null, -21146, 30309, 23574, 19919, 8448, -8596, 6998816, -4624542, -22538, 19632, -30444, null, 7453453, -2480542, 16136, -356373, -4239, null, -1557467, -397756, -756, null, 9332, null, null, -321, -4952849, null, 65629, 17251, -3555105, -30177, -230, 18043, null, -13366, -7390776, null, 6654835],[null, 'g'],['a', 't', 'n', 'e', 'z', null, 'x'],[null, 'd', 'r', 'u', 'i', 'j', 'h', 'a', 'b', 'h'],[],["2023-12-17"],["2025-06-18", "2024-01-09", "2024-01-31"],["2025-02-18", "2023-12-15", null, "2024-01-17", "2024-02-18"],["2024-01-19", "2023-12-12", "2025-02-17", "2027-01-16", "2023-12-18", "2026-02-18", "2023-12-12", "2023-12-11", "2025-02-18", "2026-02-18", "2023-12-18", "2023-12-20", "2023-12-13", "2025-06-18", "2024-01-31", "2025-06-18", "2023-12-09", "2024-02-18", null, "2024-02-18", "2023-12-17", "2023-12-18", "2025-02-18", "2023-12-12", null, "2023-12-20", "2024-02-18", "2023-12-12", "2024-02-18", null, "2026-01-18", "2024-01-09", null, "2023-12-20", "2023-12-16", "2024-01-08", null, "2026-02-18", null, "2027-01-16", "2023-12-12", "2024-01-08"]),(3,9,-10,3,5,-5152627,-5145135,6986504,-20604,'2023-12-15','2023-12-13','2023-12-14','2023-12-15','v','f','u','o','n','b','h','y',[3443],[6391740, 5422888, -492, 8245552, 2636, -2780809, -29978],[16088, -7247349, -7458590, 2740940, null, null, null, -21826, -1848935, null, null, null, 4418535],[1142157, -3273, -15958, 2881572, -27206, -26818, null, -28001, 2584151, null, null, 11184, -31822, null, null, null, -5407054, null, -5605359, null, -11412],['e', 'g', 'b', 'o', 'w'],['g', 'g', 'k', 'i', 'w', 'n', 'o', 'v', 'f', 'd', 'z', 'q', null, 'w', 'f', 'w', null, null, null, 's', 'h', 'v', 's', 'u', null, 'n'],['d', 'n', 'g'],['e', 'm', 'k', 'm', 'h', 'u', 'z', 'l', 'n', 'q', 'x'],["2023-12-20", "2023-12-14", "2025-02-17", "2023-12-15", null, "2024-02-18", "2023-12-15", null, "2023-12-16"],["2025-02-18", "2023-12-14", "2025-06-18"],["2023-12-13", "2025-06-18", "2027-01-09", null, "2024-02-18", "2023-12-19", "2026-02-18", "2026-01-18"],["2023-12-18", "2024-01-17", "2024-02-18", "2025-06-18"]),(4,3,-4,3,-4,null,-1584250,-332882,-4905447,'2025-02-17',null,'2027-01-09','2023-12-16',null,'y','e','o','u','v','m','c',[-15763, -5359106, -24434],[-3779239, null, null, null, null, 5060, null, null, -31955, -6906924, 7177028],[-6845, -602, null, 21649, -17902, -25075, 13328, 5810518, 22416, -53406, 16876, 6328, null, null, null, -23941],[11186, null],['u', 'y', 'n', 'h', 't', 'k', null, null, 'l'],[null, 's', 't', 'q', 'p', 't', 'e', 'c', 'y', 'm', 'x', 'w', 'm', 'b', 'g', 'w', 'z', null, 'r', 'd', null, 'n', null, 'm', 'e', 'u', null, 'q', 'm', 'p', null, 'z', 't', 'o', 's'],[null, 'd'],[null, 'b', null, 'r', 'h', 's', 'q', 'h', 'm'],[null, null, "2024-02-18", "2024-01-17", "2023-12-13", "2024-01-17"],["2027-01-16", "2025-06-18", null],["2024-01-09"],["2024-01-31", "2025-02-18", "2027-01-16"]),(5,3,null,6,8,2854778,9666,-4700976,-7871284,'2025-02-18',null,'2024-01-09','2024-01-17','v','j','l','v',null,'b','n','g',[-9161, 806576, null, null, 2539356, 3477002, null, 19621, null],[7250884, null, 8219730, null, 6493797, -31014, -2669, 3599799, -735224, 25173, 13308, 5906342, 8070499, 4572, -6979430, 27920],[],[-6159748, null, null, 9043, null, null, 20090, null, null, -22439, null],['x', null, 'd', 'h'],[null, 'i', 'w', 't', 'f', null],['d', 'e', 'x', 'p', 's', 'i', 'f', 'd'],['a', 'z'],["2024-02-18", "2023-12-20", "2025-02-18", "2024-02-18", "2024-02-18", "2023-12-13", "2024-02-18", "2025-06-18", "2023-12-11", null, "2027-01-09", "2023-12-19"],["2025-02-17", "2026-01-18", "2027-01-16", "2023-12-14", "2025-02-18", "2024-01-19", "2025-06-18", "2023-12-16", "2027-01-09", "2023-12-10", "2025-02-18", null, "2025-06-18"],["2023-12-14", "2023-12-19", "2024-01-31", "2025-02-17"],["2023-12-11", "2024-01-08", "2025-02-17", null, "2024-01-08", "2023-12-19", "2024-02-18", "2023-12-14", "2024-01-09", "2026-02-18", "2023-12-12", "2023-12-20", "2024-02-18", "2025-02-17", "2023-12-16", "2025-02-17", "2023-12-18", "2023-12-13", "2027-01-16", "2023-12-15", null, "2026-02-18", "2023-12-15", "2024-01-08", "2023-12-12", "2023-12-09", "2023-12-18", "2024-01-31", "2023-12-11", "2023-12-15", "2025-02-17", null, "2024-02-18", "2023-12-10", "2023-12-16", null, "2024-01-08", null, "2024-01-31", "2023-12-09", "2023-12-10", null, "2023-12-11", "2024-02-18", "2023-12-15", null, "2025-02-17", "2024-01-31", "2023-12-09", "2023-12-14", null, "2026-01-18", "2023-12-20", "2024-01-31", "2024-02-18", "2023-12-14", "2024-01-09", "2024-01-17", "2024-02-18", "2024-02-18", "2026-01-18", "2024-02-18", "2024-01-08", "2023-12-17", "2023-12-16", "2023-12-15", "2023-12-09", "2023-12-20", "2024-01-31", null, "2023-12-14", "2023-12-13"]),(6,-10,9,-4,4,17064,null,-3444527,6831972,'2027-01-16',null,'2025-02-17','2023-12-20','a','v','e','x','q','t','v','c',[-12248, 5706253],[8265758, 1891518, null, 343319, null, 6145286, -7277684, -4439, 18409, -27099, -4940368, -1878, -6233, 1380723],[17182, 3109441, 7300860, -7329372, null, null, null, 6012060],[371441, null, 30764, 4967, -11962, 60226, null, null, null, null, null, -5034956, 6903140, -15094, -29581, 11835, -2859160, 17616, 10084, -1767810, 27580],['w', 'u', 'j', null, 'm', 'u', 'w', 'c'],['u', 'o', 'e', 'x', 'e', 'f', 'c', 'd', 'z', null, 'o'],['v', null, 'z', 'f', 'u', 'r', 'l', 'k', null, 'k', 'k', null, null, 'n', 'v', 'y', 'k', 'd', 'i', 'b', 'e', 'p', null, 'z', 'y', 'b', 'f', 'i', 'b', 'r', 'd', 'e', null, 'n', null, 'l', 'c', 'g', null, 'j', null, 'd', 'n', 'e', 's', 'r', null, 's', 'j', 'v', 'p', 'u'],['y', 'u', 'u'],["2025-06-18", "2025-02-18", null, "2024-01-17", "2024-02-18", "2024-02-18", null, "2024-02-18", null, "2023-12-18", "2027-01-16", "2023-12-13", null, "2023-12-15", "2027-01-16", "2023-12-15", "2025-02-17", "2026-02-18", "2024-01-17", "2023-12-18", "2023-12-09"],[null, "2023-12-20", "2024-02-18", "2024-01-09", null, null, "2025-02-17", "2023-12-12", "2023-12-18", "2025-02-18", "2023-12-10", "2026-02-18", "2024-02-18", "2025-06-18", "2023-12-18", "2023-12-17", "2027-01-09", "2024-01-19", "2023-12-17", "2024-01-17", "2027-01-09", "2024-01-09", null, "2024-01-31", "2023-12-11", "2024-02-18", "2026-01-18"],["2025-06-18", "2023-12-11", "2024-01-08", "2026-01-18", "2025-06-18", "2027-01-09", "2027-01-09", null],["2023-12-18", "2024-02-18", "2023-12-19", "2025-02-18", "2025-06-18", "2024-02-18", "2024-01-19", "2025-06-18", "2024-02-18", "2023-12-12", null, "2027-01-09", "2024-01-17", "2023-12-12", "2023-12-20", "2025-06-18", "2026-01-18", "2024-01-08", "2025-06-18", null, null, "2024-01-31", "2023-12-11", null, "2024-01-17", null, "2023-12-17", "2023-12-14", "2026-02-18", "2023-12-15", "2025-06-18", "2023-12-12", null, "2024-02-18", "2025-06-18", "2023-12-16", null, "2023-12-11", "2025-06-18", "2023-12-10", "2027-01-09"]),(7,6,-4,-10,1,-8383139,488676,25942,-6844644,null,'2024-01-08','2023-12-20','2027-01-09','k','f','m','r','l','t','f','x',[null, 31370, null, 11344, null],[1289638, 7378090, -4076, -3654288, 20933, 3795642, null, 7046449, -25007],[2771190, 20162, 877099, 2413, -4529674, 2233135, 14455, -3560001, -29631, 2047976, 5856889, -27930, -4774575, -7977519, null, 30017, null, -954908, null, 4583480, null, null],[4552647, 18706, 21794, -8005, -2240647, null, -2388, null, 732884, 3046184, null, null, 7337, -4615980, -6795924, -21823, -5841, 2815120, null, null, -8481, 32709, -4908792, 14179, -4490016, null, -2945, null, null, null, null, -23025, 24814, -2769112, 24921, null, null, 7970959, -24730, 1030977, -7668, 16500, 7548094, 16112, null, null, null, null],['q', 'o', 'k', 'c', 's', null, 'p', null, 'g', 'z', 'd', 'r', 'd', 'a', null, 'w', null, 'l', 'm', 'v'],[null, 'z', 'm', 'u', null, null, 'e', 'x', 'p', null],[null, 'h', null, 't', null, null],['f', null, 'v', null, 'l', 'k', 'a', null, 'l', null, null, 'i', null, 'h', 'j', null, 'm', 'z', 'b', null, 'h', 'c', 'z', 't', 'v', 'e', 'i', 't', 't', 'x', 'a', 'y', 'v', 'd', 'e', 'h', 's', 'u', null, 'b', 'g', 'h', null, 'e', null, 't', 'f', 'j', 'c', 'd', 'a', 'v', 'r', null, 'o', 'h', 'n', null, null, null, 'n', 'c', 'p', null, null, 'n', null, 's', 'y', null, 'k', 'w', 'i', 'a', null, 'x', 'p', 'y', 't', null, null, 'u', null],[null, "2023-12-18", "2024-02-18"],["2023-12-12", "2024-02-18", "2023-12-19", "2023-12-12", "2026-01-18", "2023-12-18"],[null, "2024-02-18", "2023-12-14", "2023-12-13", "2025-02-17", "2024-01-09", "2025-06-18", "2025-02-18"],[null, "2023-12-20", "2025-06-18", "2023-12-14"]),(8,-4,1,7,-10,-7132,1008329,5183204,-25057,'2024-01-09','2023-12-10','2024-01-17','2025-06-18',null,null,'w','n','v','n','m','w',[15252, 27759, -6459, null, -5040142, null],[null, null],[null, null, -8485, 3758840, null],[28819, -4400, null, -708, null, null, -4493405, -5017, null, null, 5215210, null, -213, -4337490, null, -2456643, 26206, 26048, -9226, -1046, null, -24230, null, 7979008, -3717682, -3668055, 9611, 21102, null, -2425835, 5395423, -8103945, null],[null, 'y', 'y', 'p', 't', 'v', null, 'v', 'g', 'e', 'f', 'v', 'q', 'k', 'i', 'w', 'h', 'j', 'y', 't', 'm', 'j', null, 'q', 'e', 'g', null, 'p', 'e', 'u', 'z', 'a', 'g', null, 'n', 'p', 'n'],[],[],['t', 'h', null, 'o', 'p', 'z', 'c', 'n', null, null, 'b', 'c', 'f', 'f', null, 's', 'm', 'u', 'i', null, 'i', 'a', 'u', 'h', 'f', 'y', 'v', 'b', 'p', 'f', 'a', 'p', 't', 'u', 'c', 'a'],["2025-02-17", null, "2024-02-18", null, "2026-01-18", "2024-02-18"],["2023-12-18", "2023-12-09"],[],["2024-01-09", "2023-12-13", "2024-01-17", "2023-12-16", "2026-02-18", "2026-01-18", "2023-12-10", "2023-12-16"]),(9,0,null,5,-10,-12101,null,-294874,6623565,'2023-12-14','2025-02-18','2023-12-15','2023-12-17','y','y','y','w','n','y','r','e',[-7239304],[-1460490, 5930961, 2339440, 1278440, 4116181, 6436894],[-12742, -4825983, null, 5439401, -5250, -27217],[null, 6417146, 4081139],['p', 'j', 'w', 'x', 'o', 'k', null, 't', null, 'b', 'e', 'x', 'o', 's', 'l', 'q', 'l', null, null, 'j', 'y', 'n', 'e', 'g', null, 'a', 's', 'v', 'q', 'u', 'j', 't', 'a', 'z', 'm', 'x', 'd', null, 'y', 'f', 'm', null, 'b', 'e', null, 'i', 'x', 'u', null],['h', 'f', null, null, 'g', 'p', 'e', 'f', 'l', 'm', 'v', 'm', 'g', 'p', 'g', 'm', 'e', null, 'k', 'h', 'a', 'd', 'y', 'j', 'j', 'm', 'g', 'r', 'c', 'u', null, 'd', 'i', 'r', 'l', 'j', null, null],['x', 'm', 'q', 'a', null, 't', 'r', 'n', 't', 'z', 'q', 'c', null, 'd', 'k'],['f', null, 'z', 'o'],["2023-12-16", null, "2024-01-09", "2024-01-19"],[],["2023-12-12", "2024-01-08", "2024-01-09", "2023-12-11", "2023-12-16", "2023-12-19", "2025-02-17", "2023-12-12", "2023-12-15", "2023-12-12", "2024-02-18"],["2025-06-18", "2027-01-09", "2023-12-09", "2024-01-17", "2024-01-19", "2023-12-10", "2024-01-09"]),(10,-4,6,-4,8,7668480,12311,-2302965,24187,'2024-02-18','2023-12-14','2023-12-19','2023-12-18','w','e','q','c','r','j','p','m',[4435282, 695137, 5167063, -7144199, 4491, 622539, 328263],[null, 7263600, null, 2962764, null, null, 4443],[null, null, -315785, -19966, -12331, 2297033, -2155440, null, -11150, -17178, 4148249, 10145, -2822, 572786, null, null, null, null, null, -5736527, null, null, null, 6880525, 6270008, 1824, -32226, null, null, null, -7586, null, 2928908, -6873675, 4374133, 30907, -6856016, -7325917, null, null, -23290, null, 12121, -56130, 1723237, null, -13447, 2900221],[-3887447, 29513, -27218, 7731280, 8020208, -7153276, -6191389],['z', null, null, 'h', null, 'j'],['w', 'd', 't', 'n', 'p', 'u', 'f'],['o', 'x', 'l', 'p', 'd', 'q', 'p', 'n', 'w'],['n', 'r', 'g', null, 'h', 'e', 'y', 'r', 'o'],["2027-01-16", "2024-01-09", "2025-06-18", "2025-02-17", "2023-12-13", "2023-12-10"],["2027-01-09", "2023-12-09", "2024-02-18", "2026-01-18", "2025-06-18"],["2023-12-13", "2025-02-17", "2023-12-18", "2023-12-17", "2024-02-18", "2023-12-16", null, null, "2026-01-18"],[null, "2025-06-18", "2023-12-12", "2023-12-16", "2023-12-18", null, "2025-02-18", "2027-01-16", "2024-02-18", "2023-12-18"]),(11,7,3,0,-10,27729,-1597057,8437,10443,'2023-12-12','2023-12-09','2026-01-18','2023-12-20','j','g','i','r','l','g','g','t',[],[-392, -21067],[5163, -7859152, 30104, null, 963298, -21071, 8298766],[-3715006, null, -28561, -6846775, 1179, -4711549, -26316, -2904644, null, -4577223, 5725555, 30687, null, 3598210, null, 1875361, -4470182, 2060, -5637840],['r', null],[null, 'l', 'u', null, 't', null, 'o', null, 'w', 'l', 'l', 'k'],['p', null, 'x', 'f', 'e', 'q', 'z', 'd', 'e', 'j', 'g', null, 'c', 'v', 'y', 's', 'l', null, 'g', null, 'p', 'x'],['u', 'x', 'h', 'x', 'c', 'z', 's', null, 'c', 'p', 'j', 'k', 'd', 't', null, 'o', null, 'm', 't', 'k', 'j', 'h', null, 'n', 'i', 'c', 'q', null, 'v', null, null, 'o', 'p', 'b', 't', 'b', 'q', 'r', 'b', 't', 'e', null, 'r'],["2026-01-18", "2025-02-17", "2024-01-31"],["2024-02-18", "2023-12-18", "2024-01-31", "2023-12-12", "2023-12-13", "2023-12-17", "2023-12-19", "2024-02-18", "2023-12-17", "2023-12-14", "2024-01-08", "2024-02-18", "2025-06-18", "2024-01-31", "2024-02-18", "2023-12-11", null, "2024-01-17", null, "2023-12-19", null, "2023-12-19", "2023-12-13", "2026-02-18", "2023-12-19", null, "2024-02-18", "2024-01-08", null, "2024-01-17", "2023-12-20", "2023-12-18", "2023-12-10", "2023-12-13", null, "2025-06-18", "2023-12-17", null, null, null, "2023-12-17", "2024-01-19", "2023-12-14", "2025-02-17", "2023-12-12", "2026-02-18", "2025-02-17"],[null, "2023-12-19", "2023-12-15", "2023-12-18", "2025-02-18", "2023-12-20", "2023-12-18", "2024-02-18", "2024-01-17"],[]),(12,-10,-4,0,-10,null,-27963,-2818488,1425862,'2023-12-10','2023-12-14','2023-12-09','2025-06-18','w','a','n','v',null,'v','f','c',[null, 1305092, -2438814, -6947222, -2614382, -28347, 32717, null, -23097, null, 4288469, 1963103, null, 1001797, 6249472, 623992, 758210],[7055189, -32253, -2337710, null, null, 17178, null, null, 1646866, -438270, null, 5981487, -17043, -7135891, -23360, 4857165, 24183, -1995678, 636071, 783, -805, 10852, -5138163, 24798, 1858131, 15237, -3565, null, -23376],[951977, 2311680, 31740, null, -26586, -5684614, null, -5229659, 27866, -10603, -2936, null, -12738, null, -388178, -19354, null, 8377388],[null, 16024, -468293, -6161072],[null, 'a', 'v', null],['b', 'k', 't', null, 'u', 'o', 'q', 'a', null, 'j', 'b', 'r', 'u', 'x', 'h', 'h', 'k', null, 'm', 'o', 'w', 'l', 'h', null, 'y', 'p', 'c', null, 'm', 'o', 'y', 'i', 'm', 'q', 'x', 'm', 't', 'f', 'x', 't'],['s', 's', 'e', 'b', 'p', 'y', 'f'],['u', 'c', 'p', 'h', 'o'],["2023-12-12", "2023-12-15", "2023-12-13"],["2025-06-18", "2023-12-11", "2023-12-12", "2027-01-16", "2024-02-18", "2023-12-11", "2027-01-16", "2024-02-18", "2023-12-16", "2027-01-09", "2023-12-12", "2024-01-09", "2025-02-17", "2024-01-19", "2023-12-20", "2024-01-08", "2023-12-11", "2023-12-20", "2024-02-18", "2023-12-19", "2024-01-08", "2023-12-12", "2025-06-18", null, "2025-06-18", null, "2023-12-09", "2023-12-18", null],["2023-12-16", "2024-02-18", null, "2024-02-18", "2026-01-18", "2023-12-14", "2023-12-12", "2025-06-18", "2026-02-18", "2027-01-16"],["2025-06-18", "2024-01-08", "2024-01-09", "2027-01-09", null, "2023-12-16", "2027-01-16"]),(13,5,null,8,-4,null,3558665,3390,10801,'2024-01-17','2024-01-08','2024-01-08','2025-02-18','s','i','s','u','d','t','u','o',[-5186684, 3411, null, 5556519, null, 6257, null, 30818, 30628, -24827, -1912, null],[3939, null, null, 19998, -27853, null, -6305, -24322, null, -6037403, null, -30153, 3345863, -394168, -3201436, 27663, 25009, null, 29942, 24805, null, 1808732, -4244398, -3569708, 7456786, null, 310339, null, null, -19688, null, -1303433, 5384133, -543381, -329, 9036, 3698961, null, -5843128, null, null, -741, null, 26031],[-3462562, 6447984, null, 7605875, null, 1538616, 449, -3868637, null, -1787, -4423897, -11485, null, -1150262, 6422841, 2106955, 4331427, -181, null],[null, -8448, -16310, -20983, 1397438],[null, 's', 'c', 'w', 'b', 'y', null, 'k'],[],['q', 'y', 'c', 'q', 'z', 'u', 'q', 'k'],['u', null, 'x', null, 'z', 'w', 't', 't', 'r', 'b', 's', 'o', 'c', 'j', 'v', 's', 'p', 'x', 'e', 'o', 'm', 'm', 'j', null, null, 'v', 'm', 'g', 'x', 'f', null, 'c', 'u', 'p', null, null, 'n', null, 'l'],["2024-01-08", "2023-12-11", "2024-02-18", "2023-12-16", "2025-02-18", null, null, "2023-12-14", "2023-12-15", "2023-12-12", "2024-02-18", null, "2023-12-13", "2023-12-19", null, "2024-02-18", "2023-12-11", "2024-01-17", "2027-01-09", "2023-12-09", "2024-02-18", "2023-12-14", "2023-12-17", "2027-01-16", "2023-12-13", "2023-12-14", "2023-12-13", null, "2027-01-09", "2024-01-08", "2024-01-19", "2027-01-16", "2024-02-18", "2024-01-19", "2024-01-31", "2024-02-18", "2023-12-17", "2023-12-11", "2023-12-11", "2023-12-09", "2024-01-17", "2023-12-20", "2026-01-18", "2025-02-18", "2024-02-18", "2023-12-12", "2023-12-13", "2024-01-09", "2023-12-16", "2023-12-11", "2025-02-18", "2025-06-18", null, "2027-01-16", "2024-02-18", "2024-01-17", null, "2023-12-19", "2025-06-18", "2024-01-19", "2023-12-15", "2024-02-18", "2023-12-20", "2023-12-12", "2024-01-19", "2023-12-18", "2023-12-10", "2026-02-18", "2023-12-09", "2023-12-09", "2025-02-18", "2023-12-11", "2026-01-18", "2023-12-19", "2024-01-19", "2025-02-17", "2023-12-13", "2024-01-08", "2025-06-18", "2027-01-16", "2025-02-17", "2023-12-17", "2023-12-20", "2023-12-17", "2024-01-31", "2023-12-18", "2023-12-19", "2027-01-09", "2023-12-17", "2027-01-16", "2023-12-18", "2024-01-31", "2025-02-17", "2026-02-18", "2025-02-18", "2024-02-18", "2023-12-19"],["2023-12-19", "2023-12-17", "2026-01-18", "2023-12-09", "2023-12-13", "2025-06-18", "2023-12-11", "2023-12-09", "2023-12-09", "2026-01-18", "2024-01-19", "2024-01-09", "2025-06-18", "2023-12-09", "2023-12-12", "2023-12-18", "2024-01-08", "2024-02-18", "2026-01-18", "2027-01-16", null, "2024-01-31", "2027-01-16", "2025-06-18", "2025-06-18", null, "2025-06-18", null, "2024-01-19", "2027-01-09", "2025-06-18", "2025-06-18", "2025-06-18", null, "2024-01-19", "2024-02-18", "2025-06-18", "2025-06-18", "2023-12-09", "2025-02-17", "2023-12-11", "2026-02-18", "2024-01-17", "2026-02-18", "2025-06-18", "2023-12-18", "2026-01-18", "2023-12-16", "2023-12-15", "2025-06-18", "2024-02-18", "2024-01-09", "2023-12-14", "2025-06-18", "2026-02-18", "2023-12-19", "2023-12-12", "2023-12-12", "2024-02-18", "2026-01-18", "2027-01-16", "2024-01-09", "2023-12-16", "2024-02-18", "2024-01-08", "2027-01-09", "2024-02-18", "2024-01-31", null, "2024-01-17", "2024-02-18", "2023-12-12", "2023-12-09", "2024-01-08", "2025-02-17", "2024-02-18", "2024-01-09", "2026-02-18", "2025-02-18", "2026-02-18", "2026-02-18", "2023-12-15", "2023-12-16", "2023-12-11", "2023-12-17", "2024-02-18", "2027-01-16", "2023-12-10"],["2024-01-31", "2025-02-18"],[null, "2023-12-17", "2023-12-18", "2023-12-14", null, "2023-12-17", "2025-06-18", "2025-06-18", null, null, "2024-02-18", null, "2025-06-18", "2023-12-09", "2024-01-19", "2023-12-11", "2027-01-09", "2023-12-20", "2023-12-17", "2023-12-11", "2025-02-17", "2023-12-10", "2025-06-18", null, null, "2026-01-18"]),(14,5,4,9,-4,null,-6919782,14792,5528709,'2024-02-18','2026-01-18','2026-02-18','2025-06-18','d','b','m','o','d','a','s','r',[3181050, -23959, null, 6563755, 6061],[-17423, null, null, null],[null, null, 25045, -19501, null, -15807, null, -8336621, 5072, -19448, -472845, null, 4409],[-23925],['h', 'r', 'x'],[],['m', null, null],[null, 's', null, null, null, 'q', 'j', 'h'],["2027-01-16"],["2023-12-10", "2024-01-09"],["2023-12-20", "2024-01-31", null, "2024-01-31", "2023-12-20", null, "2025-02-18", "2023-12-16", "2023-12-09", null, "2024-01-31", "2024-01-19", "2024-02-18"],["2024-01-08", "2024-01-09"]),(15,4,-4,5,8,-28910,-8118655,5617,7465079,'2025-02-17','2023-12-19','2027-01-09','2027-01-09','u','e','y','f','a','l','b','c',[17894, null, null, null, 3463, -30173, -6635474],[null, -29403, -2945200, -10643, -3074444, 2596382, null, -31507, null, null, null, -1859636, 5348331, 4720562, 14109, 19714, 28650, 28246, 2045787, null, null, null, 10957, -6899012, null, null, null],[-837730, 986528, 6323561, 7993, -8234195, null, null, -2027585, null, null, null, 10504, -4749, 31158, 25319, null, null, -5326842, -5365541, 2200382, null, -6135103, 2870363, null, null, -14882, null, 17664, 734, 19430, 17512, null, null, -22941, -19808, null, -356592, 7205186, null, null, 7268014, -7876274, -6850378, 3418],[239344, -7900359, -4679874, -6340806, -924637, null, null, -2088500, null, -5296280, null, -5950761, null, -2743293, null, 23006, -5690930, -7113168, 24992, -1228822, null, 30513],[null, 'x', null, 'g', 's', 'm', 'e', 'z', 'k', 'p', 'p', 'n', 'q', null, 'z', null, 'j', null, 'o', 'y', 'y', null, null, 'j', 'f', null, 'h', 'l', 'u'],['f', 'f', 'b', 'g', 'z', 's', 'v', 'v', 'z', 'd', 'v', 'f', 'd', 'i'],['n', 'f', null, null],['l', 'w', 'u', null, 'a', null, null, 'm', 'y', 'l', 'v', 'm', 's', 'c', 'n', 'h', 'u', 'z'],[null, "2024-01-09", "2025-02-17", "2023-12-13", "2026-02-18", "2023-12-10", "2024-01-31", "2024-01-31", "2024-01-19", "2023-12-13", "2024-01-19", "2025-06-18", "2025-02-17", "2027-01-09", "2024-01-17", "2024-02-18", "2024-01-17", "2023-12-15", "2026-01-18", "2025-06-18", "2025-06-18", "2023-12-19", "2023-12-09", "2023-12-14", "2026-01-18", "2023-12-19", "2027-01-16", "2026-02-18", null, "2025-06-18", "2024-02-18", "2024-02-18", "2024-01-09", null, "2023-12-19", null, "2023-12-18", "2024-01-19", "2023-12-18", "2025-06-18", "2023-12-13", null, "2023-12-11"],["2024-02-18", "2023-12-18"],[null, "2023-12-11", "2023-12-14", "2025-06-18", "2025-02-18", "2024-01-31", "2024-02-18", "2023-12-17", "2023-12-09", "2023-12-10", "2025-06-18", "2023-12-11", "2025-02-18", "2024-01-17", "2023-12-11", "2023-12-13", null, "2023-12-14", "2026-02-18", "2024-01-09", "2024-02-18", "2023-12-11", "2023-12-10", "2026-02-18", "2025-02-17", "2023-12-20", "2023-12-10", "2024-01-17", "2024-02-18", "2024-02-18", "2024-01-08", "2023-12-18", "2027-01-16", "2023-12-18", "2023-12-13", "2026-01-18", "2024-01-17", "2024-01-09", "2024-01-31", "2023-12-09", "2023-12-13", "2026-02-18", "2023-12-19", "2023-12-12", null, "2024-01-09", "2023-12-11", "2025-02-18", "2023-12-14", "2024-02-18", "2024-01-09", "2025-06-18", "2027-01-16", "2026-01-18", "2024-01-31", null, "2025-02-17", null, "2024-02-18", "2025-06-18", "2025-02-17", "2024-01-19", "2023-12-09", "2024-01-17", "2025-06-18", null, "2024-01-31", "2026-02-18", null, "2024-01-17", "2027-01-09", "2023-12-15", null, "2025-02-17", "2023-12-11", "2026-02-18", "2023-12-14", "2024-01-31", "2023-12-19", null],["2025-02-18", "2025-02-18", "2027-01-09", "2024-01-09", "2026-01-18", null, "2025-06-18", "2023-12-17", "2024-02-18", "2026-02-18", null, "2025-06-18", "2023-12-09", "2026-02-18", "2024-01-09", "2024-01-17", "2025-02-17", "2023-12-20", null, "2024-02-18", "2023-12-14", "2026-02-18", "2025-06-18", "2025-02-18", "2025-06-18", "2023-12-09", "2023-12-14", "2027-01-16", null, "2024-02-18", "2025-06-18", "2023-12-19", "2024-01-17", "2025-02-17", "2024-01-09"]),(16,8,6,-4,-4,30089,682261,3437,-13954,'2023-12-11',null,'2023-12-18','2023-12-16','j','q','g','m',null,null,'a','b',[5589761, null, -6141, -829684, null, -2464531, null],[-5777733, -8175496, null, null, -6160945, 1884632, -6941554, null, null, 7548929, 18625, 26231, -7353138, 4833709, -5089, 26486, -5840395, 28505, null, 17482, 7233510, -1629007, 1500069, -5038307, 21571, 31219, -1234923, -4758654, -24295, -1294544, -4644, -372141, -3536794, -5029586, -726654, 6911890, -2819474, 866330, -7881, -7890785, -3375667, -19409, null, 30313, -21264, 3274253, null, -3911042, 6247194, 13814],[1553786, null, null, -6903982, 22297, 2621822, null, null, 2092183, 508828, null, 1963331, -4981507, null, null, -8349, null, 331040, null, -17039, null, -8342455, 3978260, -4805305, -1010827, -4163171, -31921, 1994228, null, null, -6510208, -13536, 99231, 29612, -29057, null, null, -30540, null, null, -28386, 4776056, null, -5832862, -3467200, 11076, 458022, -16212, 1761, null, -20271, null, -1796947, -1901630, null, 2123642, -16292, -3228029, null, -7859248, null, -488, 61494, -7763832, -6262170, null, 1114541, null, null, -7147, null, null, null, null, -16138, 13011, null, null, -7710594, 7254450, 1806497, null, null, null],[7067452, null, -30604, 1449060, null, 2409450, 9369, -8147794, -27009, -3197541, 4534865, -1160, 2114, null, -407, null, 4703307, -9201, -4995270],['w', null, null, 'f', 'h', 'd'],['c', null],['y', 'n', null, null, 'c', 'w', 'm', null, 'e', 'y', 'c', 'l', null, 'w', null, null, 'a'],['w', 'f', null, 'a', 'c'],["2024-01-19", "2023-12-15", "2024-01-08", "2024-01-09", "2024-01-31"],["2024-02-18", "2025-02-17", "2023-12-13", null, "2023-12-14", "2023-12-14", "2025-02-18", "2024-01-09"],["2023-12-11", "2023-12-20", null, "2024-02-18", "2025-06-18", "2023-12-17", "2023-12-15"],["2024-01-19", "2023-12-18", "2024-01-08", "2024-01-19", null]),(17,-10,2,0,0,-3963084,-4213,4815,-1179164,'2023-12-10',null,'2023-12-17','2023-12-10','i','r','y','q','b','r','x','u',[4307633, -16947, null, -7862, -4232563, null],[-5496764, 3255696, 8195495, null, null, -5719, null, null, null, null, -7172947, null, 7157],[-5317, null],[-6848, -2821134, 1324574, 7026121, null, null, 1825837, -7975568, 29170, -788852, 6471854, null, -1420090, 15726, -27909, -1605263, -7104, -12889, -20339, -75192, null, -264319, -21528, null, 843, 6821, null, null, -5197035, null, 303660, null, -13114, -1545788, 7648700, null, 20672, -1063066, null, null, 3120252, 10972, null, null, null, 1011, 7256375, 22013, -18143],['f', 'm', null, 'v', 'v', 'e', null],['a', 'q', 'm', 'b'],['t', null, 'm', 'w', 't', 'p', 'k', 'r', null, null, 'f', null, null, 'v', 'm', 'w', 'z', 'c', 's', 'o', null, 'r', 'j', 'r', 'j', 'k', 'y', null, 'x', null, 'i', null, null, 't', 'o', null, null, 'i', 'n', 'j', 'r', 'h', 'p', null, 'i', 'o', 'n', 'a', 'w', 'o', 'f', 'g', 'b', 'm', 'm', 'a', null, 'v', null, 'f', 'u', 'x', 'k', null, 'm', null, 'y', 'o', 'p'],['s', 'z', 'k', 'z', 'u', 's', 'w', null],["2024-01-17", "2026-01-18", "2025-06-18", "2023-12-18", "2023-12-14", "2027-01-09", "2025-06-18", "2024-02-18", "2024-01-17", null, "2023-12-20", "2023-12-18", "2026-01-18", null, "2026-02-18", null, "2023-12-20", "2025-02-17", "2024-02-18", "2023-12-18"],["2024-01-31", "2024-02-18", "2023-12-18"],["2023-12-13", "2024-02-18", "2023-12-18", "2024-02-18"],["2026-02-18", "2023-12-10", "2024-02-18", "2023-12-17", "2025-02-17", "2023-12-19", "2025-02-17", "2023-12-15", "2023-12-18", null, null, null, "2024-01-17", "2023-12-17", "2024-02-18"]),(18,1,null,8,2,null,15665,-4275671,6028673,'2023-12-13',null,'2024-01-08','2023-12-11','e',null,'l','u','h','m','l','c',[-10318, -1263585, -6254186, 2654133, null, -6057511, null, null],[6098826, -8202533, 807153, 7776466, null, null, -17404, null, 5176, 19635, 1659787],[-611181, -3239393, 32010, 4591, 24397, -2884938],[null, -19540],[],['h', 'a', 'd', 't', 't', 'v', 'u', null, 'z', 's', 'k', 'g', 'w', null, 'p', 'l', 'q', null],[null],[null, 'm', 'j', 'w', 'j', 'h', 'c', 'a'],["2023-12-20", "2024-01-17", "2023-12-11", "2023-12-11", null, "2024-01-08", null],["2023-12-19", "2023-12-18", "2023-12-16", "2023-12-13", "2023-12-12", "2026-01-18", null, "2025-02-18", "2025-02-17", "2024-01-09", "2024-01-19", "2025-06-18", "2027-01-16", "2024-01-19", "2023-12-20", "2023-12-12", "2023-12-13", "2023-12-15", null, "2023-12-11", null, "2023-12-12", "2024-02-18", "2023-12-14", "2024-02-18", "2023-12-17", "2024-01-17", "2023-12-16", "2023-12-13", "2023-12-13", "2024-02-18", null, "2024-01-31"],["2025-02-17", "2023-12-15", "2023-12-17", "2024-01-19", null, null],["2023-12-13", "2026-01-18", "2023-12-14", "2024-01-09", "2027-01-16"]),(19,9,null,1,7,6154640,-7229,-8184918,-21039,'2023-12-20','2024-02-18','2023-12-20','2023-12-18','s','o','a','q','k','o','v','k',[-5182, 3195842, -5351075, -1231302, null, 844501, -5263, 20861, 19067, null, -20869, null, 4319584, null, null, null, -5756228, -30379, null, -528148, null, -31188, 8084, 7850, null, 7848296, null, -6726665, 2320612, 30713, -7784, -17238, 17215],[6314665, -473, null, 5473545, null, 22163],[822733, 18378, -10390],[-4771049, null, 16393, 2563103],['h', 'u', 'm', 'h', 'j', null, null, null, null, 'h', 'e', 'm', 'y', 'v', 'a', 'f', 'l', null, 'r', null, 'q', 'g', 'o', 'd', 'y', 'l', 'd', 'b', 'a', null, 'n', 'z', 'm', 'h', 'u', 'c', 'i', 'm', 'e', 'd', 'f', 'q', null, 'u'],['g', null, 'l'],['i', 'g', 'h', 'v', 'j', 'q', 'y', null, 'q', null, 'n', 'n', 'w', 't', 'i'],[null, 'j', null, 'l', 'v', 'i', 'n', 'l', 'e', null],["2024-01-17", "2023-12-09", "2025-02-17", "2025-06-18", "2023-12-16", null],["2023-12-17", null, "2025-06-18", "2024-01-17"],[null, "2023-12-19", null, null, null, "2023-12-14", "2023-12-11", null, "2023-12-14", "2023-12-18", "2025-06-18", "2023-12-19", "2025-02-18", "2024-01-31"],["2023-12-19", "2023-12-16", "2025-02-18", "2023-12-11", "2024-01-09", "2024-01-09", "2027-01-16"]),(20,8,null,-4,5,null,-7011009,4903342,2698351,'2024-02-18','2023-12-14','2023-12-19','2023-12-15','a',null,'z','m','d','c','e','g',[null, null, null],[32511, null, -3407, null, 1470715, -6492],[-1502, null, -6175, -32320, -14444, -7645258, null, null, -2461007],[],['d', 'o', 'b', 'p', 'u', 'g', 'i', 'h', 'q'],[null, 'x', 't', 'c', 'f', 'j'],['m', 'g', 'r', null],['i', null, 'a', 'y', 'e', 'x', 'g', null, 'j', 't', 'd', 'z'],["2024-01-09", "2025-02-17", "2025-06-18", "2025-06-18", "2026-01-18", "2023-12-18"],["2026-02-18"],[null, "2024-01-31", "2023-12-15", null, "2023-12-18", "2025-02-18", "2026-02-18", "2024-02-18", null, "2024-01-19", "2023-12-11", "2026-01-18", "2026-02-18", "2023-12-13", "2025-02-18", "2024-01-08", "2024-02-18", "2023-12-10", "2025-06-18", "2024-02-18", "2023-12-18", null, "2026-01-18", null, "2024-01-17", "2024-02-18", "2023-12-15", "2024-01-09", "2023-12-16", "2023-12-11", "2024-01-08", "2026-02-18", "2024-02-18", null, "2025-06-18", null, "2023-12-18", "2023-12-09", "2025-02-17", "2026-01-18", "2025-06-18", null, "2023-12-10", "2026-02-18", "2027-01-16", "2023-12-19", "2023-12-11", null, null, "2024-02-18", "2023-12-18", "2025-02-17", "2024-01-17", "2023-12-20"],["2023-12-10", "2023-12-12", "2023-12-19", "2023-12-12", "2026-01-18", "2023-12-12", "2023-12-13", "2023-12-09", "2024-01-31", "2024-01-17", "2027-01-09", "2024-02-18", null, "2025-02-18", "2026-01-18", "2026-01-18", "2025-06-18", "2023-12-09", "2027-01-09", "2026-01-18", "2023-12-17", "2023-12-17", "2023-12-19", "2024-02-18", "2023-12-14", "2024-01-19", "2024-01-08", "2023-12-11", "2023-12-19", "2026-01-18", "2023-12-17", null, "2026-01-18", "2027-01-09", "2023-12-20", "2024-01-09", "2023-12-16", "2023-12-20", null, null, "2026-01-18", "2023-12-15", null, null, "2023-12-11", "2023-12-20", "2026-01-18", "2024-02-18", "2023-12-17", null, "2025-06-18", "2024-02-18", "2023-12-12", "2025-06-18", null, "2023-12-19", "2023-12-14", "2025-06-18", "2024-01-19", "2023-12-14", "2024-01-31", "2023-12-16", "2023-12-14", "2023-12-13", "2025-06-18", "2026-02-18", "2023-12-17", "2023-12-09", "2025-06-18", "2027-01-16", "2024-02-18", "2024-02-18", "2027-01-09", "2023-12-20", "2026-01-18", "2024-01-17", "2023-12-19", "2024-01-17", "2025-02-17", "2025-02-17", "2024-01-17", "2023-12-15", "2024-01-17", null, "2023-12-18", "2024-01-08"]),(21,6,2,-4,8,-23565,-14066,17507,-14163,'2025-06-18','2025-02-17','2026-02-18','2024-02-18',null,'i','y','i','z','t','d','r',[-3792146, 23264, -5192962, null, -6847533, -30804, 3881259, 1707873, -4366, -2416413, null, null, 3425107, 1394876, 1385, 673, 2629308, 10899, -16112, -6722, 9906, 3936, -3956341, 7095173, 7670244, -1905, null, 27842, null, null, -4997295, -6041520, 29388, null, 7118891, -7387, 22531, null, null, -4325349, null, null, null, 6913556, -5885, null, -3199528, 210046],[24991, -3202548, null, 6355130, null, -3602045, 5821567, 13256, null, -19560, 26768, -5251, -2518385, null, -451737, -8351018, null, null, -3993, 6887, null, null, 5815493, 24050, -12003, -5364723, 4882394, 2077766, null, -725502, 3068508, null, 5143543, null, null, -4286258, -24989, null, 4166738, 6312, null, -511, -5141213, null, null, -7091378, null, null, null, null, -6840846, 210343, -7095563, -32068, null, -3629517, -5029, 25835, null, 991962, 5588154, -21357, -4061, -2894260, -19610, 5872764, 3129526, 7911490, null, 11556, -2086157, -25102, -7973928, -24334, 11499, -1762301, null, -1204046, null, 7908467, null, -77492, -8565, null],[2209760, null, 28627, -2346639, -5523462, -1791, -1880156],[],['i', null, 'f', 'd', 'x', 'k', 'h', 'x', 'e'],['b', 'o', 't', 'i', 'r', 'i', 't', 'i', 'm', 'p', 'e', 'y', null, 'z'],['t'],[],["2024-01-31", "2023-12-13", null, "2023-12-10", "2024-01-19", "2023-12-10", "2023-12-16"],["2024-02-18", "2026-01-18", "2023-12-15", null],[null, "2023-12-18", "2026-01-18", "2024-02-18", "2024-01-09"],["2023-12-12", "2024-02-18", "2023-12-19", "2023-12-16", null, "2024-01-08", "2023-12-15", null, "2023-12-13", "2024-02-18"]);
    """

    qt_select_bug_2 """
    SELECT
        table1.col_date_undef_signed_not_null_index_inverted,
        table1.col_date_undef_signed_index_inverted
    FROM
         ${table1} AS table1
    WHERE
        (
            (
                NOT (
                    table1.`col_date_undef_signed_not_null_index_inverted` IN ('2023-12-13')
                )
                AND table1.col_date_undef_signed_not_null_index_inverted <> table1.col_date_undef_signed_index_inverted
            )
            OR table1.col_date_undef_signed_index_inverted > table1.col_date_undef_signed_not_null_index_inverted
        )
    ORDER BY
        1,2;
    """

}
