/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.backpressure;

import java.time.Duration;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.statefun.flink.core.backpressure.SystemNanoTimer;
import org.apache.flink.statefun.flink.core.backpressure.Timer;

public final class BoundedExponentialBackoff {
    private final Timer timer;
    private final long requestStartTimeInNanos;
    private final long maxRequestDurationInNanos;
    private long nextSleepTimeNanos;

    public BoundedExponentialBackoff(Duration initialBackoffDuration, Duration maxRequestDuration) {
        this(SystemNanoTimer.instance(), initialBackoffDuration, maxRequestDuration);
    }

    @VisibleForTesting
    BoundedExponentialBackoff(Timer timer, Duration initialBackoffDuration, Duration maxRequestDuration) {
        this.timer = Objects.requireNonNull(timer);
        this.requestStartTimeInNanos = timer.now();
        this.maxRequestDurationInNanos = maxRequestDuration.toNanos();
        this.nextSleepTimeNanos = initialBackoffDuration.toNanos();
    }

    public boolean applyNow() {
        long nextAmountOfNanosToSleep;
        long remainingNanos = this.remainingNanosUntilDeadLine();
        long actualSleep = Math.min(remainingNanos, nextAmountOfNanosToSleep = this.nextAmountOfNanosToSleep());
        if (actualSleep <= 0L) {
            return false;
        }
        this.timer.sleep(actualSleep);
        return true;
    }

    private long remainingNanosUntilDeadLine() {
        long totalElapsedTime = this.timer.now() - this.requestStartTimeInNanos;
        return this.maxRequestDurationInNanos - totalElapsedTime;
    }

    private long nextAmountOfNanosToSleep() {
        long current = this.nextSleepTimeNanos;
        this.nextSleepTimeNanos *= 2L;
        return current;
    }
}

