/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.statefun.flink.core.common.KeyBy;
import org.apache.flink.statefun.sdk.Address;

class Partition {
    private final int maxParallelism;
    private final int parallelism;
    private final int thisOperatorIndex;

    Partition(int maxParallelism, int parallelism, int thisOperatorIndex) {
        this.maxParallelism = maxParallelism;
        this.parallelism = parallelism;
        this.thisOperatorIndex = thisOperatorIndex;
    }

    boolean contains(Address address) {
        int destinationOperatorIndex = KeyGroupRangeAssignment.assignKeyToParallelOperator((Object)KeyBy.apply(address), (int)this.maxParallelism, (int)this.parallelism);
        return this.thisOperatorIndex == destinationOperatorIndex;
    }
}

