/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.message;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.MessageFactory;
import org.apache.flink.statefun.flink.core.message.MessageFactoryKey;
import org.apache.flink.statefun.flink.core.message.MessageFactoryType;

public final class MessageTypeSerializer
extends TypeSerializer<Message> {
    private static final long serialVersionUID = 2L;
    private final MessageFactoryKey messageFactoryKey;
    private transient MessageFactory factory;

    MessageTypeSerializer(MessageFactoryKey messageFactoryKey) {
        this.messageFactoryKey = Objects.requireNonNull(messageFactoryKey);
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<Message> duplicate() {
        return new MessageTypeSerializer(this.messageFactoryKey);
    }

    public Message createInstance() {
        return null;
    }

    public Message copy(Message message) {
        return message.copy(this.factory());
    }

    public Message copy(Message message, Message reuse) {
        return message.copy(this.factory());
    }

    public int getLength() {
        return -1;
    }

    public void serialize(Message message, DataOutputView dataOutputView) throws IOException {
        message.writeTo(this.factory(), dataOutputView);
    }

    public Message deserialize(DataInputView dataInputView) throws IOException {
        return this.factory().from(dataInputView);
    }

    public Message deserialize(Message message, DataInputView dataInputView) throws IOException {
        return this.deserialize(dataInputView);
    }

    public void copy(DataInputView dataInputView, DataOutputView dataOutputView) throws IOException {
        this.factory().copy(dataInputView, dataOutputView);
    }

    public boolean equals(Object o) {
        return o instanceof MessageTypeSerializer;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public TypeSerializerSnapshot<Message> snapshotConfiguration() {
        return new Snapshot(this.messageFactoryKey);
    }

    private MessageFactory factory() {
        if (this.factory == null) {
            this.factory = MessageFactory.forKey(this.messageFactoryKey);
        }
        return this.factory;
    }

    public static final class Snapshot
    implements TypeSerializerSnapshot<Message> {
        private MessageFactoryKey messageFactoryKey;

        public Snapshot() {
        }

        Snapshot(MessageFactoryKey messageFactoryKey) {
            this.messageFactoryKey = messageFactoryKey;
        }

        @VisibleForTesting
        MessageFactoryKey getMessageFactoryKey() {
            return this.messageFactoryKey;
        }

        public int getCurrentVersion() {
            return 2;
        }

        public void writeSnapshot(DataOutputView dataOutputView) throws IOException {
            dataOutputView.writeUTF(this.messageFactoryKey.getType().name());
            Snapshot.writeNullableString(this.messageFactoryKey.getCustomPayloadSerializerClassName().orElse(null), dataOutputView);
        }

        public void readSnapshot(int version, DataInputView dataInputView, ClassLoader classLoader) throws IOException {
            MessageFactoryType messageFactoryType = MessageFactoryType.valueOf(dataInputView.readUTF());
            String customPayloadSerializerClassName = null;
            if (version >= 2) {
                customPayloadSerializerClassName = Snapshot.readNullableString(dataInputView);
            }
            this.messageFactoryKey = MessageFactoryKey.forType(messageFactoryType, customPayloadSerializerClassName);
        }

        public TypeSerializer<Message> restoreSerializer() {
            return new MessageTypeSerializer(this.messageFactoryKey);
        }

        public TypeSerializerSchemaCompatibility<Message> resolveSchemaCompatibility(TypeSerializer<Message> typeSerializer) {
            if (!(typeSerializer instanceof MessageTypeSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            MessageTypeSerializer casted = (MessageTypeSerializer)typeSerializer;
            if (casted.messageFactoryKey.equals(this.messageFactoryKey)) {
                return TypeSerializerSchemaCompatibility.compatibleAsIs();
            }
            return TypeSerializerSchemaCompatibility.incompatible();
        }

        private static void writeNullableString(String value, DataOutputView out) throws IOException {
            if (value != null) {
                out.writeBoolean(true);
                out.writeUTF(value);
            } else {
                out.writeBoolean(false);
            }
        }

        private static String readNullableString(DataInputView in) throws IOException {
            boolean isPresent = in.readBoolean();
            if (isPresent) {
                return in.readUTF();
            }
            return null;
        }
    }
}

