/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelDuplexHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPromise;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.util.ReferenceCountUtil;
import org.apache.flink.statefun.flink.core.nettyclient.NettyHeaders;
import org.apache.flink.statefun.flink.core.nettyclient.NettyProtobuf;
import org.apache.flink.statefun.flink.core.nettyclient.NettyRequest;
import org.apache.flink.statefun.flink.core.nettyclient.NettyRequestTimeoutTask;
import org.apache.flink.statefun.flink.core.nettyclient.exceptions.DisconnectedException;
import org.apache.flink.statefun.flink.core.nettyclient.exceptions.WrongHttpResponse;
import org.apache.flink.statefun.sdk.reqreply.generated.FromFunction;
import org.apache.flink.util.Preconditions;

public final class NettyRequestReplyHandler
extends ChannelDuplexHandler {
    private final NettyRequestTimeoutTask requestDurationTracker = new NettyRequestTimeoutTask(this);
    @Nullable
    private NettyRequest inflightRequest;
    @Nullable
    private DefaultHttpHeaders cachedHeaders;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof NettyRequest)) {
            super.write(ctx, msg, promise);
            return;
        }
        NettyRequest request = (NettyRequest)msg;
        if (this.inflightRequest != null) {
            IllegalStateException cause = new IllegalStateException("A Channel has not finished the previous request.");
            request.completeAttemptExceptionally(cause);
            this.exceptionCaught(ctx, cause);
            return;
        }
        this.inflightRequest = request;
        ByteBuf content = null;
        try {
            content = NettyProtobuf.serializeProtobuf(arg_0 -> ((ByteBufAllocator)ctx.channel().alloc()).buffer(arg_0), request.toFunction());
            this.writeHttpRequest(ctx, content, request);
            this.scheduleRequestTimeout(ctx, request.remainingRequestBudgetNanos());
        }
        catch (Throwable t) {
            ReferenceCountUtil.safeRelease(content);
            this.exceptionCaught(ctx, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object message) {
        FullHttpResponse response = message instanceof FullHttpResponse ? (FullHttpResponse)message : null;
        try {
            this.readHttpMessage(response);
        }
        catch (Throwable t) {
            this.exceptionCaught(ctx, t);
        }
        finally {
            ReferenceCountUtil.release((Object)response);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.requestDurationTracker.cancel();
        if (!ctx.channel().isActive()) {
            this.tryComplete(null, cause);
        } else {
            ctx.channel().close().addListener(ignored -> this.tryComplete(null, cause));
        }
    }

    private void writeHttpRequest(ChannelHandlerContext ctx, ByteBuf bodyBuf, NettyRequest req) {
        DefaultFullHttpRequest http = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, req.uri(), bodyBuf, (HttpHeaders)this.headers(req, bodyBuf), (HttpHeaders)NettyHeaders.EMPTY);
        ctx.writeAndFlush((Object)http);
    }

    private DefaultHttpHeaders headers(NettyRequest req, ByteBuf bodyBuf) {
        DefaultHttpHeaders headers;
        if (this.cachedHeaders != null) {
            headers = this.cachedHeaders;
        } else {
            headers = new DefaultHttpHeaders(false);
            headers.add((HttpHeaders)req.headers());
            this.cachedHeaders = headers;
        }
        headers.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        headers.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bodyBuf.readableBytes());
        return headers;
    }

    private void readHttpMessage(FullHttpResponse response) {
        NettyRequest current = this.inflightRequest;
        Preconditions.checkState((current != null ? 1 : 0) != 0, (Object)"A read without a request");
        this.requestDurationTracker.cancel();
        Preconditions.checkState((response != null ? 1 : 0) != 0, (Object)"Unexpected message type");
        this.validateFullHttpResponse(response);
        FromFunction fromFn = NettyProtobuf.deserializeProtobuf(response.content(), FromFunction.parser());
        this.tryComplete(fromFn, null);
    }

    public void onReleaseToPool() {
        this.requestDurationTracker.cancel();
        this.inflightRequest = null;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.requestDurationTracker.cancel();
        this.tryComplete(null, DisconnectedException.INSTANCE);
        super.channelInactive(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.requestDurationTracker.cancel();
        super.channelUnregistered(ctx);
    }

    private void validateFullHttpResponse(FullHttpResponse response) {
        int code = response.status().code();
        if (code < 200 || code >= 300) {
            String message = "Unexpected response code " + code + " (" + response.status().reasonPhrase() + ") ";
            throw new WrongHttpResponse(message);
        }
        boolean correctContentType = response.headers().containsValue((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_OCTET_STREAM, true);
        if (!correctContentType) {
            String gotContentType = response.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            throw new IllegalStateException("Unexpected content type " + gotContentType);
        }
        Preconditions.checkState((response.content() != null ? 1 : 0) != 0, (Object)"Unexpected empty HTTP response (no body)");
    }

    private void scheduleRequestTimeout(ChannelHandlerContext ctx, long remainingRequestBudgetNanos) {
        long minRequestDurationJitteredNanos = ThreadLocalRandom.current().nextLong(7000000L, 13000000L);
        long remainingRequestBudget = Math.max(minRequestDurationJitteredNanos, remainingRequestBudgetNanos);
        this.requestDurationTracker.schedule(ctx, remainingRequestBudget);
    }

    private void tryComplete(FromFunction response, Throwable cause) {
        NettyRequest current = this.inflightRequest;
        if (current == null) {
            return;
        }
        this.inflightRequest = null;
        if (cause != null) {
            current.completeAttemptExceptionally(cause);
        } else {
            current.complete(response);
        }
    }
}

