/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.translation;

import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.statefun.flink.core.StatefulFunctionsConfig;
import org.apache.flink.statefun.flink.core.common.KeyBy;
import org.apache.flink.statefun.flink.core.common.SerializableFunction;
import org.apache.flink.statefun.flink.core.feedback.FeedbackKey;
import org.apache.flink.statefun.flink.core.feedback.FeedbackSinkOperator;
import org.apache.flink.statefun.flink.core.feedback.FeedbackUnionOperatorFactory;
import org.apache.flink.statefun.flink.core.functions.FunctionGroupDispatchFactory;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.MessageKeySelector;
import org.apache.flink.statefun.flink.core.translation.CheckpointToMessage;
import org.apache.flink.statefun.flink.core.translation.Sinks;
import org.apache.flink.statefun.flink.core.translation.Sources;
import org.apache.flink.statefun.sdk.io.EgressIdentifier;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamUtils;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.util.OutputTag;

final class StatefulFunctionTranslator {
    private final FeedbackKey<Message> feedbackKey;
    private final StatefulFunctionsConfig configuration;

    StatefulFunctionTranslator(FeedbackKey<Message> feedbackKey, StatefulFunctionsConfig configuration) {
        this.feedbackKey = Objects.requireNonNull(feedbackKey);
        this.configuration = Objects.requireNonNull(configuration);
    }

    Map<EgressIdentifier<?>, DataStream<?>> translate(Sources sources, Sinks sinks) {
        SingleOutputStreamOperator<Message> feedbackUnionOperator = this.feedbackUnionOperator(sources.unionStream());
        SingleOutputStreamOperator<Message> functionOutputStream = this.functionOperator((DataStream<Message>)feedbackUnionOperator, sinks.sideOutputTags());
        SingleOutputStreamOperator<Void> writeBackOut = this.feedbackOperator(functionOutputStream);
        this.coLocate((DataStream<?>)feedbackUnionOperator, (DataStream<?>)functionOutputStream, (DataStream<?>)writeBackOut);
        return sinks.sideOutputStreams(functionOutputStream);
    }

    private SingleOutputStreamOperator<Message> feedbackUnionOperator(DataStream<Message> input) {
        TypeInformation typeInfo = input.getType();
        FeedbackUnionOperatorFactory<Message> factory = new FeedbackUnionOperatorFactory<Message>(this.configuration, this.feedbackKey, new IsCheckpointBarrier(), new FeedbackKeySelector());
        return input.keyBy((KeySelector)new MessageKeySelector()).transform("feedback-union", typeInfo, factory).uid("feedback_union_uid1");
    }

    private SingleOutputStreamOperator<Message> functionOperator(DataStream<Message> input, Map<EgressIdentifier<?>, OutputTag<Object>> sideOutputs) {
        TypeInformation typeInfo = input.getType();
        FunctionGroupDispatchFactory operatorFactory = new FunctionGroupDispatchFactory(this.configuration, sideOutputs);
        return DataStreamUtils.reinterpretAsKeyedStream(input, (KeySelector)new MessageKeySelector()).transform("functions", typeInfo, (OneInputStreamOperatorFactory)operatorFactory).uid("functions_uid1");
    }

    private SingleOutputStreamOperator<Void> feedbackOperator(SingleOutputStreamOperator<Message> functionOut) {
        CheckpointToMessage toMessage = new CheckpointToMessage(this.configuration.getFactoryKey());
        FeedbackSinkOperator<Message> sinkOperator = new FeedbackSinkOperator<Message>(this.feedbackKey, toMessage);
        return functionOut.keyBy((KeySelector)new MessageKeySelector()).transform("feedback", TypeInformation.of(Void.class), sinkOperator).uid("feedback_uid1");
    }

    private void coLocate(DataStream<?> a, DataStream<?> b, DataStream<?> c) {
        String stringKey = this.feedbackKey.asColocationKey();
        a.getTransformation().setCoLocationGroupKey(stringKey);
        b.getTransformation().setCoLocationGroupKey(stringKey);
        c.getTransformation().setCoLocationGroupKey(stringKey);
        a.getTransformation().setParallelism(b.getParallelism());
        c.getTransformation().setParallelism(b.getParallelism());
    }

    private static final class FeedbackKeySelector
    implements SerializableFunction<Message, String> {
        private static final long serialVersionUID = 1L;

        private FeedbackKeySelector() {
        }

        @Override
        public String apply(Message message) {
            return KeyBy.apply(message.target());
        }
    }

    private static final class IsCheckpointBarrier
    implements SerializableFunction<Message, OptionalLong> {
        private static final long serialVersionUID = 1L;

        private IsCheckpointBarrier() {
        }

        @Override
        public OptionalLong apply(Message message) {
            return message.isBarrierMessage();
        }
    }
}

