/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import org.apache.flink.ml.feature.interaction.Interaction;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class InteractionExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{0, Vectors.dense((double[])new double[]{1.1, 3.2}), Vectors.dense((double[])new double[]{2.0, 3.0})}), Row.of((Object[])new Object[]{1, Vectors.dense((double[])new double[]{2.1, 3.1}), Vectors.dense((double[])new double[]{1.0, 3.0})})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("f0", new String[]{"f1", "f2"});
        Interaction interaction = (Interaction)((Interaction)new Interaction().setInputCols(new String[]{"f0", "f1", "f2"})).setOutputCol("outputVec");
        Table outputTable = interaction.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Object[] inputValues = new Object[interaction.getInputCols().length];
            for (int i = 0; i < inputValues.length; ++i) {
                inputValues[i] = row.getField(interaction.getInputCols()[i]);
            }
            Vector outputValue = (Vector)row.getField(interaction.getOutputCol());
            System.out.printf("Input Values: %s \tOutput Value: %s\n", Arrays.toString(inputValues), outputValue);
        }
    }
}

