/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import org.apache.flink.ml.feature.univariatefeatureselector.UnivariateFeatureSelector;
import org.apache.flink.ml.feature.univariatefeatureselector.UnivariateFeatureSelectorModel;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class UnivariateFeatureSelectorExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource trainStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{1.7, 4.4, 7.6, 5.8, 9.6, 2.3}), 3.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{8.8, 7.3, 5.7, 7.3, 2.2, 4.1}), 2.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{1.2, 9.5, 2.5, 3.1, 8.7, 2.5}), 1.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{3.7, 9.2, 6.1, 4.1, 7.5, 3.8}), 2.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{8.9, 5.2, 7.8, 8.3, 5.2, 3.0}), 4.0}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{7.9, 8.5, 9.2, 4.0, 9.4, 2.1}), 4.0})});
        Table trainTable = tEnv.fromDataStream((DataStream)trainStream).as("features", new String[]{"label"});
        UnivariateFeatureSelector univariateFeatureSelector = (UnivariateFeatureSelector)((UnivariateFeatureSelector)((UnivariateFeatureSelector)((UnivariateFeatureSelector)((UnivariateFeatureSelector)new UnivariateFeatureSelector().setFeaturesCol("features")).setLabelCol("label")).setFeatureType("continuous")).setLabelType("categorical")).setSelectionThreshold(1.0);
        UnivariateFeatureSelectorModel model = univariateFeatureSelector.fit(new Table[]{trainTable});
        Table outputTable = model.transform(new Table[]{trainTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            DenseVector inputValue = (DenseVector)row.getField(univariateFeatureSelector.getFeaturesCol());
            DenseVector outputValue = (DenseVector)row.getField(univariateFeatureSelector.getOutputCol());
            System.out.printf("Input Value: %-15s\tOutput Value: %s\n", inputValue, outputValue);
        }
    }
}

