/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.broadcast;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.broadcast.BroadcastOutput;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class RecordWriterBroadcastOutput<OUT>
implements BroadcastOutput<OUT> {
    private final RecordWriter<SerializationDelegate<StreamElement>> recordWriter;
    private final SerializationDelegate<StreamElement> serializationDelegate;

    public RecordWriterBroadcastOutput(RecordWriter<SerializationDelegate<StreamElement>> recordWriter, TypeSerializer<StreamElement> typeSerializer) {
        this.recordWriter = recordWriter;
        this.serializationDelegate = new SerializationDelegate(typeSerializer);
    }

    @Override
    public void broadcastEmit(StreamRecord<OUT> record) throws IOException {
        this.serializationDelegate.setInstance(record);
        this.recordWriter.broadcastEmit(this.serializationDelegate);
        if (RecordWriterBroadcastOutput.isIterationEpochWatermark(record)) {
            this.recordWriter.flushAll();
        }
    }

    private static <T> boolean isIterationEpochWatermark(StreamRecord<T> record) {
        if (!(record.getValue() instanceof IterationRecord)) {
            return false;
        }
        IterationRecord iterationRecord = (IterationRecord)record.getValue();
        return iterationRecord.getType().equals((Object)IterationRecord.Type.EPOCH_WATERMARK);
    }
}

