/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class ReflectionUtils {
    public static Field getClassField(Class<?> declaredClass, String fieldName) {
        try {
            Field field = declaredClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get field" + fieldName + " from " + declaredClass, e);
        }
    }

    public static <T> T getFieldValue(Object targetObject, Field field) {
        try {
            return (T)field.get(targetObject);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get field " + field.getName() + " from " + targetObject, e);
        }
    }

    public static <T> T getFieldValue(Object targetObject, Class<?> declaredClass, String fieldName) {
        Field field = ReflectionUtils.getClassField(declaredClass, fieldName);
        return ReflectionUtils.getFieldValue(targetObject, field);
    }

    public static <T> T callMethod(Object targetObject, Class<?> declaredClass, String methodName) {
        return ReflectionUtils.callMethod(targetObject, declaredClass, methodName, Collections.emptyList(), Collections.emptyList());
    }

    public static <T> T callMethod(Object targetObject, Class<?> declaredClass, String methodName, List<Class<?>> parameterClass, List<Object> parameters) {
        try {
            Method method = declaredClass.getDeclaredMethod(methodName, parameterClass.toArray(new Class[0]));
            method.setAccessible(true);
            return (T)method.invoke(targetObject, parameters.toArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get method" + methodName + " from " + targetObject, e);
        }
    }
}

