/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.builder;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.ml.api.AlgoOperator;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.servable.builder.PipelineModelServable;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class PipelineModel
implements Model<PipelineModel> {
    private static final long serialVersionUID = 6184950154217411318L;
    private final List<Stage<?>> stages;
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public PipelineModel(List<Stage<?>> stages) {
        this.stages = (List)Preconditions.checkNotNull(stages);
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        for (Stage<?> stage : this.stages) {
            inputs = ((AlgoOperator)stage).transform(inputs);
        }
        return inputs;
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.savePipeline(this, this.stages, path);
    }

    public static PipelineModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        return new PipelineModel(ReadWriteUtils.loadPipeline(tEnv, path, PipelineModel.class.getName()));
    }

    public static PipelineModelServable loadServable(String path) throws IOException {
        return PipelineModelServable.load(path);
    }

    public boolean supportServable() {
        for (Stage<?> stage : this.stages) {
            if (!(stage instanceof Transformer)) {
                return false;
            }
            Transformer transformer = (Transformer)stage;
            Class<?> clazz = transformer.getClass();
            try {
                clazz.getMethod("loadServable", String.class);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return true;
    }

    @VisibleForTesting
    List<Stage<?>> getStages() {
        return Collections.unmodifiableList(this.stages);
    }
}

