/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.classification.logisticregression;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorSerializer;

public class LogisticRegressionModelData {
    public DenseVector coefficient;
    public long modelVersion;

    public LogisticRegressionModelData() {
    }

    public LogisticRegressionModelData(DenseVector coefficient, long modelVersion) {
        this.coefficient = coefficient;
        this.modelVersion = modelVersion;
    }

    @VisibleForTesting
    public void encode(OutputStream outputStream) throws IOException {
        DataOutputViewStreamWrapper dataOutputViewStreamWrapper = new DataOutputViewStreamWrapper(outputStream);
        DenseVectorSerializer serializer = new DenseVectorSerializer();
        serializer.serialize(this.coefficient, (DataOutputView)dataOutputViewStreamWrapper);
        dataOutputViewStreamWrapper.writeLong(this.modelVersion);
    }

    static LogisticRegressionModelData decode(InputStream inputStream) throws IOException {
        DataInputViewStreamWrapper dataInputViewStreamWrapper = new DataInputViewStreamWrapper(inputStream);
        DenseVectorSerializer serializer = new DenseVectorSerializer();
        DenseVector coefficient = serializer.deserialize((DataInputView)dataInputViewStreamWrapper);
        long modelVersion = dataInputViewStreamWrapper.readLong();
        return new LogisticRegressionModelData(coefficient, modelVersion);
    }
}

