/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.broadcast.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.iteration.operator.OperatorStateUtils;
import org.apache.flink.ml.common.broadcast.BroadcastContext;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.AbstractInput;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorV2;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.MultipleInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class BroadcastVariableReceiverOperator<OUT>
extends AbstractStreamOperatorV2<OUT>
implements MultipleInputStreamOperator<OUT>,
BoundedMultiInput,
Serializable {
    private final String[] broadcastStreamNames;
    private final TypeInformation<?>[] inTypes;
    private final List<Input> inputList;
    private boolean[] cachesReady;
    private ListState[] cacheStates;
    private ListState<Boolean>[] cacheReadyStates;

    BroadcastVariableReceiverOperator(StreamOperatorParameters<OUT> parameters, String[] broadcastStreamNames, TypeInformation<?>[] inTypes) {
        super(parameters, broadcastStreamNames.length);
        this.broadcastStreamNames = broadcastStreamNames;
        this.inTypes = inTypes;
        this.inputList = new ArrayList<Input>();
        for (int i = 0; i < inTypes.length; ++i) {
            this.inputList.add((Input)new ProxyInput(this, i + 1));
        }
        this.cachesReady = new boolean[inTypes.length];
        this.cacheStates = new ListState[inTypes.length];
        this.cacheReadyStates = new ListState[inTypes.length];
    }

    public List<Input> getInputs() {
        return this.inputList;
    }

    public void endInput(int i) throws Exception {
        this.cachesReady[i - 1] = true;
        String key = this.broadcastStreamNames[i - 1] + "-" + this.getRuntimeContext().getIndexOfThisSubtask();
        BroadcastContext.putBroadcastVariable(key, Tuple2.of((Object)true, (Object)IteratorUtils.toList(((Iterable)this.cacheStates[i - 1].get()).iterator())));
        BroadcastContext.notifyCacheFinished(key);
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        for (int i = 0; i < this.inTypes.length; ++i) {
            this.cacheReadyStates[i].clear();
            this.cacheReadyStates[i].add((Object)this.cachesReady[i]);
        }
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        for (int i = 0; i < this.inTypes.length; ++i) {
            this.cacheStates[i] = context.getOperatorStateStore().getListState(new ListStateDescriptor("cache_data_" + i, this.inTypes[i]));
            this.cacheReadyStates[i] = context.getOperatorStateStore().getListState(new ListStateDescriptor("cache_ready_state_" + i, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO));
            boolean cacheReady = OperatorStateUtils.getUniqueElement(this.cacheReadyStates[i], "cache_ready_state_" + i).orElse(false);
            BroadcastContext.putBroadcastVariable(this.broadcastStreamNames[i] + "-" + this.getRuntimeContext().getIndexOfThisSubtask(), Tuple2.of((Object)cacheReady, (Object)IteratorUtils.toList(((Iterable)this.cacheStates[i].get()).iterator())));
        }
    }

    private class ProxyInput<IN, OT>
    extends AbstractInput<IN, OT> {
        public ProxyInput(AbstractStreamOperatorV2<OT> owner, int inputId) {
            super(owner, inputId);
        }

        public void processElement(StreamRecord<IN> element) throws Exception {
            BroadcastVariableReceiverOperator.this.cacheStates[this.inputId - 1].add(element.getValue());
        }
    }
}

