/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.optimizer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;

@Internal
class RegularizationUtils {
    RegularizationUtils() {
    }

    public static double regularize(DenseVector coefficient, double reg, double elasticNet, double learningRate) {
        if (Double.compare(reg, 0.0) == 0) {
            return 0.0;
        }
        if (Double.compare(elasticNet, 0.0) == 0) {
            double loss = reg / 2.0 * BLAS.norm2((Vector)coefficient);
            BLAS.scal(1.0 - learningRate * reg, coefficient);
            return loss;
        }
        if (Double.compare(elasticNet, 1.0) == 0) {
            double loss = 0.0;
            double[] coefficientArray = coefficient.values;
            for (int i = 0; i < coefficientArray.length; ++i) {
                if (Double.compare(coefficientArray[i], 0.0) == 0) continue;
                loss += elasticNet * reg * Math.signum(coefficientArray[i]);
                int n = i;
                coefficientArray[n] = coefficientArray[n] - learningRate * elasticNet * reg * Math.signum(coefficientArray[i]);
            }
            return loss;
        }
        double loss = 0.0;
        double[] coefficientArray = coefficient.values;
        for (int i = 0; i < coefficientArray.length; ++i) {
            loss += elasticNet * reg * Math.signum(coefficientArray[i]) + (1.0 - elasticNet) * (reg / 2.0) * coefficientArray[i] * coefficientArray[i];
            int n = i;
            coefficientArray[n] = coefficientArray[n] - learningRate * (elasticNet * reg * Math.signum(coefficientArray[i]) + (1.0 - elasticNet) * reg * coefficientArray[i]);
        }
        return loss;
    }
}

