/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.util;

import java.util.ArrayList;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;

public class VectorUtils {
    public static Vector selectByIndices(Vector vector, int[] sortedIndices) {
        if (vector instanceof DenseVector) {
            DenseVector resultVec = new DenseVector(sortedIndices.length);
            for (int i = 0; i < sortedIndices.length; ++i) {
                resultVec.set(i, vector.get(sortedIndices[i]));
            }
            return resultVec;
        }
        ArrayList<Integer> resultIndices = new ArrayList<Integer>();
        ArrayList<Double> resultValues = new ArrayList<Double>();
        int[] indices = ((SparseVector)vector).indices;
        int i = 0;
        int j = 0;
        while (i < indices.length && j < sortedIndices.length) {
            if (indices[i] == sortedIndices[j]) {
                resultIndices.add(j++);
                resultValues.add(((SparseVector)vector).values[i++]);
                continue;
            }
            if (indices[i] > sortedIndices[j]) {
                ++j;
                continue;
            }
            ++i;
        }
        return new SparseVector(sortedIndices.length, resultIndices.stream().mapToInt(Integer::intValue).toArray(), resultValues.stream().mapToDouble(Double::doubleValue).toArray());
    }
}

