/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.randomsplitter;

import org.apache.flink.ml.common.param.HasSeed;
import org.apache.flink.ml.param.DoubleArrayParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidator;

public interface RandomSplitterParams<T>
extends HasSeed<T> {
    public static final Param<Double[]> WEIGHTS = new DoubleArrayParam("weights", "The weights of data splitting.", new Double[]{1.0, 1.0}, RandomSplitterParams.weightsValidator());

    default public T setWeights(Double ... value) {
        return this.set(WEIGHTS, value);
    }

    default public Double[] getWeights() {
        return this.get(WEIGHTS);
    }

    public static ParamValidator<Double[]> weightsValidator() {
        return weights -> {
            if (weights == null) {
                return false;
            }
            for (Double weight : weights) {
                if (!(weight <= 0.0)) continue;
                return false;
            }
            return ((Double[])weights).length > 1;
        };
    }
}

