/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import org.apache.flink.ml.feature.binarizer.Binarizer;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class BinarizerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{1, Vectors.dense((double[])new double[]{1.0, 2.0}), Vectors.sparse((int)17, (int[])new int[]{0, 3, 9}, (double[])new double[]{1.0, 2.0, 7.0})}), Row.of((Object[])new Object[]{2, Vectors.dense((double[])new double[]{2.0, 1.0}), Vectors.sparse((int)17, (int[])new int[]{0, 2, 14}, (double[])new double[]{5.0, 4.0, 1.0})}), Row.of((Object[])new Object[]{3, Vectors.dense((double[])new double[]{5.0, 18.0}), Vectors.sparse((int)17, (int[])new int[]{0, 11, 12}, (double[])new double[]{2.0, 4.0, 4.0})})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("f0", new String[]{"f1", "f2"});
        Binarizer binarizer = (Binarizer)((Binarizer)((Binarizer)new Binarizer().setInputCols(new String[]{"f0", "f1", "f2"})).setOutputCols(new String[]{"of0", "of1", "of2"})).setThresholds(new Double[]{0.0, 0.0, 0.0});
        Table outputTable = binarizer.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Object[] inputValues = new Object[binarizer.getInputCols().length];
            Object[] outputValues = new Object[binarizer.getInputCols().length];
            for (int i = 0; i < inputValues.length; ++i) {
                inputValues[i] = row.getField(binarizer.getInputCols()[i]);
                outputValues[i] = row.getField(binarizer.getOutputCols()[i]);
            }
            System.out.printf("Input Values: %s\tOutput Values: %s\n", Arrays.toString(inputValues), Arrays.toString(outputValues));
        }
    }
}

