/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import org.apache.flink.ml.feature.vectorassembler.VectorAssembler;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class VectorAssemblerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.1, 3.1}), 1.0, Vectors.sparse((int)5, (int[])new int[]{3}, (double[])new double[]{1.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.1, 3.1}), 1.0, Vectors.sparse((int)5, (int[])new int[]{4, 2, 3, 1}, (double[])new double[]{4.0, 2.0, 3.0, 1.0})})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("vec", new String[]{"num", "sparseVec"});
        VectorAssembler vectorAssembler = (VectorAssembler)((VectorAssembler)((VectorAssembler)new VectorAssembler().setInputCols(new String[]{"vec", "num", "sparseVec"})).setOutputCol("assembledVec")).setInputSizes(new Integer[]{2, 1, 5});
        Table outputTable = vectorAssembler.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Object[] inputValues = new Object[vectorAssembler.getInputCols().length];
            for (int i = 0; i < inputValues.length; ++i) {
                inputValues[i] = row.getField(vectorAssembler.getInputCols()[i]);
            }
            Vector outputValue = (Vector)row.getField(vectorAssembler.getOutputCol());
            System.out.printf("Input Values: %s \tOutput Value: %s\n", Arrays.toString(inputValues), outputValue);
        }
    }
}

