/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.broadcast;

import java.util.ArrayList;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.iteration.broadcast.BroadcastOutput;
import org.apache.flink.iteration.broadcast.ChainingBroadcastOutput;
import org.apache.flink.iteration.broadcast.CountingBroadcastOutput;
import org.apache.flink.iteration.broadcast.OutputReflectionContext;
import org.apache.flink.iteration.broadcast.RecordWriterBroadcastOutput;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.OutputTag;

public class BroadcastOutputFactory {
    public static <OUT> BroadcastOutput<OUT> createBroadcastOutput(Output<StreamRecord<OUT>> output, Counter numRecordsOut) {
        OutputReflectionContext outputReflectionContext = new OutputReflectionContext();
        if (outputReflectionContext.isCountingOutput(output)) {
            output = outputReflectionContext.getCountingInternalOutput(output);
        }
        ArrayList internalOutputs = new ArrayList();
        if (outputReflectionContext.isBroadcastingOutput(output)) {
            Output<StreamRecord<OUT>>[] rawOutputs;
            for (Output rawOutput : rawOutputs = outputReflectionContext.getBroadcastingInternalOutputs(output)) {
                internalOutputs.add(BroadcastOutputFactory.createInternalBroadcastOutput(rawOutput, outputReflectionContext));
            }
        } else {
            internalOutputs.add(BroadcastOutputFactory.createInternalBroadcastOutput(output, outputReflectionContext));
        }
        return new CountingBroadcastOutput(numRecordsOut, internalOutputs);
    }

    private static <OUT> BroadcastOutput<OUT> createInternalBroadcastOutput(Output<StreamRecord<OUT>> rawOutput, OutputReflectionContext outputReflectionContext) {
        if (outputReflectionContext.isChainingOutput(rawOutput)) {
            OutputTag<?> outputTag = outputReflectionContext.getChainingOutputTag(rawOutput);
            return new ChainingBroadcastOutput<OUT>(rawOutput, outputTag);
        }
        if (outputReflectionContext.isRecordWriterOutput(rawOutput)) {
            RecordWriter<SerializationDelegate<StreamElement>> recordWriter = outputReflectionContext.getRecordWriter(rawOutput);
            TypeSerializer<StreamElement> typeSerializer = outputReflectionContext.getRecordWriterTypeSerializer(rawOutput);
            return new RecordWriterBroadcastOutput(recordWriter, typeSerializer);
        }
        throw new RuntimeException("Unknown output type: " + rawOutput.getClass());
    }
}

