/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.compile;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.operators.SlotSharingGroup;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.iteration.operator.OperatorWrapper;

public interface DraftTransformationTranslator<TF extends Transformation<?>> {
    public Transformation<?> translate(TF var1, OperatorWrapper<?, ?> var2, Context var3);

    public static interface Context {
        public Transformation<?> getActualTransformation(int var1);

        public ExecutionConfig getExecutionConfig();

        default public Transformation<?> copyProperties(Transformation<?> actual, Transformation<?> draft) {
            actual.setName(draft.getName());
            actual.setParallelism(draft.getParallelism());
            if (draft.getMaxParallelism() > 0) {
                actual.setMaxParallelism(draft.getMaxParallelism());
            }
            if (draft.getBufferTimeout() > 0L) {
                actual.setBufferTimeout(draft.getBufferTimeout());
            }
            if (draft.getSlotSharingGroup().isPresent()) {
                actual.setSlotSharingGroup((SlotSharingGroup)draft.getSlotSharingGroup().get());
            }
            actual.setCoLocationGroupKey(draft.getCoLocationGroupKey());
            actual.setUid(draft.getUid());
            if (draft.getUserProvidedNodeHash() != null) {
                actual.setUidHash(draft.getUserProvidedNodeHash());
            }
            draft.getManagedMemoryOperatorScopeUseCaseWeights().forEach((arg_0, arg_1) -> actual.declareManagedMemoryUseCaseAtOperatorScope(arg_0, arg_1));
            draft.getManagedMemorySlotScopeUseCases().forEach(arg_0 -> actual.declareManagedMemoryUseCaseAtSlotScope(arg_0));
            return actual;
        }
    }
}

